/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ep8m
 */

package  
{
	/**
	 * Wonderfl から Wonderfl に対応していないライブラリをモジュール経由で読めるのでは？
	 * 
	 * 外部のモジュールは読めるじゃないですか。
	 * 
	 * ->自作ライブラリですがモジュール経由で使用できました
	 * http://wonderfl.kayac.com/code/f23a54c6e3ca13bade73c39e9f4577c07ebd73eb
	 * 
	 * モジュールの Base64 ストリングでの埋め込みと、そのモジュール経由でライブラリを使う方法 
	 * http://wonderfl.kayac.com/code/e917c00d8f297bb8b50e8f9f7880c883dbf1c906
	 * 
	 * 
	 * 参考
	 * 
	 * モジュールの作成 
	 * http://livedocs.adobe.com/flex/3_jp/html/help.html?content=modular_3.html
	 * 
	 * モジュールのロードとアンロード
	 * http://livedocs.adobe.com/flex/3_jp/html/help.html?content=modular_5.html
	 */
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import mx.modules.IModuleInfo;
	import mx.modules.ModuleManager;
	
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite
	{
		public var assetModule:IModuleInfo;
		private var textField:TextField;
		public function Main() 
		{
			assetModule = ModuleManager.getModule("http://cross.gentenzero.com/wonderfl/module/module.swf");
			assetModule.addEventListener("ready", getModuleInstance);
			assetModule.load();
			textField = new TextField();
			addChild( textField );
		}
		public function getModuleInstance(event:Event):void {
			var module:Object = assetModule.factory.create() as Object;
			textField.text = ( new module.a() ).name;
		}
	}
	
}

/*
外部に公開しているモジュールのソース

package  
{
	import com.tkinjo.moduletest.A;
	import mx.modules.ModuleBase;
	
	public class Module extends ModuleBase
	{
		public function get a():Class {
			return A;
		}
	}
}

package com.tkinjo.moduletest 
{
	public class A
	{
		public function get name():String {
			return "A";
		}
	}
}
*/