/**
 * Copyright shen_0_ ( http://wonderfl.net/user/shen_0_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eoUD
 */

package {

    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.text.TextField;


    [SWF(width=465, height=465, backgroundColor="#123456")]
    public class Railgun extends Sprite {        

        public static var DEBUG:Boolean=false;

        public function Railgun() {
            Wonderfl.disable_capture();

            myTitle01();
            myTitle02();
        }

        

        private function myTitle01():void{

            DEBUG=false;//debug model

            var all:Sprite=new Sprite();

            var bg01:Shape=new Shape();

            createGradient(bg01, [0xFF1A05, 0xF78B64], 250, 150, -30);

            

            var title01:Sprite=new Sprite();

            

            var line01:Line=new Line(title01, 0, 100);

            line01.createBlock(0, 0, 56, "と");

            line01.createBlock(-20, -5, 35, "あ");

            line01.createBlock(-20,-20,25,"る");

            line01.createBlock(-15,-3,55,"科");

            line01.createBlock(-10,-5,45,"学");

            line01.createBlock(-10,0,50,"の");

            

            var line02:Line=new Line(all, 26, 100, 0, 2);

            line02.setColor(0xffffff);

            var bgt:TextField=line02.createBlock(5,-8,45,"超");

            

            var sign:Shape=new Shape();

            sign.graphics.beginFill(0);

            sign.graphics.drawRect(bgt.x+2, bgt.y+2, bgt.width-4, bgt.height-5);

            sign.graphics.endFill();

            title01.addChild(sign);

            

            var line02_1:Line=new Line(title01, 90, 87, 0, 2);

            line02_1.createBlock(-10,0,40,"電");

            line02_1.createBlock(-10,0,40,"磁");

            line02_1.createBlock(-8,0,55,"砲");

            var line03:Line=new Line(title01, 83, 143);

            line03.createBlock(0,0,14,"レールガン");

            

            

            //mask

            bg01.cacheAsBitmap=true;

            title01.cacheAsBitmap=true;

            bg01.mask=title01;

            

            //filter

            bg01.filters=[new GlowFilter(0xffffff, 1, 4, 4, 8)];

            

            

            //sky 天空

            var sky:Shape=new Shape();

            sky.y=10;

            createGradient(sky, [0xC1F8F3, 0x2777AC], 400, 150, 30, [0x0, 0x99]);

            all.addChild(sky);

            all.addChild(bg01);

            all.addChild(title01);

            all.addChild(bgt);

            addChild(all);

            

            all.y=100;

        }

        

        

        private function myTitle02():void{

            DEBUG=false;//debug model

            var all:Sprite=new Sprite();

            var bg01:Shape=new Shape();

            createGradient(bg01, [0xCE0027, 0xD38A3D], 140, 300, -60);

            

            var title01:Sprite=new Sprite();

            

            var line01:Line=new Line(title01, 100, 0, 1, 1);

            line01.createBlock(0, 0, 56, "と");

            line01.createBlock(10, -12, 35, "あ");

            line01.createBlock(-10, -25, 32, "る");

            line01.createBlock(0, -10, 55, "科");

            line01.createBlock(0, -8, 55, "学");

            line01.createBlock(0, -15, 55, "の");

            

            var line02:Line=new Line(all, 75, 55, 1, 2);

            line02.setColor(0xffffff);

            var bgt:TextField=line02.createBlock(0,0,60,"超");

            

            var sign:Shape=new Shape();

            sign.graphics.beginFill(0);

            sign.graphics.drawRect(bgt.x+2, bgt.y+3, bgt.width-4, bgt.height-5);

            sign.graphics.endFill();

            title01.addChild(sign);

            

            var line02_1:Line=new Line(title01, 85, 115, 1, 2);

            line02_1.createBlock(-7,0,45,"電");

            line02_1.createBlock(-7,-10,50,"磁");

            line02_1.createBlock(-7,-10,63,"砲");

            var line03:Line=new Line(title01, 10, 118, 1);

            line03.setLeading(4);

            line03.createBlock(0,0,14,"レールガン");

            

            

            //mask

            bg01.cacheAsBitmap=true;

            title01.cacheAsBitmap=true;

            bg01.mask=title01;

            

            

            var bg:Shape=new Shape();

            bg.graphics.beginFill(0xffffff);

            bg.graphics.drawRect(0,0,150, 400);

            bg.graphics.endFill();

            

            all.addChild(bg);

            all.addChild(bg01);

            all.addChild(title01);

            all.addChild(bgt);

            addChild(all);

            

            bg.x=-10;

            all.x=300;

        }

        

        

        /**

         * 渐变制作

         */

        private function createGradient(bg:Shape, colors:Array, w:uint=100, h:uint=100, rotation:Number=0, ratios:Array=null):void{

            var type:String = GradientType.LINEAR;

            var alphas:Array = [1, 1];

            if(!ratios){

                ratios = [0x00, 0xFF];

            }

            var m:Matrix = new Matrix();

            m.createGradientBox(w, h, rotation*Math.PI/180, 0, 0);

            var spreadMethod:String = SpreadMethod.PAD;

            bg.graphics.beginGradientFill(type,colors, alphas, ratios, m, spreadMethod);

            bg.graphics.drawRect(0,0,w,h);

        }



    }

}



import flash.display.DisplayObjectContainer;

import flash.display.Sprite;

import flash.text.TextField;

import flash.text.TextFormat;



class Line {

    public static const ALIGN_BOTTOM:int=0;//底部/左

    public static const ALIGN_CENTER:int=1;//中间

    public static const ALIGN_TOP:int=2;//顶部/右

    public static const DIR_HORIZONTAL:int=0; //平行

    public static const DIR_VERTICAL:int=1; //垂直



    private var display:DisplayObjectContainer;

    private var dir:int=0;//排版方向

    private var align:int=0;//对齐方式

    private var t_color:uint=0;//字体颜色

    private var t_leading:int=0;//垂直间距



    //offest

    private var tx:Number=0;

    private var ty:Number=0;



    /** 

     * @param parent

     * @param cx : start of the line

     * @param cy

     * @param lineDir

     * @param lneAlign

     * 

     */

    public function Line(displayer:DisplayObjectContainer, cx:Number=0, cy:Number=0, lineDir:int=0, lineAlign:int=0) {

        display=displayer;

        dir=lineDir;

        align=lineAlign;

        tx=cx;

        ty=cy;

    }



    /**

     * setting

     */

    public function createBlock(offestX:Number=0, offestY:Number=0, size:uint=10, text:String=""):TextField {

        var t:TextField=createText(text, size);

        if (dir == 0) {

            tx+=offestX;

            t.x=tx;

            tx+=t.width;

            

            if (align == 0) {

                t.y=ty - t.height + offestY;//底部

            } else if(align==1){

                t.y=ty - t.height*0.5 + offestY;//中

            }else{

                t.y=ty + offestY;//顶部

            }

        } else {

            ty+=offestY;

            t.y=ty;

            ty+=t.height;

            

            if (align == 0) {

                t.x=tx + offestX;//左

            } else if(align==1){

                t.x=tx - t.width*0.5 + offestX;//中

            }else{

                t.x=tx - t.width + offestX;//右

            }

        }

        display.addChild(t);

        return t;

    }

    

    public function setColor(c:uint):void{

        t_color=c;

    }

    

    public function setLeading(l:int):void{

        t_leading=l;

    }



    

    /**

     * text view and format

     */

    private function createText(text:String, size:uint):TextField {

        var t:TextField=new TextField();

        var tf:TextFormat=new TextFormat("MS Mincho", size);//_sans

        tf.bold=true;

        tf.color=t_color;

        tf.leading=t_leading;

        

        t.defaultTextFormat=tf;

        

        var tl:int=text.length;

        if(dir==1 && tl>1){

            var newText:String="";

            for(var i:int=0;i<tl;i++){

                newText+=text.charAt(i);

                if(i<tl-1){

                    newText+="\n";

                }

            }

            t.text=newText;

        }else{

            t.text=text;

        }

        

        

        t.selectable=false;

        t.mouseEnabled=false;

        t.mouseWheelEnabled=false;

        t.doubleClickEnabled=false;

        

        t.tabEnabled=false;

        t.multiline=true;

        t.wordWrap=false;

        

        t.width=t.textWidth + 5;

        t.height=t.textHeight + 5;

        t.border=Railgun.DEBUG;

        

        return t;

    }

}

