/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eoMh
 */

// Music: Wataridori 2 by Cornelius
//
// inspired by
//   camera of undefined
//      http://wonderfl.kayac.com/code/e30a7c4c5755fc45417a01d38f889774d3c640b3
//   音の波形を動力にアニメーション
//      http://ra66it.net/blog/index.php?ID=892

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.ContextMenuEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Camera;
	import flash.media.Sound;
	import flash.media.SoundMixer;
	import flash.media.Video;
	import flash.net.URLRequest;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	import flash.utils.ByteArray;
	import flash.system.Security;

	[SWF(width="465", height="465", backgroundColor="#ffffff", frameRate="30")] 

	public class Wataridori extends Sprite {

		private const BMD_WIDTH:int = 480;
		private const BMD_HEIGHT:int = 360;
		private var bmp:Bitmap;
		private var bmpd:BitmapData;
		private var matrix:Matrix = new Matrix();
		private var video:Video;

		public function Wataridori() {
			stage.align = "TL";
			stage.scaleMode = "noScale";

			var camera:Camera = Camera.getCamera();
			if (camera == null) return;
			camera.setMode(stage.stageWidth, stage.stageHeight, 15);
			video = new Video(stage.stageWidth, stage.stageHeight);
			video.attachCamera(camera);
			bmpd = new BitmapData(BMD_WIDTH, BMD_HEIGHT, false, 0xffffff);
			bmp = new Bitmap(bmpd);
			addChild(bmp);

			stage.addEventListener(Event.RESIZE, resize);
			stage.addEventListener(Event.ENTER_FRAME, update);
			resize();

			Security.loadPolicyFile("http://5ivestar.org/misc/crossdomain.xml");
			var sound:Sound = new Sound();
			sound.load(new URLRequest("http://5ivestar.org/misc/wataridori2.mp3"));
			sound.play();

			var menu:ContextMenu = new ContextMenu();
			var item:ContextMenuItem = new ContextMenuItem("Full Screen");
			contextMenu = menu;
			menu.hideBuiltInItems();
			menu.customItems.push(item);
			menu.addEventListener(ContextMenuEvent.MENU_SELECT, function(e:ContextMenuEvent):void {
				switch (stage.displayState) {
					case "normal":
						item.enabled = true;
						break;
					case "fullScreen":
						item.enabled = false;
						break;
				}
			});
			item.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function(e:ContextMenuEvent):void {
				stage.displayState = "fullScreen";
			});
		}

		public function resize(e:Event=null):void {
			matrix.identity();
			matrix.scale(BMD_WIDTH / video.width, BMD_HEIGHT / video.height);
			trace(matrix);
			bmp.scaleX = stage.stageWidth / BMD_WIDTH;
			bmp.scaleY = stage.stageHeight / BMD_HEIGHT;
			bmp.x = bmp.y = 0;
		}

		public function update(e:Event):void {
			var source:BitmapData = new BitmapData(BMD_WIDTH, BMD_HEIGHT, false, 0xffffff);
			source.draw(video, matrix);

			var bytes:ByteArray = new ByteArray();
			SoundMixer.computeSpectrum(bytes);
			var offsets:Array = [];
			for (var i:int = 0; i < 256; i++) {
				var v:Number = bytes.readFloat();
				if (!(i % 100)) offsets.push(v * BMD_WIDTH * 0.06);
			}
			var n:Number = 0;
			for each (var o:Number in offsets) n += Math.abs(o);
			n = Math.pow(n / 2, 2);
			i = BMD_HEIGHT;
			while (i--) {
				var offset:Number = Math.sin(i / BMD_HEIGHT * (Math.random() / 8 + 1) * Math.PI) * n;
				source.copyPixels(source, new Rectangle(offset, i, BMD_WIDTH - offset, 1), new Point(0, i));
			}

			var sandstorm:BitmapData = new BitmapData(BMD_WIDTH, BMD_HEIGHT, false, 0xffffff);
			sandstorm.noise(int(Math.random() * 1000), 0, 255);
			source.merge(sandstorm, source.rect, new Point(), 40, 40, 40, 0);
			bmpd.copyChannel(source, bmpd.rect, new Point(offsets[0], 0), BitmapDataChannel.RED, BitmapDataChannel.RED);
			bmpd.copyChannel(source, bmpd.rect, new Point(offsets[1], 0), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
			bmpd.copyChannel(source, bmpd.rect, new Point(offsets[2], 0), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
		}

	}
}
