/**
 * Copyright Coft ( http://wonderfl.net/user/Coft )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/enDq
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData
    import flash.events.Event
    import flash.utils.getTimer
    import flash.geom.Point
    public class Map extends Sprite {
        private var bmp:BitmapData
        private var bitmap:Bitmap
        private var grid:Vector.<Boolean>
        private var i:uint
        public function Map() {
            bmp = new BitmapData(512,512,false)
            bitmap = new Bitmap(bmp)
            addChild(bitmap)
            grid = new <Boolean>[]
            for(var i:uint = 0; i < 64; i++) {
                var X:uint = i & 7
                var Y:uint = i >> 3
                if(X == 0 || X == 7 || Y == 0 || Y == 7) {
                    if(Math.random() > 0.5) {
                        grid[i] = false
                    } else {
                        grid[i] = true
                    }
                } else {
                    grid[i] = true
                }
            }
            i = 0
            addEventListener("enterFrame", render)
        }
        private function render(e:Event):void {
            for(var timer:uint = getTimer(); getTimer() - timer < 50;) {
                var X:uint = i & 511
                var Y:uint = i >> 9
                if(X < 512 && Y < 512) {
                    var clr:uint = 0
                    var delta:Point = new Point(Infinity, Infinity)
                    for(var a:uint = 0; a < 8; a++) {
                        for(var b:uint = 0; b < 8; b++) {
                            var index:uint = a | (b << 3)
                            if(!grid[index]) {
                                var newDelta:Point = new Point(a+0.5-X/64,b+0.5-Y/64)
                                if(newDelta.length < delta.length) {
                                    delta = newDelta.clone()
                                    var norm:Point = delta.clone()
                                    norm.normalize(1)
                                    var dX:int = 128 + 127 * norm.x
                                    var dY:int = 128 + 127 * norm.y
                                    dX = (dX < 0) ? 0 : dX
                                    dY = (dY < 0) ? 0 : dY
                                    dX = (dX > 255) ? 255 : dX
                                    dY = (dY > 255) ? 255 : dY
                                    var dZ:Number = 1-delta.length/2
                                    dZ = (dZ > 1) ? 1 : dZ
                                    dZ = (dZ < 0) ? 0 : dZ
                                    clr = (dX *dZ<< 16) | (dY*dZ << 8)
                                }
                            }
                        }
                    }
                    bmp.setPixel(X, Y, clr)
                }
                i++
            }
        }
    }
}