/**
 * Copyright krogue ( http://wonderfl.net/user/krogue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/en7N
 */

/**
 * #18 drawCircles
 * 
 * 変わらないものもあるけれど、
 * 立ち止まったり、歩き出したりを、
 * ぐるぐる繰り返して、
 * 変わっていくものなんじゃないかな。
 * 
 * Another Planetを元に何か作ろうとしたら、こんなことになった
 * http://wonderfl.net/code/ffd4151e209e254229930fa15934e477ceb57474
 * 
 * @author krogue
 */
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite
    {
        private var frame:int = 0;
        private var circles:Circles;
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            initialize();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(event:Event):void
        {
            update();
        }
        
        private function initialize():void
        {
            circles = addChild(new Circles()) as Circles;
        }
        
        private function update():void
        {
            circles.update();
            frame = (frame + 1 == 60 ? 0 : frame + 1);
        }
    }
}

import __AS3__.vec.Vector;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.geom.Point;

class Circles extends Sprite
{
    private var bitmap:Bitmap = addChild(new Bitmap()) as Bitmap;
    private var particles:Vector.<Particle> = new Vector.<Particle>();
    
    public function Circles()
    {
        var bmd:BitmapData = new BitmapData(465, 465, false, 0x000000);
        var radius:Number = 10;
        var n:int = 1000;
        for (var i:int = 0; i < n; i++)
        {
            var p:Particle = new Particle();
            p.isConstant = (i % 10 == 0);
            p.radians = i * 2 * Math.PI / n;
            p.initialX = 465 / 2 + Math.cos(p.radians) * radius;
            p.initialY = 465 / 2 + Math.sin(p.radians) * radius;
            p.initialSpeed = 10;
            p.currentX = p.initialX;
            p.currentY = p.initialY;
            p.currentSpeed = p.initialSpeed;
            particles.push(p);
        }
        bitmap.bitmapData = bmd;
    }
    
    public function update():void
    {
        var bmd:BitmapData = bitmap.bitmapData;
        bmd.lock();
        bmd.colorTransform(bmd.rect, new ColorTransform(0.8, 0.95, 0.8));
        for each (var p:Particle in particles)
        {
            if (!p.isConstant)
            {
                p.currentSpeed *= 0.975;
                if (p.currentSpeed < 0.01)
                    p.currentSpeed = p.initialSpeed;
            }
            p.currentX += Math.cos(p.radians) * p.currentSpeed;
            p.currentY += Math.sin(p.radians) * p.currentSpeed;
            bmd.setPixel(p.currentX, p.currentY, 0xFFFFFF);
            if (!bmd.rect.contains(p.currentX, p.currentY))
            {
                p.currentX = p.initialX;
                p.currentY = p.initialY;
            }
        }
        bmd.unlock();
    }
}

class Particle
{
    public var isConstant:Boolean;
    public var initialX:Number;
    public var initialY:Number;
    public var initialSpeed:Number;
    public var currentX:Number;
    public var currentY:Number;
    public var currentSpeed:Number;
    public var radians:Number; // 方向は変わらない。
}
