/**
 * Copyright Ryogo_Quberey ( http://wonderfl.net/user/Ryogo_Quberey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/emrR
 */

package{
  import flash.display.MovieClip;
  import flash.display.Sprite;
  import flash.utils.Timer;
  import flash.events.TimerEvent;
  import flash.filters.DropShadowFilter;
  import flash.filters.BlurFilter;
  
  [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]

  

  public class Sample04 extends MovieClip{
    
    //  各プロパティの宣言
    public var pieces:Array = new Array();    //親子関係を持つスプライト、２次元配列
    public var waku:Sprite = new Sprite();    //周りの円形のマスク的なぼかし
    public var dropShadow:DropShadowFilter = new DropShadowFilter(10, 45, 0x000000, 0.5, 10, 10);
    
    
    //  コンストラクタメソッド（初期化メソッド）
    function Sample04(){
        //親子関係をもつスプライトの初期化
        //単位として６方向（60度ずつ）あるので６回繰り返す
        for(var i:Number = 0; i < 6; ++i){
            pieces[i] = new Array();    //一列の親子関係を配列として初期化
            for(var j:Number = 0; j < 10; ++j){    //各列に10段階の親子関係を持たせる
                pieces[i][j] = new Sprite();    //スプライトのインスタンス化
                //piece[i][j].filters = [dropShadow];    //処理があまりに遅くなるのでとりあえずコメントアウトしている
                
                //スプライトに適当に矩形を描く
                pieces[i][j].graphics.clear();
                if(i == 0){    //最初に作ったスプライトだったらpiece[i][j]内にランダムな矩形を２個描く
                    pieces[i][j].graphics.lineStyle(0, 0, 0);
                    for(var k:Number = 0; k < 2; ++k){
                        var colRed:uint = int(Math.random()*105)+150;//赤成分は150〜255の範囲の乱数
                        var colGreen:uint = int(Math.random()*105)+150;//緑成分は150〜255の範囲の乱数
                        var colBlue:uint = int(Math.random()*105)+150;//青成分は150〜255の範囲の乱数
                        var sizeX:Number = int(Math.random()*40)+20;//横幅は20〜60の範囲の乱数
                        var sizeY:Number = int(Math.random()*40)+20;//高さは20〜60の範囲の乱数
                        var xx:Number = (Math.random()-0.5)*2*50;//横の位置は-50〜50の範囲の乱数
                        var yy:Number = (Math.random()-0.5)*2*500;//縦の位置は-50〜50の範囲の乱数
                        pieces[i][j].graphics.beginFill(colRed<<16 | colGreen<<8 | colBlue, 0.3+0.7*Math.random());
                        pieces[i][j].graphics.drawRect(xx, yy, sizeX, sizeY);
                        pieces[i][j].graphics.endFill();
                    }
                }else{    //最初ではなかったら、最初の矩形をコピー（複製）する
                    pieces[i][j].graphics.copyFrom(pieces[0][j].graphics);
                }
                
                if(j == 0){//最も親のスプライトだったらステージ中央に登録
                    pieces[i][j].x = this.stage.stageWidth/2;
                    pieces[i][j].y = this.stage.stageHeight/2;
                    pieces[i][j].rotation = 360/6*i;
                    this.addChild(pieces[i][j]);
                }else{    //最も親ではなかったら、自身の親に少しだけ位置をずらして登録
                    pieces[i][j-1].addChild(pieces[i][j]);
                    pieces[i][j].x = 0;
                    pieces[i][j].y = 100;
                }
            }
        }
        
        //周りをぼかすための処理
        waku.graphics.clear();
        waku.graphics.lineStyle(stage.stageWidth/2*(Math.sqrt(2)-1)*2, 0x000000);
        waku.graphics.drawCircle(stage.stageWidth/2, stage.stageHeight/2, stage.stageWidth/2*Math.sqrt(2)*0.85);
        waku.filters = [new BlurFilter(100, 100)];
        addChild(waku);

        //  33ミリ秒（１秒間に30回）ごとに実行されるタイマーの初期化と開始
        var timer:Timer = new Timer(33);
           timer.addEventListener(TimerEvent.TIMER, loop);
          timer.start();
    }
    
    //33ミリ秒ごとに繰り返されるループ
    public function loop(event:TimerEvent):void{
        //それぞれの親子関係を順番に、、
        for(var i:Number = 0; i < pieces.length; ++i){
            //その中のスプライトを順番に、、
            for(var j:Number = 0; j < pieces[i].length; ++j){
                //スプライトを回転させる
                //（すべてのスプライトが同じ回転角度だと単調なので世代によって回転角度に変化をつけた）
                pieces[i][j].rotation += 0.05*(10-j);
            }
        }
    }
  }
}
