/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/emqK
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
 
    public class Main extends Sprite
    {
        public function Main()
        {
            var slider:Slider = new Slider();
            slider.x = slider.y = 100;
            slider.addEventListener(Event.CHANGE, function():void {  trace(slider.value); } );
            addChild(slider);
        }
    }
}
 
import com.bit101.components.Label;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
 
class Slider extends Sprite
{
    private var _value:Number = 0.0;    // 現在の値
    private var _max:Number = 50.0;        // 最大値
    private var _min:Number = 0.0;        // 最小値
    private var label:Label;            // 値を表示するLabel
    private var handle:Sprite;            // ハンドル
    private var back:Sprite;            // 背景
    private var _fixed:int = 2;            // 小数点以下何桁まで値を表示するか
    private var prevX:int;                // 前回の値
 
    public function Slider()
    {
        label = new Label(this, 120, -10, value.toFixed(_fixed));
 
        back = new Sprite();
        back.graphics.beginFill(0x0);
        back.graphics.drawRect(0, 0, 100, 2);
        back.graphics.endFill();
        addChild(back);
        
        handle = new Sprite();
        handle.useHandCursor = true;
        handle.buttonMode = true;
        handle.graphics.beginFill(0x0);
        handle.graphics.drawRect(0, -10, 10, 20);
        handle.graphics.endFill();
        addChild(handle);
        
        prevX = handle.x;
        
        setHandlePosition();
 
        handle.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
 
    private function onMouseDown(event:MouseEvent):void
    {
        handle.startDrag(false, new Rectangle(0, 0, 100 - handle.width, 0));
        var stop:Function = function():void { handle.stopDrag(); removeEventListener(Event.ENTER_FRAME, onEnterFrame); };
        stage.addEventListener(Event.MOUSE_LEAVE, stop);
        stage.addEventListener(MouseEvent.MOUSE_UP, stop);
 
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
 
    private function onEnterFrame(event:Event):void
    {
        _value = handle.x / (back.width - handle.width) * (_max - _min) + _min;
        _value = Number(_value.toFixed(_fixed));
        label.text = _value.toString();
        
        // ハンドルの位置が前回と同じであればイベントを送出しない
        if (prevX != handle.x) dispatchEvent(new Event(Event.CHANGE));
        prevX = handle.x;
    }
    
    private function correctValue():void
    {
        if (value < min) value = min;
        else if (max < value) value = max;
    }
    
    private function setHandlePosition():void
    {
        var percent:Number = (value - min) / (max - min);
        handle.x = (back.width - handle.width) * percent;
    }
    
    public function set value(value:Number):void
    {
        this._value = value;
        correctValue();
        setHandlePosition();
    }
    public function get value():Number { return _value; }
    
    public function set min(min:Number):void
    {
        this._min = min;
        correctValue();
        setHandlePosition();
    }
    public function get min():Number { return _min; }
    
    public function set max(max:Number):void
    {
        this._max = max;
        correctValue();
        setHandlePosition();
    }
    public function get max():Number { return _max; }
    
    public function set fixed(value:int):void
    {
        this._fixed = value;
    }
    public function get fixed():int { return _fixed; }
}
