/**
 * Copyright dimitris.1972g ( http://wonderfl.net/user/dimitris.1972g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/emqB
 */

// forked from tepe's flash on 2011-11-12
package {
  import flash.display.*;
  import flash.events.*;
  import flash.text.*;
  import flash.ui.*;
  import flash.utils.*;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.net.NetGroup;
    import flash.net.GroupSpecifier;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.media.Microphone;
    import flash.media.SoundCodec;
    import com.bit101.components.*;
    
  
  import net.user1.reactor.Attribute;
  import net.user1.reactor.IClient;
  import net.user1.reactor.Reactor;
  import net.user1.reactor.ReactorEvent;
  import net.user1.reactor.Room;
  import net.user1.reactor.RoomEvent;
  import net.user1.reactor.SynchronizationState; 

  public class UnionChatPart2 extends Sprite {
    // Union objects
    protected var reactor:Reactor;
    protected var chatRoom:Room;
    // User interface objects
    protected var t1:TextField;
    protected var t2:TextField;
    protected var userlist:TextField;
    protected var nameInput:TextField;
    
    

    // Constructor    
    public function UnionChatPart2 () {
      // Create the user interface
      buildUI();
      // Make the Reactor object
      reactor = new Reactor();
      // Run readyListener() when the connection is ready
      reactor.addEventListener(ReactorEvent.READY, 
                               readyListener);
      // Connect to the server
      reactor.connect("tryunion.com", 80);
    }
    
    // Method invoked when the connection is ready
    protected function readyListener (e:ReactorEvent):void {
      t1.appendText("Connected to Union\n");
      chatRoom = reactor.getRoomManager().createRoom("chatRoom0001");
      chatRoom.addMessageListener("CHAT_MESSAGE", 
                                  chatMessageListener);
      chatRoom.addEventListener(RoomEvent.JOIN,
                                joinRoomListener);
      chatRoom.addEventListener(RoomEvent.ADD_OCCUPANT,
                                addClientListener);
      chatRoom.addEventListener(RoomEvent.REMOVE_OCCUPANT,
                                removeClientListener);
      chatRoom.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE,
                                updateClientAttributeListener);
      chatRoom.join();
    }
    
    // Create the user interface
    protected function buildUI ():void {
      t1 = new TextField;
      with(t1){
          border = true;
          background = true;
          width = 300;
          height = 200;
      }
      t2 = new TextField();
      with(t2){
          type = TextFieldType.INPUT;
          border = true;
          background = true;
          width = 399;
          height = 20;
          y = 210;
          addEventListener(KeyboardEvent.KEY_UP, 
                                        outgoingKeyUpListener);
      }                               
      userlist = new TextField();
      userlist.border = true;
      userlist.background = true;
      userlist.width = 89;
      userlist.height = 200;
      userlist.x = 310;
                                        
   
      
      addChild(t1);
      addChild(t2);
      addChild(userlist);
  
    }
    
    // Keyboard listener for outgoingMessages
    protected function outgoingKeyUpListener (e:KeyboardEvent):void {
      if (e.keyCode == Keyboard.ENTER) {
        chatRoom.sendMessage("CHAT_MESSAGE", true, null, t2.text);
        t2.text = "";
      }
    }
    
    // Keyboard listener for nameInput
    protected function nameKeyUpListener (e:KeyboardEvent):void {
      var self:IClient;
      if (e.keyCode == Keyboard.ENTER) {
        self = reactor.self();
        self.setAttribute("username", nameInput.text);
        nameInput.text = "";
      }
    }
    
    // Method invoked when a chat message is received
    protected function chatMessageListener (fromClient:IClient, 
                                            messageText:String
                                            ):void {
      t1.appendText(getUserName(fromClient)
                                  + " : " 
                                  + messageText + "\n");
      t1.scrollV = t1.maxScrollV;
    }
    
    // Method invoked when the current client joins the room
    protected function joinRoomListener (e:RoomEvent):void {
      updateUserList();
    }
    
    // Method invoked when a client joins the room
    protected function addClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      if (e.getClient().isSelf()) {
        t1.appendText("You joined the chat. ["+ d.toLocaleTimeString() + "]\n");
      } else {
        if (chatRoom.getSyncState() != SynchronizationState.SYNCHRONIZING) {
   
          t1.appendText(getUserName(e.getClient())
                                      + " joined the chat. ["+ d.toLocaleTimeString() + "]\n");
        }
      }
      t1.scrollV = t1.maxScrollV;
      updateUserList();
    }
    
    // Method invoked when a client leave the room
    protected function removeClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      t1.appendText(getUserName(e.getClient())
                                  + " left the chat. ["+ d.toLocaleTimeString() + "]\n");
      t1.scrollV = t1.maxScrollV;
      updateUserList();
    }
    

    protected function updateClientAttributeListener (e:RoomEvent):void {
      var changedAttr:Attribute = e.getChangedAttr();
      if (changedAttr.name == "username") {
        if (changedAttr.oldValue == null) {
          t1.appendText("Guest" + e.getClientID());
        } else {
          t1.appendText(changedAttr.oldValue);
        }
        t1.appendText(" 's name changed to "
                                    + getUserName(e.getClient())
                                    + ".\n");
        t1.scrollV = t1.maxScrollV;
        updateUserList();
      }
    }
    

    protected function updateUserList ():void {
      userlist.text = "";
      for each (var client:IClient in chatRoom.getOccupants()) {
        userlist.appendText(getUserName(client) + "\n");
      }
    }
    

    protected function getUserName (client:IClient):String {
      var username:String = client.getAttribute("username");
        if (username == null) {
          return "Guest" + client.getClientID();
        } else {
          return username;
        }
    }
  }
}

//package {
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;

   
    //ローカル領域へのデータ保存
    //public 
    class SharedObjectEx extends Sprite {
        private var textField:TextField;//テキストフィールド
        private var so:SharedObject;    //SharedObject
        
        //コンストラクタ
        public function SharedObjectEx() {
            //画面の描画
            var child:Sprite = new Sprite();
            child.graphics.beginFill(0xffffff);
            child.graphics.drawRect(0,0,240,240);
            child.graphics.endFill();
            addChild(child);


            //ボタンの追加
            addButton(child,"書き込み",writeHandler,10,10);
            addButton(child,"読み込み",readHandler,70,10);
            
            //テキストフィールドの追加
            textField=addTextField(child,"");
            textField.x=10;
            textField.y=30;
            textField.multiline=true;

            //SharedObjectの取得
            so=SharedObject.getLocal("SharedObjectEx");
            if (so.data.text!=null) textField.text=so.data.text;            
        }

        //テキストフィールドの追加
        private function addTextField(doc:DisplayObjectContainer,
            text:String):TextField {
            var textField:TextField=new TextField();
            doc.addChild(textField);
            textField.width=480;
            textField.height=272;
            textField.text      =text;//テキスト
            textField.selectable=true;//選択可
            textField.border    =true;//ボーダー
            textField.type      =TextFieldType.INPUT;//入力
            return textField;
        }

        //ボタンの追加
        private function addButton(doc:DisplayObjectContainer,
            text:String,handler:Function,x:int,y:int):TextField {
            var button:TextField=new TextField();
            doc.addChild(button);
            button.text           =text;                  //テキスト
            button.autoSize       =TextFieldAutoSize.LEFT;//オートサイズ
            button.selectable     =false;                 //選択不可
            button.border         =true;                  //ボーダー
            button.background     =true;                  //背景色
            button.backgroundColor=0xdddddd;
            button.addEventListener(MouseEvent.CLICK,handler);
            button.x=x;
            button.y=y;
            return button;
        }

        //書き込み
        private function writeHandler(evt:MouseEvent):void {
            so.data.text=textField.text;
            so.flush();
        }
        
        //読み込み
        private function readHandler(evt:MouseEvent):void {
            if (so.data.text!=null) textField.text=so.data.text;            
        }
    }
//}
