/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/emJ3
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	
        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"type":"draw","col":16777010,"time":1074,"fy":169,"id":0,"childlist":[{"y":168,"x":35,"time":1207},{"y":166,"x":35,"time":1223},{"y":164,"x":37,"time":1246},{"y":163,"x":38,"time":1255},{"y":161,"x":38,"time":1263},{"y":159,"x":39,"time":1270},{"y":157,"x":41,"time":1287},{"y":156,"x":41,"time":1294},{"y":154,"x":41,"time":1302},{"y":153,"x":42,"time":1414},{"y":154,"x":42,"time":1454},{"y":155,"x":42,"time":1494},{"y":156,"x":42,"time":1511},{"y":158,"x":42,"time":1527},{"y":159,"x":42,"time":1534},{"y":160,"x":42,"time":1558},{"y":161,"x":42,"time":1566},{"y":163,"x":43,"time":1582},{"y":164,"x":43,"time":1614},{"y":166,"x":44,"time":1702},{"y":166,"x":46,"time":1726},{"y":166,"x":48,"time":1734},{"y":167,"x":50,"time":1758},{"y":168,"x":51,"time":1766},{"y":168,"x":52,"time":1790},{"y":170,"x":50,"time":1894},{"y":171,"x":49,"time":1926},{"y":172,"x":47,"time":1951},{"y":173,"x":46,"time":1958},{"y":173,"x":45,"time":1974},{"y":173,"x":43,"time":2006},{"y":174,"x":43,"time":2086},{"y":175,"x":43,"time":2110},{"y":176,"x":43,"time":2118},{"y":178,"x":43,"time":2142},{"y":179,"x":44,"time":2150},{"y":180,"x":44,"time":2158},{"y":182,"x":44,"time":2166},{"y":183,"x":44,"time":2182},{"y":184,"x":45,"time":2190},{"y":186,"x":45,"time":2206},{"y":186,"x":43,"time":2286},{"y":184,"x":43,"time":2310},{"y":183,"x":42,"time":2318},{"y":181,"x":40,"time":2342},{"y":179,"x":39,"time":2358},{"y":178,"x":38,"time":2382},{"y":177,"x":37,"time":2414},{"y":177,"x":36,"time":2438},{"y":177,"x":34,"time":2462},{"y":179,"x":33,"time":2478},{"y":180,"x":31,"time":2502},{"y":181,"x":29,"time":2518},{"y":181,"x":28,"time":2542},{"y":182,"x":26,"time":2582},{"y":180,"x":26,"time":2662},{"y":179,"x":26,"time":2686},{"y":177,"x":27,"time":2702},{"y":174,"x":28,"time":2727},{"y":172,"x":29,"time":2742},{"y":171,"x":29,"time":2782},{"y":170,"x":28,"time":2862},{"y":168,"x":26,"time":2894},{"y":167,"x":25,"time":2910},{"y":165,"x":24,"time":2934},{"y":164,"x":23,"time":2950},{"y":163,"x":22,"time":2974},{"y":162,"x":23,"time":3046},{"y":162,"x":25,"time":3062},{"y":162,"x":26,"time":3078},{"y":162,"x":28,"time":3087},{"y":162,"x":30,"time":3094},{"y":162,"x":32,"time":3102},{"y":162,"x":33,"time":3119},{"y":162,"x":34,"time":3134},{"y":161,"x":33,"time":3223}],"fx":34},{"type":"draw","col":16777113,"time":4438,"fy":259,"id":0,"childlist":[{"y":257,"x":50,"time":4487},{"y":256,"x":51,"time":4502},{"y":254,"x":52,"time":4526},{"y":252,"x":52,"time":4534},{"y":251,"x":53,"time":4550},{"y":250,"x":54,"time":4557},{"y":247,"x":55,"time":4574},{"y":249,"x":55,"time":4670},{"y":250,"x":55,"time":4678},{"y":251,"x":55,"time":4686},{"y":252,"x":55,"time":4695},{"y":254,"x":55,"time":4710},{"y":255,"x":56,"time":4726},{"y":256,"x":57,"time":4790},{"y":256,"x":58,"time":4806},{"y":256,"x":61,"time":4833},{"y":256,"x":63,"time":4838},{"y":256,"x":64,"time":4846},{"y":256,"x":65,"time":4862},{"y":256,"x":67,"time":4870},{"y":257,"x":68,"time":4887},{"y":257,"x":66,"time":4959},{"y":259,"x":66,"time":4982},{"y":260,"x":63,"time":4998},{"y":261,"x":62,"time":5022},{"y":262,"x":61,"time":5046},{"y":263,"x":59,"time":5078},{"y":264,"x":60,"time":5158},{"y":266,"x":61,"time":5174},{"y":268,"x":61,"time":5190},{"y":270,"x":62,"time":5214},{"y":271,"x":63,"time":5222},{"y":273,"x":63,"time":5230},{"y":274,"x":63,"time":5254},{"y":275,"x":63,"time":5269},{"y":274,"x":61,"time":5318},{"y":273,"x":60,"time":5342},{"y":272,"x":58,"time":5358},{"y":270,"x":57,"time":5382},{"y":270,"x":56,"time":5390},{"y":270,"x":54,"time":5414},{"y":270,"x":52,"time":5430},{"y":272,"x":51,"time":5454},{"y":272,"x":49,"time":5462},{"y":273,"x":47,"time":5486},{"y":274,"x":46,"time":5502},{"y":272,"x":45,"time":5614},{"y":271,"x":45,"time":5630},{"y":269,"x":45,"time":5645},{"y":267,"x":46,"time":5662},{"y":266,"x":46,"time":5686},{"y":265,"x":46,"time":5702},{"y":263,"x":45,"time":5734},{"y":263,"x":43,"time":5758},{"y":261,"x":42,"time":5782},{"y":260,"x":41,"time":5822},{"y":259,"x":41,"time":5894},{"y":258,"x":42,"time":5926},{"y":257,"x":43,"time":5933},{"y":257,"x":45,"time":5941},{"y":257,"x":46,"time":5958},{"y":257,"x":48,"time":5966},{"y":257,"x":49,"time":5974},{"y":257,"x":50,"time":5981},{"y":257,"x":52,"time":5998},{"y":256,"x":51,"time":6054},{"y":254,"x":49,"time":6078}],"fx":50},{"type":"draw","col":16777165,"time":7750,"fy":260,"id":0,"childlist":[{"y":258,"x":136,"time":7870},{"y":257,"x":137,"time":7878},{"y":255,"x":138,"time":7893},{"y":253,"x":139,"time":7901},{"y":252,"x":141,"time":7910},{"y":249,"x":141,"time":7918},{"y":248,"x":142,"time":7934},{"y":246,"x":143,"time":7950},{"y":248,"x":144,"time":8070},{"y":250,"x":143,"time":8094},{"y":251,"x":143,"time":8101},{"y":252,"x":143,"time":8109},{"y":254,"x":143,"time":8118},{"y":255,"x":143,"time":8134},{"y":256,"x":143,"time":8142},{"y":257,"x":145,"time":8262},{"y":257,"x":146,"time":8269},{"y":258,"x":147,"time":8287},{"y":258,"x":148,"time":8294},{"y":258,"x":151,"time":8309},{"y":258,"x":152,"time":8326},{"y":258,"x":154,"time":8342},{"y":258,"x":155,"time":8366},{"y":258,"x":157,"time":8406},{"y":260,"x":155,"time":8462},{"y":261,"x":153,"time":8494},{"y":262,"x":151,"time":8517},{"y":263,"x":149,"time":8525},{"y":263,"x":148,"time":8533},{"y":264,"x":147,"time":8557},{"y":265,"x":147,"time":8653},{"y":267,"x":147,"time":8686},{"y":269,"x":148,"time":8702},{"y":270,"x":148,"time":8725},{"y":272,"x":149,"time":8733},{"y":273,"x":149,"time":8741},{"y":275,"x":149,"time":8765},{"y":276,"x":149,"time":8798},{"y":275,"x":147,"time":8886},{"y":275,"x":146,"time":8910},{"y":273,"x":144,"time":8926},{"y":273,"x":142,"time":8950},{"y":271,"x":141,"time":8966},{"y":270,"x":139,"time":8998},{"y":270,"x":138,"time":9062},{"y":272,"x":137,"time":9078},{"y":272,"x":135,"time":9109},{"y":273,"x":133,"time":9126},{"y":274,"x":132,"time":9141},{"y":274,"x":130,"time":9157},{"y":274,"x":129,"time":9166},{"y":275,"x":128,"time":9198},{"y":275,"x":126,"time":9246},{"y":273,"x":126,"time":9317},{"y":272,"x":126,"time":9326},{"y":270,"x":128,"time":9349},{"y":268,"x":129,"time":9357},{"y":266,"x":130,"time":9382},{"y":265,"x":131,"time":9405},{"y":263,"x":130,"time":9462},{"y":262,"x":128,"time":9502},{"y":259,"x":127,"time":9517},{"y":258,"x":126,"time":9542},{"y":256,"x":126,"time":9582},{"y":256,"x":127,"time":9662},{"y":256,"x":129,"time":9678},{"y":256,"x":130,"time":9693},{"y":257,"x":132,"time":9701},{"y":257,"x":134,"time":9710},{"y":258,"x":136,"time":9733},{"y":256,"x":136,"time":9813}],"fx":135},{"type":"draw","col":16763954,"time":11758,"fy":188,"id":0,"childlist":[{"y":186,"x":178,"time":11861},{"y":183,"x":181,"time":11878},{"y":182,"x":181,"time":11886},{"y":180,"x":183,"time":11901},{"y":179,"x":184,"time":11917},{"y":178,"x":184,"time":11941},{"y":178,"x":186,"time":11997},{"y":179,"x":186,"time":12029},{"y":180,"x":186,"time":12054},{"y":181,"x":186,"time":12069},{"y":183,"x":186,"time":12077},{"y":184,"x":186,"time":12094},{"y":185,"x":186,"time":12109},{"y":187,"x":186,"time":12141},{"y":187,"x":188,"time":12189},{"y":186,"x":189,"time":12214},{"y":186,"x":190,"time":12222},{"y":186,"x":191,"time":12229},{"y":186,"x":193,"time":12245},{"y":185,"x":194,"time":12254},{"y":185,"x":196,"time":12269},{"y":186,"x":198,"time":12294},{"y":187,"x":196,"time":12382},{"y":188,"x":195,"time":12405},{"y":189,"x":193,"time":12413},{"y":190,"x":192,"time":12437},{"y":191,"x":191,"time":12454},{"y":191,"x":189,"time":12486},{"y":193,"x":189,"time":12533},{"y":194,"x":189,"time":12557},{"y":200,"x":191,"time":12616},{"y":202,"x":191,"time":12621},{"y":203,"x":191,"time":12654},{"y":202,"x":189,"time":12701},{"y":201,"x":188,"time":12733},{"y":200,"x":186,"time":12758},{"y":198,"x":185,"time":12773},{"y":197,"x":184,"time":12789},{"y":196,"x":184,"time":12829},{"y":197,"x":182,"time":12869},{"y":198,"x":181,"time":12886},{"y":198,"x":179,"time":12909},{"y":200,"x":177,"time":12926},{"y":200,"x":176,"time":12949},{"y":200,"x":175,"time":12966},{"y":200,"x":173,"time":12989},{"y":198,"x":173,"time":13077},{"y":196,"x":174,"time":13101},{"y":194,"x":175,"time":13117},{"y":192,"x":176,"time":13141},{"y":191,"x":176,"time":13165},{"y":190,"x":176,"time":13205},{"y":189,"x":174,"time":13229},{"y":187,"x":173,"time":13262},{"y":185,"x":171,"time":13277},{"y":184,"x":170,"time":13302},{"y":183,"x":170,"time":13357},{"y":183,"x":172,"time":13382},{"y":182,"x":175,"time":13390},{"y":182,"x":176,"time":13397},{"y":182,"x":177,"time":13413},{"y":182,"x":178,"time":13430},{"y":182,"x":180,"time":13493}],"fx":177},{"type":"draw","col":16763904,"time":15126,"fy":180,"id":0,"childlist":[{"y":179,"x":261,"time":15173},{"y":177,"x":262,"time":15197},{"y":177,"x":263,"time":15205},{"y":175,"x":264,"time":15213},{"y":174,"x":266,"time":15229},{"y":172,"x":268,"time":15237},{"y":171,"x":269,"time":15245},{"y":170,"x":271,"time":15269},{"y":171,"x":270,"time":15317},{"y":172,"x":270,"time":15341},{"y":174,"x":270,"time":15357},{"y":176,"x":270,"time":15381},{"y":178,"x":269,"time":15390},{"y":179,"x":269,"time":15397},{"y":180,"x":268,"time":15405},{"y":182,"x":268,"time":15421},{"y":183,"x":268,"time":15437},{"y":184,"x":269,"time":15485},{"y":184,"x":270,"time":15510},{"y":185,"x":272,"time":15517},{"y":186,"x":274,"time":15541},{"y":187,"x":275,"time":15549},{"y":187,"x":276,"time":15565},{"y":189,"x":277,"time":15598},{"y":189,"x":275,"time":15654},{"y":189,"x":274,"time":15669},{"y":190,"x":272,"time":15693},{"y":190,"x":270,"time":15709},{"y":191,"x":268,"time":15741},{"y":193,"x":268,"time":15757},{"y":195,"x":268,"time":15781},{"y":196,"x":268,"time":15798},{"y":198,"x":269,"time":15821},{"y":200,"x":269,"time":15837},{"y":201,"x":268,"time":15861},{"y":201,"x":267,"time":15901},{"y":200,"x":265,"time":15941},{"y":198,"x":264,"time":15965},{"y":197,"x":263,"time":15981},{"y":196,"x":262,"time":15989},{"y":194,"x":262,"time":16014},{"y":194,"x":260,"time":16029},{"y":194,"x":259,"time":16055},{"y":194,"x":258,"time":16069},{"y":196,"x":256,"time":16093},{"y":196,"x":255,"time":16109},{"y":196,"x":253,"time":16133},{"y":197,"x":251,"time":16157},{"y":197,"x":250,"time":16181},{"y":195,"x":249,"time":16221},{"y":194,"x":249,"time":16261},{"y":192,"x":251,"time":16287},{"y":192,"x":252,"time":16293},{"y":190,"x":254,"time":16317},{"y":189,"x":256,"time":16333},{"y":187,"x":257,"time":16365},{"y":186,"x":256,"time":16405},{"y":185,"x":254,"time":16437},{"y":183,"x":253,"time":16454},{"y":181,"x":252,"time":16477},{"y":179,"x":251,"time":16493},{"y":177,"x":251,"time":16557},{"y":177,"x":253,"time":16573},{"y":177,"x":254,"time":16589},{"y":177,"x":255,"time":16597},{"y":177,"x":256,"time":16605},{"y":177,"x":259,"time":16629},{"y":177,"x":260,"time":16645},{"y":178,"x":261,"time":16685},{"y":177,"x":260,"time":16749}],"fx":259},{"type":"draw","col":16777010,"time":18454,"fy":191,"id":0,"childlist":[{"y":189,"x":336,"time":18525},{"y":187,"x":339,"time":18541},{"y":186,"x":341,"time":18550},{"y":185,"x":343,"time":18565},{"y":185,"x":344,"time":18573},{"y":184,"x":345,"time":18597},{"y":185,"x":346,"time":18693},{"y":186,"x":346,"time":18701},{"y":188,"x":345,"time":18717},{"y":189,"x":345,"time":18724},{"y":190,"x":345,"time":18733},{"y":191,"x":345,"time":18741},{"y":193,"x":344,"time":18757},{"y":194,"x":344,"time":18821},{"y":195,"x":345,"time":18855},{"y":196,"x":346,"time":18877},{"y":197,"x":348,"time":18885},{"y":197,"x":349,"time":18892},{"y":199,"x":351,"time":18917},{"y":200,"x":352,"time":18932},{"y":201,"x":353,"time":18957},{"y":201,"x":351,"time":19005},{"y":201,"x":350,"time":19037},{"y":201,"x":349,"time":19045},{"y":202,"x":347,"time":19069},{"y":202,"x":346,"time":19077},{"y":202,"x":344,"time":19093},{"y":202,"x":343,"time":19117},{"y":202,"x":341,"time":19149},{"y":204,"x":341,"time":19197},{"y":205,"x":341,"time":19213},{"y":206,"x":342,"time":19237},{"y":208,"x":342,"time":19245},{"y":209,"x":342,"time":19268},{"y":210,"x":342,"time":19277},{"y":212,"x":342,"time":19285},{"y":213,"x":343,"time":19301},{"y":214,"x":342,"time":19317},{"y":216,"x":342,"time":19341},{"y":214,"x":340,"time":19389},{"y":213,"x":339,"time":19405},{"y":212,"x":338,"time":19429},{"y":211,"x":336,"time":19445},{"y":209,"x":335,"time":19469},{"y":208,"x":334,"time":19485},{"y":206,"x":333,"time":19509},{"y":206,"x":332,"time":19589},{"y":206,"x":331,"time":19613},{"y":206,"x":329,"time":19629},{"y":206,"x":328,"time":19637},{"y":206,"x":326,"time":19661},{"y":205,"x":324,"time":19677},{"y":205,"x":322,"time":19701},{"y":204,"x":321,"time":19781},{"y":203,"x":322,"time":19821},{"y":201,"x":324,"time":19845},{"y":200,"x":326,"time":19855},{"y":199,"x":328,"time":19861},{"y":198,"x":329,"time":19869},{"y":197,"x":331,"time":19885},{"y":195,"x":332,"time":19909},{"y":194,"x":330,"time":20005},{"y":193,"x":330,"time":20020},{"y":191,"x":330,"time":20029},{"y":190,"x":329,"time":20045},{"y":188,"x":329,"time":20060},{"y":187,"x":329,"time":20085},{"y":185,"x":328,"time":20100},{"y":185,"x":329,"time":20197},{"y":185,"x":330,"time":20205},{"y":186,"x":332,"time":20221},{"y":187,"x":335,"time":20237},{"y":187,"x":336,"time":20245},{"y":187,"x":337,"time":20261},{"y":188,"x":339,"time":20293},{"y":186,"x":338,"time":20333},{"y":186,"x":337,"time":20341}],"fx":335},{"type":"draw","col":16777113,"time":22133,"fy":255,"id":0,"childlist":[{"y":253,"x":387,"time":22213},{"y":252,"x":388,"time":22221},{"y":250,"x":389,"time":22228},{"y":249,"x":390,"time":22236},{"y":248,"x":392,"time":22255},{"y":246,"x":393,"time":22261},{"y":245,"x":394,"time":22268},{"y":243,"x":395,"time":22293},{"y":242,"x":396,"time":22308},{"y":244,"x":396,"time":22373},{"y":246,"x":395,"time":22389},{"y":247,"x":394,"time":22396},{"y":248,"x":394,"time":22413},{"y":251,"x":394,"time":22421},{"y":253,"x":393,"time":22429},{"y":254,"x":393,"time":22444},{"y":255,"x":393,"time":22454},{"y":257,"x":393,"time":22469},{"y":257,"x":395,"time":22581},{"y":258,"x":398,"time":22604},{"y":259,"x":399,"time":22612},{"y":260,"x":400,"time":22621},{"y":260,"x":403,"time":22644},{"y":262,"x":403,"time":22684},{"y":262,"x":401,"time":22724},{"y":263,"x":400,"time":22757},{"y":264,"x":398,"time":22772},{"y":264,"x":397,"time":22780},{"y":264,"x":396,"time":22805},{"y":263,"x":395,"time":22855},{"y":264,"x":395,"time":22892},{"y":265,"x":395,"time":22917},{"y":266,"x":395,"time":22925},{"y":268,"x":395,"time":22932},{"y":269,"x":395,"time":22940},{"y":271,"x":395,"time":22965},{"y":272,"x":395,"time":22973},{"y":274,"x":395,"time":22988},{"y":275,"x":395,"time":23005},{"y":274,"x":393,"time":23108},{"y":272,"x":392,"time":23125},{"y":270,"x":392,"time":23148},{"y":269,"x":391,"time":23156},{"y":268,"x":390,"time":23165},{"y":266,"x":389,"time":23188},{"y":265,"x":388,"time":23213},{"y":265,"x":386,"time":23268},{"y":266,"x":385,"time":23325},{"y":265,"x":383,"time":23349},{"y":265,"x":382,"time":23356},{"y":265,"x":381,"time":23364},{"y":267,"x":379,"time":23389},{"y":267,"x":377,"time":23396},{"y":267,"x":376,"time":23404},{"y":267,"x":375,"time":23429},{"y":266,"x":373,"time":23484},{"y":264,"x":373,"time":23516},{"y":263,"x":375,"time":23541},{"y":262,"x":377,"time":23557},{"y":261,"x":377,"time":23564},{"y":260,"x":379,"time":23589},{"y":259,"x":380,"time":23604},{"y":257,"x":381,"time":23629},{"y":256,"x":382,"time":23661},{"y":255,"x":380,"time":23772},{"y":252,"x":379,"time":23797},{"y":251,"x":379,"time":23821},{"y":250,"x":379,"time":23829},{"y":249,"x":379,"time":23837},{"y":247,"x":379,"time":23856},{"y":246,"x":379,"time":23877},{"y":246,"x":381,"time":23980},{"y":247,"x":382,"time":23988},{"y":247,"x":383,"time":24005},{"y":248,"x":386,"time":24013},{"y":248,"x":387,"time":24020},{"y":248,"x":388,"time":24028},{"y":249,"x":390,"time":24053},{"y":248,"x":388,"time":24125}],"fx":386},{"type":"draw","col":16777010,"time":26484,"fy":175,"id":0,"childlist":[{"y":173,"x":35,"time":26509},{"y":174,"x":35,"time":26604},{"y":175,"x":36,"time":26612},{"y":177,"x":37,"time":26620},{"y":179,"x":37,"time":26628},{"y":180,"x":37,"time":26644},{"y":183,"x":38,"time":26654},{"y":185,"x":39,"time":26660},{"y":188,"x":39,"time":26677},{"y":192,"x":40,"time":26684},{"y":196,"x":40,"time":26692},{"y":200,"x":41,"time":26700},{"y":204,"x":42,"time":26717},{"y":209,"x":43,"time":26724},{"y":214,"x":43,"time":26732},{"y":218,"x":44,"time":26740},{"y":223,"x":45,"time":26757},{"y":227,"x":46,"time":26765},{"y":231,"x":46,"time":26772},{"y":233,"x":46,"time":26780},{"y":236,"x":47,"time":26797},{"y":239,"x":47,"time":26805},{"y":241,"x":48,"time":26812},{"y":243,"x":48,"time":26821},{"y":245,"x":48,"time":26837},{"y":247,"x":48,"time":26845},{"y":248,"x":48,"time":26852},{"y":251,"x":49,"time":26877},{"y":253,"x":49,"time":26892},{"y":254,"x":49,"time":26916},{"y":255,"x":50,"time":26988},{"y":257,"x":50,"time":27053},{"y":258,"x":50,"time":27076},{"y":259,"x":50,"time":27100},{"y":261,"x":50,"time":27116},{"y":259,"x":51,"time":27204},{"y":258,"x":52,"time":27301},{"y":258,"x":53,"time":27316},{"y":258,"x":54,"time":27341},{"y":258,"x":56,"time":27349},{"y":258,"x":58,"time":27364},{"y":258,"x":59,"time":27380},{"y":258,"x":61,"time":27389},{"y":258,"x":64,"time":27396},{"y":259,"x":66,"time":27412},{"y":260,"x":69,"time":27421},{"y":260,"x":72,"time":27429},{"y":260,"x":75,"time":27436},{"y":260,"x":78,"time":27455},{"y":261,"x":82,"time":27460},{"y":261,"x":86,"time":27469},{"y":260,"x":89,"time":27476},{"y":260,"x":93,"time":27492},{"y":260,"x":97,"time":27500},{"y":260,"x":100,"time":27509},{"y":260,"x":103,"time":27516},{"y":260,"x":107,"time":27532},{"y":260,"x":110,"time":27540},{"y":261,"x":113,"time":27548},{"y":261,"x":115,"time":27557},{"y":261,"x":117,"time":27572},{"y":261,"x":119,"time":27580},{"y":261,"x":121,"time":27588},{"y":261,"x":123,"time":27604},{"y":262,"x":125,"time":27612},{"y":262,"x":127,"time":27621},{"y":262,"x":129,"time":27628},{"y":263,"x":130,"time":27644},{"y":263,"x":132,"time":27652},{"y":263,"x":133,"time":27660},{"y":264,"x":134,"time":27684},{"y":264,"x":136,"time":27708},{"y":264,"x":137,"time":27740},{"y":264,"x":138,"time":27780},{"y":264,"x":136,"time":27860}],"fx":36},{"type":"draw","col":16777010,"time":28509,"fy":257,"id":0,"childlist":[{"y":255,"x":144,"time":28621},{"y":254,"x":145,"time":28628},{"y":252,"x":146,"time":28637},{"y":249,"x":148,"time":28655},{"y":246,"x":149,"time":28660},{"y":242,"x":152,"time":28668},{"y":238,"x":156,"time":28676},{"y":233,"x":159,"time":28692},{"y":230,"x":162,"time":28700},{"y":225,"x":165,"time":28708},{"y":221,"x":168,"time":28716},{"y":219,"x":169,"time":28732},{"y":217,"x":171,"time":28740},{"y":214,"x":171,"time":28748},{"y":213,"x":172,"time":28756},{"y":211,"x":173,"time":28772},{"y":210,"x":173,"time":28780},{"y":208,"x":174,"time":28788},{"y":205,"x":176,"time":28805},{"y":204,"x":177,"time":28812},{"y":203,"x":178,"time":28821},{"y":200,"x":180,"time":28845},{"y":199,"x":181,"time":28860},{"y":198,"x":181,"time":28885},{"y":197,"x":181,"time":29022}],"fx":144},{"type":"draw","col":16777010,"time":29381,"fy":194,"id":0,"childlist":[{"y":194,"x":182,"time":29460},{"y":193,"x":184,"time":29484},{"y":193,"x":185,"time":29492},{"y":193,"x":187,"time":29508},{"y":192,"x":190,"time":29516},{"y":191,"x":193,"time":29524},{"y":190,"x":197,"time":29532},{"y":189,"x":203,"time":29548},{"y":188,"x":208,"time":29557},{"y":188,"x":213,"time":29564},{"y":187,"x":218,"time":29572},{"y":186,"x":225,"time":29589},{"y":185,"x":231,"time":29597},{"y":183,"x":236,"time":29604},{"y":182,"x":242,"time":29612},{"y":181,"x":246,"time":29628},{"y":180,"x":249,"time":29636},{"y":180,"x":250,"time":29644},{"y":180,"x":248,"time":29708}],"fx":181},{"type":"draw","col":16777010,"time":30532,"fy":183,"id":0,"childlist":[{"y":184,"x":268,"time":30708},{"y":184,"x":269,"time":30724},{"y":185,"x":271,"time":30732},{"y":185,"x":273,"time":30748},{"y":185,"x":275,"time":30756},{"y":186,"x":278,"time":30765},{"y":186,"x":282,"time":30772},{"y":186,"x":286,"time":30788},{"y":187,"x":292,"time":30796},{"y":187,"x":297,"time":30804},{"y":187,"x":303,"time":30812},{"y":188,"x":308,"time":30828},{"y":188,"x":321,"time":30846},{"y":188,"x":326,"time":30852},{"y":188,"x":330,"time":30868},{"y":189,"x":333,"time":30876},{"y":189,"x":336,"time":30884},{"y":190,"x":338,"time":30900},{"y":190,"x":340,"time":30916},{"y":190,"x":338,"time":30980},{"y":189,"x":337,"time":31021}],"fx":267},{"type":"draw","col":16777010,"time":31692,"fy":201,"id":0,"childlist":[{"y":199,"x":339,"time":31756},{"y":200,"x":339,"time":31852},{"y":201,"x":341,"time":31884},{"y":202,"x":342,"time":31916},{"y":203,"x":343,"time":31924},{"y":204,"x":344,"time":31932},{"y":205,"x":345,"time":31940},{"y":207,"x":348,"time":31956},{"y":209,"x":350,"time":31964},{"y":212,"x":352,"time":31972},{"y":215,"x":355,"time":31988},{"y":219,"x":358,"time":31996},{"y":221,"x":359,"time":32004},{"y":223,"x":362,"time":32012},{"y":226,"x":366,"time":32028},{"y":228,"x":369,"time":32036},{"y":231,"x":372,"time":32044},{"y":233,"x":375,"time":32052},{"y":236,"x":377,"time":32068},{"y":238,"x":381,"time":32076},{"y":241,"x":383,"time":32084},{"y":242,"x":385,"time":32092},{"y":244,"x":388,"time":32108},{"y":244,"x":389,"time":32116},{"y":246,"x":390,"time":32132},{"y":247,"x":391,"time":32222},{"y":248,"x":392,"time":32236},{"y":250,"x":392,"time":32276},{"y":250,"x":394,"time":32364},{"y":251,"x":394,"time":32421},{"y":249,"x":394,"time":32500},{"y":248,"x":391,"time":32516}],"fx":340}]';
			//			
			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}