/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/elgx
 */

// forked from bkzen's 店長＋forked from: [朝ワン] FamilyMart入店音
package 
{
    import com.bit101.components.PushButton;
	import flash.display.BitmapData;
	import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
	import flash.geom.*;
	import flash.display.*;
	import caurina.transitions.Tweener;
    
    /**
     * 上のボタンは普通の音のファミマ入店音。
     * 真ん中のボタンはファミコン音のファミマ入店音。
     * 下のボタンはテンション低い店長
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "60", width = "465", height = "465")]
    public class FamiMartRibbon extends Sprite
    {
        private const familyNote: String = "t85;v4l8o6[ f+d>a<dea4.ef+e>a<d4.r8 ]2;v3l8o5[ r4f+4<c+4.>ea4a4f+4.r8 ]2;";
        private const famiNote: String = "t85;%1@7v8l8o6[ f+d>a<dea4.ef+e>a<d4.r8 ]2;%1@7v7l8o5[ r4f+4<c+4.>ea4a4f+4.r8 ]2;";
        private const familyNote2: String = "t85;v4l8o6[ fd>a<dea4.efe>a<d4.r8 ]2;v3l8o5[ r4f4<c+4.>ea4a4f4.r8 ]2;";
        private var family: SiONData;
        private var fami: SiONData;
        private var family2: SiONData;
        private var driver: SiONDriver;
		
		private var bmd:BitmapData;
		private var cmds:Vector.<int> = new Vector.<int>(4, true);
		private var clrs:Array = [0x3ea538, 0xffffff, 0x188b7];
		private var lastPts:Array = [];
		private var scrollPt:Point;
		public var radius:Number;
		
		
        public function FamiMartRibbon() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            driver = new SiONDriver();
			var dataArray:Array = [
            driver.compile(familyNote),
            driver.compile(familyNote2),
            driver.compile(famiNote)]

			
			stage.addEventListener(MouseEvent.MOUSE_UP, function ():void 
			{
				removeEventListener(Event.ENTER_FRAME, drawHandler);
				lastPts = [];
				Tweener.addTween(driver, 
				{
					volume: 0,
					time: 4.0
				});
			});
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function ():void 
			{
				radius = 1;
				Tweener.addTween(root, 
				{
					radius: Math.random()*80 +50,
					time: 10.0
				});				
				addEventListener(Event.ENTER_FRAME, drawHandler);
				Tweener.removeTweens(driver);
				
				var data:SiONData = dataArray[Math.floor(Math.random() * dataArray.length)];
				if (driver.isPlaying) 
				{
					driver.stop();
					driver.volume = 1;
					driver.play(data);
				}
				else driver.play(data);
			});
			
			addEventListener(Event.ENTER_FRAME, function ():void 
			{
				scrollPt = new Point(Math.floor((mouseX - bmd.width / 2)*-0.1), Math.floor((mouseY - bmd.height / 2)*-0.1));
				bmd.scroll(scrollPt.x, scrollPt.y);
				bmd.colorTransform(bmd.rect, new ColorTransform(0.999, 0.999, 0.999, 1));
			});
			
			bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			addChild(new Bitmap(bmd));
			for (var i:int = 0; i < 4; i++)
			{
				cmds[i] = GraphicsPathCommand.LINE_TO;
			}
			cmds[0] = GraphicsPathCommand.MOVE_TO;
			
        }
		private function drawHandler(e:Event):void 
		{
			var sh:Shape = new Shape();
			var g:Graphics = sh.graphics;
			var pt:Point = new Point(mouseX, mouseY);

			var pts:Array = [
				new Point(0, -1 * radius).add(pt),
				new Point(0, -7/13 * radius).add(pt),
				new Point(0, 11/13 * radius).add(pt),
				new Point(0, 1 * radius).add(pt)
			];
			
			var coords:Vector.<Number> = new Vector.<Number>(8, true);
			if (lastPts.length > 0)
			{
			
			for (var i:int = 0; i < 3; i++)
			{
				coords[0] = lastPts[i].x + scrollPt.x;
				coords[1] = lastPts[i].y +  + scrollPt.y;
				coords[2] = lastPts[i+1].x + scrollPt.x;
				coords[3] = lastPts[i+1].y +  + scrollPt.y;
				coords[4] = pts[i+1].x;
				coords[5] = pts[i+1].y;
				coords[6] = pts[i].x;
				coords[7] = pts[i].y;
				g.beginFill(clrs[i]);
				g.drawPath(cmds, coords, GraphicsPathWinding.NON_ZERO);
			}			
			}
			lastPts = pts;
			bmd.draw(sh);
		}        
    }

}
