/**
 * Copyright nayu ( http://wonderfl.net/user/nayu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eksX
 */

// forked from kawamura's Drag and Drop and Scroll
package  {
    
    import flash.display.MovieClip;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Point;
    
    
    public class Main extends MovieClip {
        public static const UNIT_HEIGHT:Number = 60;
        public static const UNIT_WIDTH:Number =60; 
        public static const UNIT_MARGIN:Number = 10;
        public static const CELL_HEIGHT:Number = 300;
        public static const CELL_WIDTH:Number = 100;
        public static const K:Number =0.2;
        public static const U:Number = 0.4;
        private var draging_unit:Unit;
        private var cell_data:Array =[ 3 , 7 , 3 , 10 ]
        //private var cell_data:Array =[ 2 ];
        //private var cell_data:Array =[ 3 , 1 ];
        private var cell_list:Array = new Array();
        
        public function Main() {
            // constructor code
            var i:uint = 0;
            var n:uint = cell_data.length;
            for(i=0;i<n;i++){
                var cell:Cell = new Cell();
                addChild(cell);
                cell.x=65*0.5 +100*i;
                cell.y=65 + 150;
                cell.init( cell_data[i] , this );
                cell_list.push(cell);
            }
            var drag_layer:MovieClip = new MovieClip();
            addChild(drag_layer);
        }
        public function drag_unit ( _unit:Unit , cell:Cell ):void{
            draging_unit = new Unit();
            addChild(draging_unit);
            draging_unit.init(_unit.obj);
            var global_point:Point = _unit.localToGlobal( new Point(0 ,  0) );;
            draging_unit.x=global_point.x;
            draging_unit.y=global_point.y;
            draging_unit.startDrag();
            stage.addEventListener(MouseEvent.MOUSE_UP,unit_mouseup);
            addEventListener(Event.ENTER_FRAME,unit_enterframe);
        }
        public function cell_save(selected_cell:Cell):void{
            var i:uint;
            var n :uint= cell_list.length;
            for(i = 0 ; i < n ;i++){
                var cell:Cell = cell_list[i];
                cell.reflesh_save();
            }
        }
        //
        private function unit_enterframe(event:Event) : void{
            var i:uint;
            var n:uint = cell_list.length;
            
            for( i=0 ; i<n ;i++){
                var cell:Cell = cell_list[i];
                cell.unit_dragging();
            }
        }
        private function unit_mouseup(event:MouseEvent):void{
            removeEventListener(Event.ENTER_FRAME,unit_enterframe);
            stage.removeEventListener(MouseEvent.MOUSE_UP,unit_mouseup);
            //
            var i:uint;
            var n:uint = cell_list.length;
            for( i=0 ; i<n ;i++){
                var cell:Cell = cell_list[i];
                if(cell.insert_check){
                    dummy_unit = cell.unit_mouseup(draging_unit);
                    break;
                }
                if(i == n-1){
                    var j:uint;
                    var m:uint=cell_list.length;
                    for(j=0; j<m; j++){
                        cell = cell_list[j]
                        if(cell == draging_unit.obj.cell){
                            var dummy_unit :Unit = cell.setSave_unit( draging_unit );
                            
                        }
                    }
                }
            }
            draging_unit.stopDrag();
            //
            draging_unit.dummy_unit=dummy_unit
            draging_unit.pre_x = draging_unit.x;
            draging_unit.pre_y = draging_unit.y;
            draging_unit.addEventListener(Event.ENTER_FRAME,dummy_move);
        }
        private function dummy_move(event:Event):void{
            var unit:Unit  = Unit( event.currentTarget );
            //trace(dummy_unit)
            var global_point:Point = unit.dummy_unit.localToGlobal( new Point(0,0) );
            unit.x = global_point.x;
            unit.y = global_point.y;
            var speed : Number = Math.pow(unit.x -unit.pre_x,2) + Math.pow( unit.y - unit.pre_y,2);
            if(speed <80){
                unit.removeEventListener(Event.ENTER_FRAME,dummy_move);
                removeChild(unit);
            }
            unit.pre_x = unit.x;
            unit.pre_y = unit.y;
            
        }
    }
}

import flash.display.MovieClip;
import flash.display.Graphics;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.Shape;

class Cell extends MovieClip {
    private var main:Main;
    
    private var base_mc:MovieClip;
    
    private var drag_mc:MovieClip;
    private var drag_g:Graphics;
    private var drag_position :uint = 0;

    private var pre_x:Number;
    private var pre_y:Number;

    private var drag_flag:Boolean=false;
    private var mouse_y:Number;
    private var base_y:Number;
    private var position:Number = 0;
    private var target_y:Number;
    private var vy:Number = 0;
    //
    private var dragging_unit:Unit
    private var bg_mc:MovieClip;
    private var bg_g:Graphics;
    private var unit_list:Array;
    private var save_list:Array = [];
    private var insert:int;
    private var insert_flag:Boolean = false;
    //private var dragging_unit:Unit;
    
    
    public function Cell() {
        // constructor code
        bg_mc = new MovieClip();
        bg_g = bg_mc.graphics;
        bg_g.beginFill(0xFFFFFF);
        bg_g.lineStyle(1,0x000000);
        bg_g.drawRect(0 , -0.5*Main.CELL_HEIGHT , Main.CELL_WIDTH , Main.CELL_HEIGHT);
        addChild(bg_mc);
    }
    public function init(value :uint , _main:Main):void{
        main = _main;
        //
        drag_mc = new MovieClip();
        addChild(drag_mc)
        drag_g = drag_mc.graphics;
        drag_g.beginFill(0xFF0000,0.0);
        drag_g.drawRect(0 , Main.CELL_HEIGHT*-0.5 , Main.CELL_WIDTH , Main.CELL_HEIGHT);
        //
        base_mc = new MovieClip();
        addChild(base_mc);
        var mask:Shape = new Shape();
        var mask_gra:Graphics = mask.graphics;
        mask_gra.beginFill(0xFF0000);
        mask_gra.drawRect(0 , -0.5*Main.CELL_HEIGHT , Main.CELL_WIDTH , Main.CELL_HEIGHT);
        addChild(mask)
        base_mc.mask = mask;
        unit_list = new Array();
        var i:uint;
        insert = value;
        for(i=0;i<value ;i++){
            var unit:Unit = new Unit();
            base_mc.addChild(unit);
            unit.x =  (Main.CELL_WIDTH - Main.UNIT_WIDTH)*0.5;
            unit.y =  ( Main.UNIT_HEIGHT + Main.UNIT_MARGIN ) * i -0.5 * (Main.UNIT_HEIGHT + Main.UNIT_MARGIN) *value + 0.5*(Main.UNIT_HEIGHT+Main.UNIT_MARGIN);
            unit.target_x = unit.x;
            unit.target_y = unit.y;
            
            unit.addEventListener(MouseEvent.MOUSE_DOWN,unit_mousedown);
            unit.mouseChildren = false;
            unit.mouseEnabled = true;
            unit.buttonMode = false;
            var color:Number=(100+Math.floor( 155*Math.random() ))*256*256 + (100 + Math.floor( 155*Math.random() ))*256 + (100+Math.floor( 155*Math.random() ));
            var obj:Object=new Object();
            obj.cnt = i;
            obj.cell = this;
            obj.color = color;
            unit.init( obj );
            //
            unit_list.push(unit);
            save_list.push(unit);
        }
        //
        if(unit_list.length > 4){
            drag_mc.buttonMode = true;
            drag_mc.addEventListener(MouseEvent.MOUSE_DOWN,base_down);
        }
        //
        //
        addEventListener(Event.ENTER_FRAME,unit_move);
    }
    private function unit_mousedown(event:MouseEvent):void{
        //
        main.cell_save(this);
        //
        main.setChildIndex(this,main.numChildren-1);
        //
        dragging_unit = Unit(event.currentTarget);
        var i:uint;
        var n:uint = unit_list.length;
        for(i = 0 ; i < n ; i++){
            var unit:Unit = unit_list[i];
            if( dragging_unit == unit ){
                dragging_unit.removeEventListener(MouseEvent.MOUSE_DOWN,unit_mousedown);
                main.drag_unit(dragging_unit , this);
                base_mc.removeChild(dragging_unit);
                unit_list.splice(i,1);
                break;
            }
        }
        //
        if(position <　0){
            position ++;
        }else if(position >0){
            position --;
        }
        //
        set_buttom(unit_list.length);
    }
    //private function unit_dragging(event:Event):void{
    public function unit_dragging():void{
        var i:uint;
        var n:uint = unit_list.length;
        var _x:Number = this.mouseX;
        var _y:Number = this.mouseY - base_mc.y;
        //
        if (n == 0) {
            if(_x > 0 && _x < 100 && this.mouseY > Main.CELL_HEIGHT * -0.5 && this.mouseY < Main.CELL_HEIGHT * 0.5){
                insert_flag =true;
                //
                insert = -1;
            }else {
                insert_flag = false;
            }
        } else {
            var next_unit:Unit;
            var next_y : Number;
            for(i=0 ; i<n ; i++){
                var unit:Unit = unit_list[i];
                var unit_y:Number =unit.y;
                
                if(i == 0){
                    //一番最初について、上と下を調べている。
                    //まず、うえをしらべる
                    if(_x > 0 && _x < 100 &&  _y < unit_y - Main.UNIT_HEIGHT * 0.5 && this.mouseY > Main.CELL_HEIGHT*-0.5 ){
                        setPosition(-1);
                        break;
                    }
                    //したについて
                    if( n == 1){
                        if(_x > 0 && _x < 100 &&  _y > unit_y + Main.UNIT_HEIGHT * 0.5 && this.mouseY < Main.CELL_HEIGHT*0.5){
                            setPosition(i);
                            break;
                        }
                    }else{
                        next_unit =unit_list[i+1];
                        next_y = next_unit.y;
                        if(_x > 0 && _x < 100 && _y > unit_y + Main.UNIT_HEIGHT * 0.5 && _y < next_y){
                            setPosition(i);
                            break;
                        }
                    }
                }else if( i == n-1){
                    //一番最後、下を調べている。
                    if(_x > 0 && _x < 100 &&  _y > unit_y + Main.UNIT_HEIGHT *0.5 && this.mouseY < Main.CELL_HEIGHT*0.5 ){
                        setPosition(i);
                        break;
                    }
                } else if(this.mouseY < Main.CELL_HEIGHT*0.5) {
                    //途中。次との間にあるか調べている。
                    next_unit =unit_list[i+1];
                    next_y = next_unit.y;
                    if(_x > 0 && _x < 100 && _y > unit_y + Main.UNIT_HEIGHT*0.5 && _y < next_y - Main.UNIT_HEIGHT*0.5){
                        setPosition(i);
                        break;
                    }
                }
            }
            if(i == n){
                //なにも無かった。
                setPosition( n );
                //入らなかった処理
                insert_flag = false;
            }
        }
    }
    public function get insert_check():Boolean{
        return insert_flag ;
    }
    public function reflesh_save():void{
        //
        /**/
        var i:uint;
        var n:uint = unit_list.length;
        save_list = [];
        for(i=0 ; i<n ; i++){
            save_list.push(unit_list[i]);
        }
    }
    public function unit_mouseup( _unit:Unit ):Unit{
        var n:int ;
        //
        var dragging_unit:Unit = new Unit();
        base_mc.addChild(dragging_unit);
        dragging_unit.addEventListener(MouseEvent.MOUSE_DOWN,unit_mousedown);
        _unit.obj.cell = this;
        dragging_unit.init(_unit.obj)
        var localPoint:Point = base_mc.globalToLocal( new Point(_unit.x,_unit.y) );
        dragging_unit.x = localPoint.x;
        dragging_unit.y = localPoint.y;
        n = insert+1;
        unit_list.splice( n , 0 , dragging_unit);
        //
        drag_end();
        //
        return dragging_unit ;
    }
    //
    public function setSave_unit( _unit:Unit) :Unit{
        //trace("setSave_unit")
        var dragging_unit:Unit
        var i:uint;
        var n:uint= save_list.length;
        for(i=0 ;  i<n ;i++){
            var j:uint;
            var m:uint = unit_list .length;
            if( m == 0 ){
                dragging_unit = new Unit();
                base_mc.addChild(dragging_unit);
                dragging_unit.addEventListener(MouseEvent.MOUSE_DOWN,unit_mousedown);
                dragging_unit.init(_unit.obj)
                dragging_unit.x = _unit.x - this.x;
                dragging_unit.y = _unit.y - this.y;
                unit_list.splice(i , 0 , dragging_unit);
            }else{
                for(j=0 ; j<m ;j++){
                    if(save_list[i] == unit_list[j]){
                        break;
                    }
                    if(j == m-1){
                        dragging_unit = new Unit();
                        base_mc.addChild(dragging_unit);
                        dragging_unit.addEventListener(MouseEvent.MOUSE_DOWN,unit_mousedown);
                        dragging_unit.init(_unit.obj)
                        dragging_unit.x = _unit.x - this.x;
                        dragging_unit.y = _unit.y - this.y;
                        unit_list.splice(i , 0 , dragging_unit);
                    }
                }
            }
        }
        //
        drag_end();
        //
        return dragging_unit;
    }
    private function drag_end():void{
        var i:uint;
        var n:uint = unit_list.length;
        //
        for(i = 0 ; i < n ; i++){
            var unit:Unit = unit_list[i];
            unit.target_x =  (Main.CELL_WIDTH - Main.UNIT_WIDTH) * 0.5 ;
            unit.target_y =  ( Main.UNIT_HEIGHT + Main.UNIT_MARGIN ) * i -0.5 * (Main.UNIT_HEIGHT + Main.UNIT_MARGIN) *n + 0.5*(Main.UNIT_HEIGHT+Main.UNIT_MARGIN);
            unit.obj.cell = this;
            unit.addEventListener(MouseEvent.MOUSE_DOWN,unit_mousedown);
        }
        //
        set_buttom(n);
        //
    }
    private function set_buttom(n:uint):void{
        if(n > 4){
            drag_mc.buttonMode = true;
            drag_mc.addEventListener(MouseEvent.MOUSE_DOWN,base_down);
        }else {
            drag_mc.buttonMode = false;
            drag_mc.removeEventListener(MouseEvent.MOUSE_DOWN,base_down);
        }
    }
    private function setPosition( value:Number ):void{
        insert_flag =true;
        //
        insert = value;
        //
        var i:uint;
        var n:uint = unit_list.length;
        for(i = 0 ; i < n ; i++){
            var unit:Unit = unit_list[i];
            if(insert < n){
                unit.target_y =  (Main.UNIT_HEIGHT + Main.UNIT_MARGIN ) * i -0.5 *  (Main.UNIT_HEIGHT + Main.UNIT_MARGIN) * (n+1) + 0.5*(Main.UNIT_HEIGHT+Main.UNIT_MARGIN);
            }else{
                unit.target_y =  (Main.UNIT_HEIGHT + Main.UNIT_MARGIN ) * i -0.5 *  (Main.UNIT_HEIGHT + Main.UNIT_MARGIN) * n + 0.5*(Main.UNIT_HEIGHT+Main.UNIT_MARGIN);
            }
            
            if( i > insert){
                unit.target_y += (Main.UNIT_HEIGHT + Main.UNIT_MARGIN + 2);
            }
        }
    }
    private function unit_move(event:Event):void{
        var ay :Number;
        var dy:Number;
        var i:uint;
        var n:uint = unit_list.length;
        for(i = 0 ; i < n ; i++){
            var unit:Unit = unit_list[i];
            dy = unit.target_y - unit.y;
            unit.y += dy * 0.45; 
            var dx:Number =unit.target_x - unit.x;
            unit.x += dx * 0.3;
        }
        if(drag_flag){
            pre_y = this.mouseY;
            dy = mouse_y - this.mouseY;
            position = Math.round( (base_y - dy) / (Main.UNIT_HEIGHT + Main.UNIT_MARGIN) );
            var m:uint = Math.ceil( unit_list.length*0.5 - 2);
            if( Math.abs(position) > m  ){
                position = m * (Math.abs(position)/position);
            }
        }
        target_y = position * (Main.UNIT_HEIGHT + Main.UNIT_MARGIN)
        ay= Main.K * (target_y - base_mc.y)
        vy += ay - Main.U * vy;
        base_mc.y += vy;
    }
    private function base_down(event:MouseEvent):void{
        var area_height:Number = unit_list[ unit_list.length-1 ].y - unit_list[0].y + Main.UNIT_HEIGHT - Main.CELL_HEIGHT;
        var bounds:Rectangle=new Rectangle(0,area_height*-0.5 , 0 , area_height);
        //base_mc.startDrag(false,bounds);
        drag_flag = true;
        mouse_y = this.mouseY;
        base_y = base_mc.y;
        stage.addEventListener(MouseEvent.MOUSE_UP,base_up,false,0,false);
    }
    private function base_up(event:MouseEvent):void{
        stage.removeEventListener(MouseEvent.MOUSE_UP,base_up);
        //base_mc.stopDrag();
        vy = this.mouseY -pre_y;
        drag_flag = false ;
    }
}

import flash.display.MovieClip;
import flash.display.Graphics;
import flash.text.TextField;

class Unit extends MovieClip{
    public var dummy_unit:Unit;
    public var pre_x:Number;
    public var pre_y:Number;
    public var obj:Object;
    public var target_x:Number;
    public var target_y:Number;
    //
    private var bg_mc:MovieClip;
    private var bg_g:Graphics;
    //
    private var color:Number;
    public function Unit() {
        // constructor code
        bg_mc = new MovieClip();
        addChild(bg_mc);
        bg_g = bg_mc.graphics;
        bg_mc.mouseChildren = false;
        bg_mc.mouseEnabled = false;
        bg_mc.enabled =false;
    }
    public function init( _obj :Object ):void{
        obj = _obj;
        bg_g.beginFill( obj.color );
        bg_g.drawRect(0,Main.UNIT_HEIGHT*-0.5 , Main.UNIT_WIDTH , Main.UNIT_HEIGHT);
        var tf:TextField = new TextField();
        tf.width = 30;
        tf.height = 20;
        addChild(tf);
        tf.text = String(obj.cnt);
        tf.selectable = false;
    }
}