/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ekiG
 */

package 
{
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    /**
     * ...
     * @author Thi
     */
    public class Main extends Sprite 
    {
        //
        private var eles:Vector.<Ele> = new Vector.<Ele>()
        private var usedXY:Vector.<Number>
        
        //
        private var i:int, l:int // l = length
        private var j:int, k:int
        
        //
        private var field_data:BitmapData = new BitmapData(465, 465, false, 0xA0A0A0)
        private var field_bitmap:Bitmap = new Bitmap(field_data, "auto", true)
        
        //
        private var itensity:int
        private var dx:Number, dy:Number
        
        private var tf:TextField
        
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.frameRate = 40
            //
            this.addChild(field_bitmap)
            // text
            tf = new TextField()
            this.addChild(tf)
            tf.defaultTextFormat = new TextFormat("Arial", 20,null,null,null,null,null,null,TextFormatAlign.CENTER)
            tf.text = "+"; tf.type = "dynamic"
            tf.width = 465; tf.height = 20
            tf.selectable = false; tf.border = true; 
            tf.backgroundColor = 0xFFFFFF; tf.background = true
            //
            vector = new Shape()
            addChild(vector)
            vector.blendMode = BlendMode.INVERT
            // listener
            stage.addEventListener(MouseEvent.CLICK, click)
            stage.addEventListener(Event.ENTER_FRAME, ef)
        }
        
        
        private function click(e:MouseEvent):void
        {
            if (mouseY > 20)
            {
                ++l
                eles.push(new Ele(mouseX, mouseY, tf.text == "+" ? 0xFFFFFF : -0xFFFFFF))
                // draw magnetic field
                field()
            } else
            {
                tf.text = tf.text == "+" ? "-" : "+"
            }
        }
        
        private function field():void
        {
            //
            usedXY = null
            usedXY = new Vector.<Number>(l * 2, true)
            //
            i = -1
            while (++i < l)
            {
                // setup the x distance
                usedXY[int(i * 2)] = (eles[i].x)
                // setup the y distance
                usedXY[int(i * 2 + 1)] = (eles[i].y + 1)
            }
            
            j = -1
            while (++j < 465)
            {
                i = -1
                while (++i < l)
                {
                    // change the y distance
                    usedXY[int(i * 2 + 1)] -= 1
                }
                
                k = -1
                while (++k < 465)
                {
                    itensity = 0
                    i = -1
                    while (++i < l)
                    {
                        // setup the 'now' x and y distances
                        dx = usedXY[int(i * 2)] - k
                        dy = usedXY[int(i * 2 + 1)]
                        itensity += eles[i].f / (dx*dx + dy*dy)
                    }
                    field_data.setPixel(k, j, uint(itensity))
                }
            }
        }
        
        private var vector:Shape, g:Graphics
        private function ef(e:Event):void
        {
            g =  vector.graphics
            g.clear()
            g.lineStyle(2,0xFFFFFF)
            //
            var X:Number = 0, Y:Number = 0, D:Number
             i = -1
            while (++i < l)
            {
                dx = (eles[i].x) - mouseX
                dy = (eles[i].y) - mouseY
                D = (dx*dx) + (dy*dy)
                if(eles[i].f > 0)
                {
                    X -= dx / D
                    Y -= dy / D
                } else
                {
                    X += dx / D
                    Y += dy / D
                }


                
            }
            g.moveTo(mouseX, mouseY)
            g.lineTo(mouseX + X*2000,mouseY + Y*2000)
            
            
            
            
        }

        
    }
}

//package  
//{
    /**
     * ...
     * @author Thi
     */
    /*public*/ class Ele
    {
        public var x:Number, y:Number, f:int
        
        public function Ele(x:Number, y:Number, f:Number) 
        {
            this.x = x
            this.y = y
            this.f = f
        }
        
    }

//}