/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ejrt
 */

// forked from mex's 【AS100本ノック】12回目：時計
/**
 * AS100本ノック
 * 12回目のお題は「時計」
 * あなたなりの「時計」を表現してください。
 * 
 * 
 * 1日を秒単位で表示。
 * 残りの秒数が視覚的にすぐわかる。
 * wonderflだと全部入りきらないところが残念、、
 * →ドラッグで残りが見れる。
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	
	/**
	 * @author Mao Takagi
	 */
	[SWF(backgroundColor = "#000000", frameRate = 30, width = "465", height = "465")]
	public class Main extends Sprite 
	{
		private const _DAY_ARRAY:Array = ["sun", "mon", "tue", "wed", "thu", "fri", "sat"];
		
		private var _hourContainer:HourContainer;
		private var _canvasBmp:Bitmap;
		private var _canvas:Sprite;
		private var _timer:Timer;
		private var _dragRectangle:Rectangle;
		private var _digitContainer:DigitContainer;
		private var _clone:Bitmap;
		private var _container:Sprite;
		/**
		 * constructor
		 */
		public function Main():void 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			_canvas = new Sprite();
			_hourContainer = new HourContainer(724, 482);
			_canvasBmp = new Bitmap(_hourContainer);
			_canvas.addChild(_canvasBmp);
			_container = new Sprite();
			_container.addChild(_canvas);
			
			_digitContainer = new DigitContainer();
			_container.addChild(_digitContainer);
			
			_dragRectangle = new Rectangle(0, 0, stage.stageWidth - _hourContainer.width, stage.stageHeight - _hourContainer.height);
			
			_canvas.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
			_canvas.addEventListener(MouseEvent.MOUSE_UP, upHandler);
			
			_timer = new Timer(1 * 1000);
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);
			_timer.start();
			timerHandler();
			
			addChild(_container);
		}
		/**
		 * downHandler
		 * @param event MouseEvent
		 */
		private function downHandler(event:MouseEvent):void 
		{
			_container.startDrag(false, _dragRectangle);
		}
		/**
		 * downHandler
		 * @param event MouseEvent
		 */
		private function upHandler(event:MouseEvent):void 
		{
			_container.stopDrag();
		}
		/**
		 * enterFrameHandler
		 * @param event Event
		 */
		private function timerHandler(event:TimerEvent = null):void 
		{
			var _date:Date = new Date();
			var year:uint = _date.getFullYear();
			var month:uint = _date.getMonth() + 1;
			var date:uint = _date.getDate();
			var hour:uint = _date.getHours();
			var min:uint = _date.getMinutes();
			var sec:uint = _date.getSeconds();
			var day:String = _DAY_ARRAY[_date.getDay()];
			_hourContainer.update(hour, min, sec);
			_digitContainer.update(addZero(year, 4), addZero(month, 2), addZero(date, 2), day);
		}
		/**
		 * ゼロを足す
		 * @param	num
		 * @param	digit
		 * @return
		 */
		public static function addZero(num:uint, digit:uint):String
		{
			var str:String = num.toString();
			var len:uint = str.length;
			var zeroNum:int = digit - len;
			if (zeroNum > 0)
			{
				var temp:String = "";
				for (var i:uint = 0; i < zeroNum;i++ )
				{
					temp += "0";
				}
				str = temp + str;
			}
			return str;
		}
	}
}
/**
 * 時間のユニット
 */
import flash.display.BitmapData;
import flash.display.Shape;
import flash.geom.Matrix;
class HourContainer extends BitmapData 
{
	private const SPAN_X:uint = 121;
	private const SPAN_Y:uint = 121;
	private var _minArray:Vector.<MinContainer>;
	/**
	 * constructor
	 */
	public function HourContainer(w:uint, h:uint)
	{
		super(w, h, true, 0xFF000000);
		_minArray = new Vector.<MinContainer>();
		Set();
	}
	/**
	 * Set
	 */
	public function Set():void 
	{
		for (var i:uint = 0; i < 4; i++ )
		{
			for (var j:uint = 0; j < 6; j++ )
			{
				var matrix:Matrix = new Matrix();
				matrix.translate(j * SPAN_X, i * SPAN_Y);
				var min:MinContainer = new MinContainer(120, 120, matrix);
				draw(min, matrix);
				_minArray.push(min);
			}
		}
	}
	/**
	 * update
	 */
	public function update(hour:uint, min:uint, sec:uint):void 
	{
		fillRect(rect, 0xFF000000);
		for (var i:uint = 0; i < hour;i++ )
		{
			_minArray[i].update(59, 60);
		}
		_minArray[hour].update(min, sec);
		
		lock();
		for (i = 0; i < 24; i++)
		{
			draw(_minArray[i], _minArray[i].matrix);
		}
		unlock();
	}
}
/**
 * 分のユニット
 */
import flash.display.BitmapData;
import flash.geom.Matrix;
class MinContainer extends BitmapData 
{
	private const SPAN:uint = 2;
	public var matrix:Matrix;
	private var _secArray:Vector.<SecContainer>;
	/**
	 * constructor
	 */
	public function MinContainer(w:uint, h:uint, matrix:Matrix)
	{
		super(w, h, true, 0xFF000000);
		this.matrix = matrix;
		_secArray = new Vector.<SecContainer>();
		Set();
	}
	/**
	 * update
	 */
	public function Set():void 
	{
		for (var i:uint = 0; i < 60; i++ )
		{
			var matrix:Matrix = new Matrix();
			matrix.translate(0, i * SPAN);
			var sec:SecContainer = new SecContainer(120, 1);
			draw(sec, matrix);
			_secArray.push(sec);
		}
	}
	/**
	 * update
	 */
	public function update(min:uint, sec:uint):void 
	{
		fillRect(rect, 0xFF000000);
		var i:uint;
		for (i = 0; i < min; i++)
		{
			_secArray[i].Set(60);
		}
		_secArray[min].Set(sec);
		
		lock();
		for (i = 0; i < 60; i++)
		{
			var matrix:Matrix = new Matrix();
			matrix.translate(0, i * SPAN);
			draw(_secArray[i], matrix);
		}
		unlock();
	}
}
/**
 * 秒のユニット
 */
import flash.display.BitmapData;
class SecContainer extends BitmapData 
{
	private const SPAN:uint = 2;
	/**
	 * constructor
	 */
	public function SecContainer(w:uint, h:uint)
	{
		super(w, h, true, 0xFF000000);
		Set(0);
	}
	/**
	 * update
	 */
	public function Set(num:uint):void 
	{
		fillRect(rect, 0xFF000000);
		for (var i:uint = 0; i < 60; i++ )
		{
			var color:uint = 0x333333;
			if (i < num)
			{
				color = 0xff0066;
			}
			setPixel(i * SPAN, 0, color);
		}
	}
}
/**
 * 年月日のユニット
 */
import flash.display.Sprite;
class DigitContainer extends Sprite
{
	private var _year1000:Digit;
	private var _year100:Digit;
	private var _year10:Digit;
	private var _year1:Digit;
	private var _month10:Digit;
	private var _month1:Digit;
	private var _date10:Digit;
	private var _date1:Digit;
	private var _day1:Digit;
	private var _day2:Digit;
	private var _day3:Digit;
	/**
	 * constructor
	 */
	public function DigitContainer()
	{
		_year1000 = new Digit();
		_year100 = new Digit();
		_year10 = new Digit();
		_year1 = new Digit();
		_month10 = new Digit();
		_month1 = new Digit();
		_date10 = new Digit();
		_date1 = new Digit();
		_day1 = new Digit();
		_day2 = new Digit();
		_day3 = new Digit();
		
		_year100.x = 121;
		_year10.x = 242;
		_year1.x = 363;
		
		_month10.y = 121;
		_month1.x = 121;
		_month1.y = 121;
		
		_date10.y = 242;
		_date1.x = 121;
		_date1.y = 242;
		
		_day1.y = 363;
		_day2.x = 121;
		_day2.y = 363;
		_day3.x = 242;
		_day3.y = 363;
		
		addChild(_year1000);
		addChild(_year100);
		addChild(_year10);
		addChild(_year1);
		addChild(_month10);
		addChild(_month1);
		addChild(_date10);
		addChild(_date1);
		addChild(_day1);
		addChild(_day2);
		addChild(_day3);
		
		blendMode = "overlay";
	}
	/**
	 * update
	 * @param	year
	 * @param	month
	 * @param	date
	 */
	public function update(year:String, month:String, date:String, day:String):void 
	{
		_year1000.update(year.charAt(0));
		_year100.update(year.charAt(1));
		_year10.update(year.charAt(2));
		_year1.update(year.charAt(3));
		_month10.update(month.charAt(0));
		_month1.update(month.charAt(1));
		_date10.update(date.charAt(0));
		_date1.update(date.charAt(1));
		_day1.update(day.charAt(0));
		_day2.update(day.charAt(1));
		_day3.update(day.charAt(2));
	}
}
/**
 * 年月日の最小単位
 */
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.LineScaleMode;
import flash.display.CapsStyle;
import flash.display.JointStyle;
class Digit extends Sprite
{
	/**
	 * constructor
	 */
	public function Digit(){}
	/**
	 * 
	 */
	public function update(character:String):void 
	{
		if (numChildren == 1) removeChild(getChildAt(0));
		var digit:Shape = generateCharacter(character);
		digit.x = 36;
		digit.y = 12;
		addChild(digit);
	}
	/**
	 * 
	 */
	private function generateCharacter(character:String):Shape 
	{
		var shape:Shape = new Shape();
		shape.graphics.lineStyle(10, 0xFFFFFF, 1, true, LineScaleMode.NORMAL, CapsStyle.SQUARE, JointStyle.MITER, 0);
		switch(character)
		{
			case "0":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(4, 4);
				break;
			case "1":
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(67, 91);
				break;
			case "2":
				shape.graphics.moveTo(0, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 49);
				shape.graphics.lineTo(4, 49);
				shape.graphics.lineTo(4, 95);
				shape.graphics.lineTo(67, 95);
				break;
			case "3":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				break;
			case "4":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(4, 48);
				shape.graphics.lineTo(67, 48);
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(67, 91);
				break;
			case "5":
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(4, 48);
				shape.graphics.lineTo(67, 48);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(0, 91);
				break;
			case "6":
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(4, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				break;
			case "7":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(67, 91);
				break;
			case "8":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(4, 4);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				break;
			case "9":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(4, 4);
				break;
			case "m":
				shape.graphics.moveTo(4, 91);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(36, 48);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				break;
			case "o":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(4, 4);
				break;
			case "n":
				shape.graphics.moveTo(4, 91);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(67, 4);
				break;
			case "t":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.moveTo(36, 4);
				shape.graphics.lineTo(36, 91);
				break;
			case "u":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(67, 4);
				break;
			case "e":
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(67, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				break;
			case "w":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(36, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(67, 4);
				break;
			case "d":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(57, 4);
				shape.graphics.lineTo(67, 14);
				shape.graphics.lineTo(67, 81);
				shape.graphics.lineTo(57, 91);
				shape.graphics.lineTo(4, 91);
				shape.graphics.lineTo(4, 4);
				break;
			case "h":
				shape.graphics.moveTo(4, 4);
				shape.graphics.lineTo(4, 91);
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				break;
			case "f":
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(4, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				break;
			case "r":
				shape.graphics.moveTo(4, 91);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 48);
				shape.graphics.lineTo(4, 48);
				shape.graphics.moveTo(57, 48);
				shape.graphics.lineTo(67, 91);
				break;
			case "i":
				shape.graphics.moveTo(36, 4);
				shape.graphics.lineTo(36, 91);
				break;
			case "s":
				shape.graphics.moveTo(67, 4);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(4, 48);
				shape.graphics.lineTo(67, 48);
				shape.graphics.lineTo(67, 91);
				shape.graphics.lineTo(4, 91);
				break;
			case "a":
				shape.graphics.moveTo(4, 91);
				shape.graphics.lineTo(4, 4);
				shape.graphics.lineTo(67, 4);
				shape.graphics.lineTo(67, 91);
				shape.graphics.moveTo(4, 48);
				shape.graphics.lineTo(67, 48);
				break;
		}
		return shape;
	}
}