/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eiv4
 */

// forked from tkinjo's 色相
package
{
     import flash.display.*;
     import flash.events.*;
     import flash.geom.*;
     
     [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
     /**
      * 色相環
      * 
      * @author tkinjo
      */
     public class Main extends Sprite
     {
          private var stageWidth:Number  = stage.stageWidth;
          private var stageHeight:Number = stage.stageHeight;
          private var stageCenter:Point  = new Point( stageWidth / 2, stageHeight / 2 );
          
          public function Main() 
          {
                var bitmapData:BitmapData = new BitmapData( stageWidth, stageHeight, false );
                
                bitmapData.lock();
                
                for ( var i:int = 0; i < stageWidth; i++ ) {
                     
                     for ( var j:int = 0; j < stageHeight; j++ ) {
                          
                          bitmapData.setPixel( i, j, getColor( new Point( i, j ) ) );
                     }
                }
                
                bitmapData.unlock();
                
                var bitmap:Bitmap = new Bitmap( bitmapData );
                addChild( bitmap );
          }
          
          private function getColor( point:Point ):uint {
                
			var pointFromStageCenter:Point = point.subtract( stageCenter );
			var pointBearingFromStageCenter:Number = Math.atan2( pointFromStageCenter.y, pointFromStageCenter.x ) * 180 / Math.PI;
			
			if ( pointBearingFromStageCenter < 0 )
				pointBearingFromStageCenter = pointBearingFromStageCenter + 360;
			
                return HSVtoRGB( pointBearingFromStageCenter, 1, 1 );
          }
          
          private function HSVtoRGB( h:Number, s:Number, v:Number ):uint {
                
                var Hi:uint = ( h / 60 ) % 6;
                
                var f:Number = h / 60 - Hi;
                
                var p:Number = v * ( 1 - s );
                
                var q:Number = v * ( 1 - f * s );
                
                var t:Number = v * ( 1 - ( 1 - f ) * s );
                
                switch( Hi ) {
                     
                     case 0:
                          return toRGB255( v, t, p );
                          
                     case 1:
                          return toRGB255( q, v, p );
                          
                     case 2:
                          return toRGB255( p, v, t );
                          
                     case 3:
                          return toRGB255( p, q, v );
                          
                     case 4:
                          return toRGB255( t, p, v );
                          
                     case 5:
                          return toRGB255( v, p, q );
                }
                
                return 0;
          }
          
          
          private function toRGB255( r:Number, g:Number, b:Number ):uint {
                
                return ( r * 255 << 16 ) + ( g * 255 << 8 ) + b * 255;
          }
     }
}
