/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ei0c
 */

package  {
    
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;

    public class World2D extends Sprite {

        private const _terrainSpriteURL:    String = "http://assets.wonderfl.net/images/related_images/7/78/7800/7800c79b3613c84bfa513b1ed54ed20b8595ffbb";
        private const _characterSpriteURL:    String = "http://assets.wonderfl.net/images/related_images/9/93/935a/935a7171020c2f07e100d43da6a2b17fb04e6019";
        private const _terrainSize:            Point = new Point ( 32, 32 );
        private const _viewRectangle:        Rectangle = new Rectangle ( 10, 10, _terrainSize.x * 14, _terrainSize.y * 11 );
        
        private var _character:                BaseUnit;
        private var _terrainSpriteBMD:        BitmapData;
        private var _characterSpriteBMD:    BitmapData;
        private var _terrainPiece:            uint;
        private var _world:                    Bitmap;
        private var _worldData:                Array = [[]];
        private var _worldOffsets:            Array = [];
        private var _keyDatas:                Array = [];
        private var _characterSpeed:        Number = 4;

        public function World2D () :void {
            loadImage ( _terrainSpriteURL, terrainSpriteLoaded );
        }
        
        private function loadImage ( $url:String, $onComplete:Function ) :void {
            var imageLoader:Loader = new Loader ();
            imageLoader.contentLoaderInfo.addEventListener ( Event.COMPLETE, $onComplete );
            var image:URLRequest = new URLRequest ( $url );
            imageLoader.load ( image, new LoaderContext ( true ) );
        }
        
        private function terrainSpriteLoaded ( event:Event ) :void {
             _terrainSpriteBMD = new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 );
             _terrainSpriteBMD.draw ( event.currentTarget.content );
             _terrainPiece = _terrainSpriteBMD.width / _terrainSize.x;
             loadImage ( _characterSpriteURL, characterSpriteLoaded );
        }
        
        private function characterSpriteLoaded ( event:Event ) :void {
            _characterSpriteBMD = new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 );
            _characterSpriteBMD.draw ( event.currentTarget.content );
            init ();
        }
        
        private function init () :void {
            _world = addChild ( new Bitmap () ) as Bitmap;
            _world.bitmapData = new BitmapData ( _viewRectangle.width, _viewRectangle.height );
            _world.x = _viewRectangle.x;
            _world.y = _viewRectangle.y;
            var frame:Sprite = addChild ( new Sprite () ) as Sprite;
            frame.x = _viewRectangle.x;
            frame.y = _viewRectangle.y;
            frame.graphics.beginFill ( 0x000000 );
            frame.graphics.drawRect ( _terrainSize.x, 0, _world.width - _terrainSize.x * 2, _terrainSize.y );
            frame.graphics.drawRect ( _terrainSize.x, _world.height - _terrainSize.y, _world.width - _terrainSize.x * 2, _terrainSize.y );
            frame.graphics.drawRect ( 0, 0, _terrainSize.x, _world.height );
            frame.graphics.drawRect ( _world.width - _terrainSize.x, 0, _terrainSize.x, _world.height );
            _worldOffsets["UP"] = 0;
            _worldOffsets["DOWN"] = 0;
            _worldOffsets["LEFT"] = 0;
            _worldOffsets["RIGHT"] = 0;
            for ( var i:uint = 0; i < Math.ceil ( _viewRectangle.width / _terrainSize.x ); i++ ) {
                //if ( _worldData.length - 1 < i )
                    //_worldData.push ( [] );
                for ( var j:uint = 0; j < Math.ceil ( _viewRectangle.height / _terrainSize.y ); j++ ) {
                    var selectedTerrain:uint = Math.floor ( Math.random () * _terrainPiece );
                    //if ( _worldData[i].length - 1 < j )
                        //_worldData[i].push ( [] );
                    //_worldData[i][j] = selectedTerrain;
                    _world.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( selectedTerrain * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( i * _terrainSize.x, j * _terrainSize.y ) );
                }
            }
            _character = addChild ( new BaseUnit ( 5 ) ) as BaseUnit;
            var characterSpriteSetting:CharacterSpriteSetting = new CharacterSpriteSetting ();
            characterSpriteSetting.baseBitmapData = _characterSpriteBMD;
            characterSpriteSetting.animationDelay = 3;
            characterSpriteSetting.startDirection = BaseUnit.LB;
            characterSpriteSetting.spriteSize = new Point ( 80, 64 );
            characterSpriteSetting.spriteOffset = new Point ( -40, -55 );
            characterSpriteSetting.moveAnimationLTStartPoint = new Point ( 0, 192 );
            characterSpriteSetting.moveAnimationLTFrameCount = 4;
            characterSpriteSetting.moveAnimationRTStartPoint = new Point ( 0, 192 );
            characterSpriteSetting.moveAnimationRTFrameCount = 4;
            characterSpriteSetting.moveAnimationLStartPoint = new Point ( 0, 64 );
            characterSpriteSetting.moveAnimationLFrameCount = 4;
            characterSpriteSetting.moveAnimationRStartPoint = new Point ( 0, 128 );
            characterSpriteSetting.moveAnimationRFrameCount = 4;
            characterSpriteSetting.moveAnimationLBStartPoint = new Point ( 0, 0 );
            characterSpriteSetting.moveAnimationLBFrameCount = 4;
            characterSpriteSetting.moveAnimationRBStartPoint = new Point ( 0, 0 );
            characterSpriteSetting.moveAnimationRBFrameCount = 4;
            _character.setCharacterSprite ( characterSpriteSetting );
            _character.x = _viewRectangle.width / 2;
            _character.y = _viewRectangle.height / 2 + 25;
            _keyDatas["UP"] = false;
            _keyDatas["DOWN"] = false;
            _keyDatas["LEFT"] = false;
            _keyDatas["RIGHT"] = false;
            stage.addEventListener ( KeyboardEvent.KEY_DOWN, keyDown );
            stage.addEventListener ( KeyboardEvent.KEY_UP, keyUp );
            stage.addEventListener ( Event.ENTER_FRAME, core );
        }
        
        private function core ( event:Event ) :void {
            var offset:Point = new Point ();
            if ( _keyDatas["UP"] ) {
                _worldOffsets["UP"] += _characterSpeed;
                _worldOffsets["DOWN"] += _characterSpeed;
                if ( _worldOffsets["DOWN"] >= 0 )
                    _worldOffsets["DOWN"] -= _terrainSize.y;
                offset.y = _characterSpeed;
            } else if ( _keyDatas["DOWN"] ) {
                _worldOffsets["UP"] -= _characterSpeed;
                if ( _worldOffsets["UP"] <= 0 )
                    _worldOffsets["UP"] += _terrainSize.y;
                _worldOffsets["DOWN"] -= _characterSpeed;
                offset.y = -_characterSpeed;
            }
            if ( _keyDatas["LEFT"] ) {
                offset.x = _characterSpeed;
                _worldOffsets["LEFT"] += _characterSpeed;
                _worldOffsets["RIGHT"] += _characterSpeed;
                if ( _worldOffsets["RIGHT"] >= 0 )
                    _worldOffsets["RIGHT"] -= _terrainSize.x;
            } else if ( _keyDatas["RIGHT"] ) {
                offset.x = -_characterSpeed;
                _worldOffsets["LEFT"] -= _characterSpeed;
                if ( _worldOffsets["LEFT"] <= 0 )
                    _worldOffsets["LEFT"] += _terrainSize.x;
                _worldOffsets["RIGHT"] -= _characterSpeed;
            }
            _world.bitmapData.scroll ( offset.x, offset.y );
            while ( _worldOffsets["RIGHT"] <= -_terrainSize.x ) {
                addCol ();
                _worldOffsets["RIGHT"] += _terrainSize.x;
            }
            while ( _worldOffsets["LEFT"] >= _terrainSize.x ) {
                addCol ( false );
                _worldOffsets["LEFT"] -= _terrainSize.x;
            }
            while ( _worldOffsets["DOWN"] <= -_terrainSize.y ) {
                addRow ();
                _worldOffsets["DOWN"] += _terrainSize.y;
            }
            while ( _worldOffsets["UP"] >= _terrainSize.y ) {
                addRow ( false );
                _worldOffsets["UP"] -= _terrainSize.y;
            }
            var direction:String = "";
            if ( _keyDatas["UP"] ) {
                if ( _keyDatas["RIGHT"] )
                    direction = BaseUnit.RT;
                else if ( _keyDatas["LEFT"] )
                    direction = BaseUnit.LT;
                else
                    direction = BaseUnit.LT;
            } else if ( _keyDatas["DOWN"] ) {
                if ( _keyDatas["RIGHT"] )
                    direction = BaseUnit.RB;
                else if ( _keyDatas["LEFT"] )
                    direction = BaseUnit.LB;
                else
                    direction = BaseUnit.LB;
            } else if ( _keyDatas["RIGHT"] ) {
                if ( _keyDatas["UP"] )
                    direction = BaseUnit.RT;
                else if ( _keyDatas["DOWN"] )
                    direction = BaseUnit.RB;
                else
                    direction = BaseUnit.R;
            } else if ( _keyDatas["LEFT"] ) {
                if ( _keyDatas["UP"] )
                    direction = BaseUnit.LT;
                else if ( _keyDatas["DOWN"] )
                    direction = BaseUnit.LB;
                else
                    direction = BaseUnit.L;
            }
            if ( _character.direction != direction )
                _character.direction = direction;
            if ( _keyDatas["UP"] || _keyDatas["DOWN"] || _keyDatas["RIGHT"] || _keyDatas["LEFT"] )
                _character.update ();
        }
        
        private function addCol ( $toRight:Boolean = true ) :void {
            for ( var i:uint = 0; i < Math.ceil ( _viewRectangle.height / _terrainSize.y ); i++ ) {
                //if ( _worldData.length - 1 < i )
                    //_worldData.push ( [] );
                var selectedTerrain:uint = Math.floor ( Math.random () * _terrainPiece );
                //_worldData[i].push ( [] );
                //_worldData[i][_worldData[i].length - 1] = selectedTerrain;
                _world.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( selectedTerrain * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( $toRight ? _world.bitmapData.width + _worldOffsets["RIGHT"] : 0, i * _terrainSize.y + _worldOffsets["DOWN"] ) );
            }
        }
        
        private function addRow ( $toDown:Boolean = true ) :void {
            for ( var i:uint = 0; i < Math.ceil ( _viewRectangle.width / _terrainSize.x ); i++ ) {
                //if ( _worldData.length - 1 < i )
                    //_worldData.push ( [] );
                var selectedTerrain:uint = Math.floor ( Math.random () * _terrainPiece );
                //_worldData[i].push ( [] );
                //_worldData[i][_worldData[i].length - 1] = selectedTerrain;
                _world.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( selectedTerrain * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( i * _terrainSize.x + _worldOffsets["RIGHT"], $toDown ? _world.bitmapData.height + _worldOffsets["DOWN"] : 0 ) );
            }
        }
        
        private function keyDown ( event:KeyboardEvent ) :void {
            switch ( event.keyCode ) {
                case Keyboard.UP:
                    _keyDatas["UP"] = true;
                    break;
                case Keyboard.DOWN:
                    _keyDatas["DOWN"] = true;
                    break;
                case Keyboard.LEFT:
                    _keyDatas["LEFT"] = true;
                    break;
                case Keyboard.RIGHT:
                    _keyDatas["RIGHT"] = true;
                    break;
            }
        }
        
        private function keyUp ( event:KeyboardEvent ) :void {
            switch ( event.keyCode ) {
                case Keyboard.UP:
                    _keyDatas["UP"] = false;
                    break;
                case Keyboard.DOWN:
                    _keyDatas["DOWN"] = false;
                    break;
                case Keyboard.LEFT:
                    _keyDatas["LEFT"] = false;
                    break;
                case Keyboard.RIGHT:
                    _keyDatas["RIGHT"] = false;
                    break;
            }
        }
        
    }
    
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
class BaseUnit extends Sprite {
    
    public static const LT:                    String = "BaseUnit.LT";
    public static const RT:                    String = "BaseUnit.RT";
    public static const L:                    String = "BaseUnit.L";
    public static const R:                    String = "BaseUnit.R";
    public static const LB:                    String = "BaseUnit.LB";
    public static const RB:                    String = "BaseUnit.RB";
    
    private var _characterSpriteSetting:    CharacterSpriteSetting;
    
    private var characterSprite:            BitmapData;
    private var characterBitmap:            Bitmap;
    
    private var _direction:                    String;
    
    public var speed:                        Number = .5;
    public var characterRotation:            Number = 0;
    
    private var animationIndex:                uint = 0;
    private var animationDelay:                uint = 0;
    
    public var rotateUnit:                    Boolean = false;
    
    public function BaseUnit ( $speed:Number = .5 ) :void {
        speed = $speed;
    }
    
    public function update () :void {
        updateGraphic ();
    }
    
    public function setCharacterSprite ( $characterSpriteSetting:CharacterSpriteSetting ) :void {
        _characterSpriteSetting = $characterSpriteSetting;
        characterSprite = _characterSpriteSetting.baseBitmapData;
        characterBitmap = new Bitmap ();
        characterBitmap.bitmapData = new BitmapData ( _characterSpriteSetting.spriteSize.x, _characterSpriteSetting.spriteSize.y, true, 0x60 );
        addChild ( characterBitmap );
        characterBitmap.x = _characterSpriteSetting.spriteOffset.x;
        characterBitmap.y = _characterSpriteSetting.spriteOffset.y;
        direction = _characterSpriteSetting.startDirection;
        updateGraphic ( true );
    }
    
    private function updateGraphic ( $forceRefresh:Boolean = false ) :void {
        animationDelay++;
        if ( $forceRefresh )
            animationDelay = _characterSpriteSetting.animationDelay + 1;
        if ( animationDelay > _characterSpriteSetting.animationDelay ) {
            switch ( characterRotation ) {
                case 180:
                    _direction = L;
                    break;
                case 0:
                    _direction = R;
                    break;
                case -120:
                    _direction = LT;
                    break;
                case -45:
                    _direction = RT;
                    break;
                case 135:
                    _direction = LB;
                    break;
                case 60:
                    _direction = RB;
                    break;
            }
            animationDelay = 0;
            characterBitmap.bitmapData.dispose ();
            characterBitmap.bitmapData = new BitmapData ( _characterSpriteSetting.spriteSize.x, _characterSpriteSetting.spriteSize.y, true, 0x60 );
            var copyRectangle:Rectangle = new Rectangle ( 0, 0, _characterSpriteSetting.spriteSize.x, _characterSpriteSetting.spriteSize.y );
            switch ( _direction ) {
                case LT:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationLTFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationLTStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationLTStartPoint.y;
                    break;
                case RT:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationRTFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationRTStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationRTStartPoint.y;
                    break;
                case L:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationLFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationLStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationLStartPoint.y;
                    break;
                case R:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationRFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationRStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationRStartPoint.y;
                    break;
                case LB:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationLBFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationLBStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationLBStartPoint.y;
                    break;
                case RB:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationRBFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationRBStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationRBStartPoint.y;
                    break;
            }
            animationIndex++;
            characterBitmap.bitmapData.copyPixels ( characterSprite, copyRectangle, new Point ( 0, 0 ) );
        }
    }
    
    public function get direction () :String {
        return _direction;
    }
    
    public function set direction ( $direction:String ) :void {
        _direction = $direction;
        switch ( $direction ) {
            case L:
                characterRotation = 180;
                break;
            case R:
                characterRotation = 0;
                break;
            case LT:
                characterRotation = -120;
                break;
            case RT:
                characterRotation = -45;
                break;
            case LB:
                characterRotation = 135;
                break;
            case RB:
                characterRotation = 60;
                break;
        }
        animationDelay = _characterSpriteSetting.animationDelay
        if ( rotateUnit )
            rotation = characterRotation;
    }
    
}

import flash.geom.Point;
import flash.display.BitmapData;
class CharacterSpriteSetting {
    
    public var baseBitmapData:                BitmapData;
    
    public var moveAnimationLTStartPoint:    Point; // Left Top
    public var moveAnimationRTStartPoint:    Point; // Right Top
    public var moveAnimationLStartPoint:    Point; // Left
    public var moveAnimationRStartPoint:    Point; // Right
    public var moveAnimationLBStartPoint:    Point; // Left Bottom
    public var moveAnimationRBStartPoint:    Point; // Right Bottom
    public var spriteSize:                    Point;
    public var spriteOffset:                Point;
    
    public var startDirection:                String;
    
    public var animationDelay:                uint;
    public var moveAnimationLTFrameCount:    uint; // Left Top
    public var moveAnimationRTFrameCount:    uint; // Right Top
    public var moveAnimationLFrameCount:    uint; // Left
    public var moveAnimationRFrameCount:    uint; // Right
    public var moveAnimationLBFrameCount:    uint; // Left Bottom
    public var moveAnimationRBFrameCount:    uint; // Right Bottom
    
    public function CharacterSpriteSetting () :void {
    }
    
}