/**
 * Copyright OKASUKE ( http://wonderfl.net/user/OKASUKE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ehxe
 */

/* OKASUKE 2010/07/29
*  forked from: Human Clock
*  DNACLOCK　Ver1(ヒトゲノムクロック)
*  胃腸じゃないよ！
*  
*  TODO:秒音、時報を追加予定でも音素材がない。。。（´；ω；｀）ｿｻﾞｲｸﾚ
*  TODO:リファクタリング
*/

package  
{
	import flash.display.Stage;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.Graphics;	
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.media.SoundLoaderContext;
    import flash.utils.Timer;	
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;	
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	   	
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.lists.ParallelList;
    import jp.progression.commands.net.LoadBitmapData;
	import jp.progression.commands.net.LoadSound;
    import jp.progression.data.getResourceById;
	
	import org.papervision3d.view.BasicView;	
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Sphere
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.core.math.Number3D;	
	
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.core.proto.MaterialObject3D;
	
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.core.geom.Lines3D;
		
	import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	
	import net.hires.debug.Stats;
		
	[SWF(width="465", height="465", frameRate="30", backgroundColor="0xFFFFFF")]
	public class Jam01 extends BasicView
	{
		private var _t:ITween;
		private var _t2:ITween;
		private var _t3:ITween;
		
		private static const IMG_URL1:Array = ["http://assets.wonderfl.net/images/related_images/2/2e/2ed4/2ed4f104dbc2f7420656e6dd4841a3703a514482",
			"http://assets.wonderfl.net/images/related_images/2/21/21e6/21e6d3e2b28771de360c66f0d88702064bdbf421"];
		private static const SOUND_URL1:Array = ["http://", "http://"];
		
		private var _HourScene3D:DisplayObject3D;
		private var _MinScene3D:DisplayObject3D;
		private var _SecScene3D:DisplayObject3D;
		
		private var _HourNumber3d:Vector.<Plane> = new  Vector.<Plane>(23);
		private var _MinNumber3d:Vector.<Plane> = new Vector.<Plane>();
		private var _SecNumber3d:Vector.<Plane> = new  Vector.<Plane>();		
		private var _secArray:Vector.<BitmapData> = new Vector.<BitmapData>();
		private var _minArray:Vector.<BitmapData> = new Vector.<BitmapData>();
		private var _hourArray:Vector.<BitmapData> = new Vector.<BitmapData>();
		private var _soundArray:Array = [];
		
		private var xx:Number = 0;
		private var yy:Number = 0;
		private var zz:Number = 0;	
		private var _maxId:Number = 0;
			
		private static const P_WIDTH:uint = 50;
		private static const P_HEIGHT:uint = 80;
		
		private var _lineMat:LineMaterial = new LineMaterial(0xD3D3D3, 1);	
		private var _line1:Lines3D = new Lines3D(_lineMat);	
		
		private var _shpSec:Shape;
        private var _shpMin:Shape;
        private var _shpHour:Shape;
        private var _pathCommands:Vector.<int> = Vector.<int>([1,2,2,2,2]);
		private var _sec:uint;
		
		private var _state:Stats;
       	
		//コンストラクタ		
		public function Jam01() 
		{
			stage.quality = StageQuality.LOW;
			stage.scaleMode = StageScaleMode.NO_SCALE
			_HourScene3D = new DisplayObject3D();
			scene.addChild(_HourScene3D);
			_MinScene3D = new DisplayObject3D();
			scene.addChild(_MinScene3D);
			_SecScene3D = new DisplayObject3D();
			scene.addChild(_SecScene3D);
			
			//_state = new Stats();
			//addChildAt(_state, 1);
			var list:SerialList = new SerialList();
            for (var i:int = 0; i < IMG_URL1.length; i++) {
                list.addCommand(new LoadBitmapData(new URLRequest(IMG_URL1[i]), { context: new LoaderContext(true)}));
            } 
			//for (var j:int = 0; j < SOUND_URL1; i++) {
			//	list.addCommand(new LoadSound(new URLRequest(SOUND_URL1[i]), { context: new SoundLoaderContext(true) } ));
			//}
            list.onComplete = function():void {	 init(); }
            list.execute();	
		}	
				
		private function init():void {
			//CreateSound();
			CreateSecText();
			CreateMinText();
			CreateHourText();
			CreateDNA();
				
			startRendering();	
			
			var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();			
		}
		
		private function CreateSound():void {			
			for (var i:int = 0; i < 2; i++) 
				_soundArray[i] = getResourceById(SOUND_URL1[i]).toSound()
		}
		
		private function CreateHourText():void {
			
			for(var i:uint = 0;i <= 23; i++){
                var tf:TextField = new TextField();
                var tff:TextFormat = new TextFormat();
                tff.align = TextFormatAlign.CENTER;   
                tff.size = 24;                       
                tff.color = 0xFFFFFF;                
                tf.defaultTextFormat = tff;
                tf.text = i.toString();
                tf.x = -8;
				tf.y = 4;
				
                	
                var sp:Sprite = new Sprite();
                sp.graphics.beginFill(0x000000, 0.5);               
                sp.graphics.drawRect(0,0,80,40);
                sp.graphics.endFill();
                sp.addChild(tf);
                
                var bitmapdata:BitmapData = new BitmapData(80,40,true,0x00000000);
                bitmapdata.draw(sp);
                
                _hourArray[i] = bitmapdata;        
			}				
			
			//大体の位置に配置しておく
			for (var j:int = 23; j >= 0; j--) {				
				var mt:BitmapMaterial = new BitmapMaterial(_hourArray[j]);
                var pl:Plane = new Plane(mt, 80, 40);
				pl.material.bitmap = _hourArray[j];			
				pl.y = -(j * 50);				
				pl.id = j;					
				_HourNumber3d[j] = pl;				
				_HourScene3D.addChild(_HourNumber3d[j]);				
			}	
			
			_HourScene3D.x = -400;	
			_HourScene3D.y = 600;			
			//HourScene3D.moveBackward(camera.focus * camera.zoom - camera.focus + camera.focus);
			//HourScene3D.z = 10;			
		}
		
	
		//秒テキスト生成
		private function CreateSecText():void {
			
			var bmd:BitmapData = getResourceById(IMG_URL1[0]).toBitmapData();			
			for(var i:uint = 0;i < 60; i++){
                var tf:TextField = new TextField();
                var tff:TextFormat = new TextFormat();
                tff.align = TextFormatAlign.CENTER;   
                tff.size = 35;                       
                tff.color = 0xFFFFFF;                
                tf.defaultTextFormat = tff;
                tf.text = i.toString();
                tf.y += 25;
                
                var sp:Sprite = new Sprite();
				sp.addChild(new Bitmap(bmd));	
				sp.addChild(tf);
				
                var bitmapdata:BitmapData = new BitmapData(100, 100, true, 0x00000000);
                bitmapdata.draw(sp);
                
                _secArray[i] = bitmapdata;                
			}				
		}
		
		//分テキスト生成
		private function CreateMinText():void {			
			
			var bmd:BitmapData = getResourceById(IMG_URL1[1]).toBitmapData();			
			for(var i:uint = 0;i < 60; i++){
                var tf:TextField = new TextField();
                var tff:TextFormat = new TextFormat();
                tff.align = TextFormatAlign.CENTER;
				tff.size = 35; 				                              
                tff.color = 0xFFFFFF;                
                tf.defaultTextFormat = tff;
                tf.text = i.toString();
				tf.y += 25 //仮 センターよりちょい上側が見やすい
                
				var sp:Sprite = new Sprite();
				sp.addChild(new Bitmap(bmd));	
				sp.addChild(tf);
				
                var bitmapdata:BitmapData = new BitmapData(100, 100, true, 0x00000000);
                bitmapdata.draw(sp);			
              
                _minArray[i] = bitmapdata;                
			}			
		}
		
		//DNAみたいなのを描画
		private function CreateDNA():void {
			
			var i:uint = 0;
			var s:uint = 0;
			var ang:uint = 0;			
			for (ang = 0; ang < 1800; ang += 1440 /180)
			{				
				if (i >= 60) i = 0;
				
				//座標値をとりあえず保持
				xx =  Math.sin(ang * Math.PI / 180) * 250;
				zz =  Math.cos(ang * Math.PI / 180) * 30;
				yy =  ang - 900;
				var point3D:Number3D = new Number3D(xx, yy, zz);
				//SecNumber3d[i] = point3D;
				
				//DNA構造を生成					
				var mt:MaterialObject3D = new BitmapMaterial(_secArray[i]);
                var pl:Plane = new Plane(mt, 100, 100);
				pl.material.bitmap = _secArray[i];				
				pl.x = xx;
				pl.y = yy;
				pl.z = zz;
				pl.id = s;
				pl.name = s.toString();
				pl.alpha = 1;
				pl.visible = true;
				
				_SecNumber3d[s] = pl;				
				_SecScene3D.addChild(_SecNumber3d[s]);
			
				xx =  Math.cos(ang * Math.PI / 180) * 250;
				zz =  Math.sin(ang * Math.PI / 180) * 30;
				yy =  ang - 900;
				point3D = new Number3D(xx, yy, zz);
				
				mt = new BitmapMaterial(_minArray[i]);
                pl = new Plane(mt, 100, 100);	
				pl.material.bitmap = _minArray[i];
				pl.x = xx;
				pl.y = yy;
				pl.z = zz;
				pl.id = s
				pl.name = s.toString();
				_maxId = s;
				_MinNumber3d[s] = pl;				
				_MinScene3D.addChild(_MinNumber3d[s]);
				
				if(s%3 == 0)
				_line1.addNewLine(2, _SecNumber3d[s].x, _SecNumber3d[s].y, _SecNumber3d[s].z, xx, yy, zz);
				
				
				s += 1;
				i += 1;								
			}
			
			scene.addChild(_line1);//とりあえずsceneに			
			//trace("maxId" + _maxId);			
		}
		
		private var _onceflag:Boolean = true;
		private var _honceflag:Boolean = true;
		private var _secflg:Boolean = true;
		private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            var sec:int = time.getSeconds();
            if (_sec == sec) return;
            	
            _sec = sec;
			if(_secflg)
            SupdateView(time.getHours(), time.getMinutes(), sec);
			
			if (sec == 0 || _onceflag) 
				MupdateView2(time.getHours(), time.getMinutes(), sec);
				
			if ((sec == 0 && time.getMinutes() == 0 )|| _honceflag)
				HupdateView(time.getHours());
        }
		
		private function HupdateView($hour:int):void {
			
			_honceflag = false;
			var stw:uint = _HourNumber3d.length;			
            var hourtweens:Array = new Array(stw-1);
			var j:uint = 0;
			for (var i:int = stw-1; i >= 0; --i) {					
				if (_HourNumber3d[i].id == $hour) {
					hourtweens[j] = BetweenAS3.tween(_HourNumber3d[i],
							{ scale:2}, 
							null,  1, Cubic.easeOut);
				} else {
					hourtweens[j] = BetweenAS3.tween(_HourNumber3d[i],
							{ scale:1},
							null,  1, Cubic.easeOut);				
				}		
				j += 1;
			}
						
			var htween:ITween = BetweenAS3.parallelTweens(hourtweens);
            
            _t3 = BetweenAS3.serial(htween);            
            _t3.stopOnComplete = true;
			_t3.play();		
		}		
		
		private function MupdateView2($hour:int, $min:int, $sec:int):void {			
		    _onceflag = false;
            var stw:uint = _MinNumber3d.length;			
            var mintweens:Array = new Array(stw);
            for (var i:int = stw-1; i >= 0; --i) {				
				if (i != 0) {
						if (0 == _MinNumber3d[i].id) {
							_MinNumber3d[i].visible = false;
							_MinNumber3d[i].id = _maxId
							mintweens[i] = BetweenAS3.tween(_MinNumber3d[i],
							{ x:_MinNumber3d[i-1].x, y:_MinNumber3d[i-1].y, z:_MinNumber3d[i-1].z}, 
							{ x:_MinNumber3d[i].x, y:_MinNumber3d[i].y, z:_MinNumber3d[i].z},  1, Cubic.easeOut);
						} else {
							_MinNumber3d[i].visible = true;
							_MinNumber3d[i].id = _MinNumber3d[i].id - 1;
							mintweens[i] = BetweenAS3.tween(_MinNumber3d[i],
							{ x:_MinNumber3d[i-1].x, y:_MinNumber3d[i-1].y, z:_MinNumber3d[i-1].z, scale:1}, 
							{ x:_MinNumber3d[i].x, y:_MinNumber3d[i].y, z:_MinNumber3d[i].z},  1, Cubic.easeOut);
						}
						
						if (int(_MinNumber3d[i].name) % 60 == $min) {
						mintweens[i] = BetweenAS3.tween(_MinNumber3d[i],
						{ x:_MinNumber3d[i - 1].x, y:_MinNumber3d[i - 1].y, z:_MinNumber3d[i - 1].z, scale:3}, 
						{ x:_MinNumber3d[i].x, y:_MinNumber3d[i].y, z:_MinNumber3d[i].z, scale:1},  1, Cubic.easeOut);
						}			
						
				} else {
						if (0 == _MinNumber3d[i].id) {
							_MinNumber3d[i].visible = false;
							_MinNumber3d[i].id = _maxId;
						} else {
							_MinNumber3d[i].visible = true;
							_MinNumber3d[i].id = _MinNumber3d[i].id - 1;
						}					
						//MinNumber3d[i].visible = false;						
						mintweens[i] = BetweenAS3.tween(_MinNumber3d[0],
						{ x:_MinNumber3d[stw-1].x, y:_MinNumber3d[stw-1].y, z:_MinNumber3d[stw-1].z, alpha:_MinNumber3d[stw - 1].alpha = 0 }, 
						{ x:_MinNumber3d[0].x, y:_MinNumber3d[0].y, z:_MinNumber3d[0].z, alpha:_MinNumber3d[0].alpha = 0 },  
						1, Cubic.easeOut);					
				}
			}          			
            var ctween:ITween = BetweenAS3.parallelTweens(mintweens);
            
            _t2 = BetweenAS3.serial(ctween);            
            _t2.stopOnComplete = true;
			_t2.play();			
		}
		
		//き、気がついたらすごい冗長なコードに・・・
		private function SupdateView($hour:int, $min:int, $sec:int):void {
			//_secflg = false;    
			$sec = _sec;
            var stw:uint = _SecNumber3d.length;			
            var sectweens:Array = new Array(stw);			
            for (var i:uint = 0; i < stw; i++) {				
				if (i != stw - 1) {						
					if (_maxId == _SecNumber3d[i].id ) {
						
						//_SecNumber3d[i].visible = false;
						_SecNumber3d[i].id = 0						
						
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[i],
						{ x:_SecNumber3d[i + 1].x, y:_SecNumber3d[i + 1].y, z:_SecNumber3d[i + 1].z}, 
						{ x:0, y: -800, z:0 },  1, Cubic.easeInOut);
						
						if (int(_SecNumber3d[i].name) % 60 == $sec) {
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[i],
						{ x:_SecNumber3d[i + 1].x, y:_SecNumber3d[i + 1].y, z:_SecNumber3d[i + 1].z, scale:3}, 
						{ x:0, y:-800, z:0, scale:1},  1, Cubic.easeInOut);
						}					
						
					} else {
						//_SecNumber3d[i].visible = true;
						_SecNumber3d[i].id = _SecNumber3d[i].id + 1;
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[i],
						{ x:_SecNumber3d[i + 1].x, y:_SecNumber3d[i + 1].y, z:_SecNumber3d[i + 1].z, scale:1}, 
						{ x:_SecNumber3d[i].x, y:_SecNumber3d[i].y, z:_SecNumber3d[i].z },  1, Cubic.easeInOut);
						
						if (int(_SecNumber3d[i].name) % 60 == $sec) {
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[i],
						{ x:_SecNumber3d[i + 1].x, y:_SecNumber3d[i + 1].y, z:_SecNumber3d[i + 1].z, scale:3}, 
						{ x:_SecNumber3d[i].x, y:_SecNumber3d[i].y, z:_SecNumber3d[i].z, scale:1},  1, Cubic.easeInOut);
						}						
					}				
									
				} else {
					if (_maxId == _SecNumber3d[i].id) {
						//_SecNumber3d[i].visible =false;
						_SecNumber3d[i].id = 0;					
						
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[stw - 1],
						{ x:_SecNumber3d[0].x, y:_SecNumber3d[0].y, z:_SecNumber3d[0].z}, 
						{ x:0, y:-800, z:0},  
						1, Cubic.easeInOut);	
						
					} else {
						//_SecNumber3d[i].visible = true;
						_SecNumber3d[i].id = _SecNumber3d[i].id + 1;
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[stw - 1],
						{ x:_SecNumber3d[0].x, y:_SecNumber3d[0].y, z:_SecNumber3d[0].z, scale:1 }, 
						{ x:_SecNumber3d[stw - 1].x, y:_SecNumber3d[stw - 1].y, z:_SecNumber3d[stw - 1].z },  
						1, Cubic.easeInOut);
						
						if (int(_SecNumber3d[i].name) % 60 == $sec) {
						sectweens[i] = BetweenAS3.tween(_SecNumber3d[stw - 1],
						{ x:_SecNumber3d[0].x, y:_SecNumber3d[0].y, z:_SecNumber3d[0].z, scale:3}, 
						{ x:_SecNumber3d[stw-1].x, y:_SecNumber3d[stw-1].y, z:_SecNumber3d[stw-1].z, scale:1},  1, Cubic.easeInOut);
						}						
					}								
				}
			}          			
            var ctween:ITween = BetweenAS3.parallelTweens(sectweens);
			       
            _t = BetweenAS3.serial(ctween);    
			//_t.addEventListener(Event.COMPLETE, completeHandler);
            _t.stopOnComplete = true;
			_t.play();			
		}		        
		
		private function completeHandler(e:TweenEvent):void
        {	
			//TODO:こちらで時間をカウントすべきか
            //var time:Date = new Date;
            //var sec:int = time.getSeconds();
            //if (_sec == sec) return;
            //_sec += 1;	
            //_sec = sec;			
            //SupdateView(time.getHours(), time.getMinutes(), sec);			
        }
        
		
		//enterframeでなくonRenderTickで
		override protected function onRenderTick(event:Event=null):void
        {  
			//TODO:カメラ移動とかするか
            super.onRenderTick(event);
        }		
	}	
}