/**
 * Copyright vodka ( http://wonderfl.net/user/vodka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eghc
 */

// forked from clockmaker's [PV3D] SpringCamera3D Demo
package 
{
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;
	import caurina.transitions.Tweener;
	import org.papervision3d.cameras.SpringCamera3D;
	import org.papervision3d.core.clipping.FrustumClipping;
	import org.papervision3d.core.geom.renderables.VectorShapeRenderable;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;

	public class Random extends BasicView
	{
		static public const OBJ_MAX:int = 100;
		private var springCamera:SpringCamera3D;
		
		public function Random():void 
		{
			stage.frameRate = 60;    
			var light:PointLight3D = new PointLight3D();
			var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x000000);
			var list:Vector.<DisplayObject3D> = new Vector.<DisplayObject3D>(OBJ_MAX, true);
			var len:uint = 3000;
			
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				var cube:Cube = new Cube(new MaterialsList({all:material}), 50, 50, 50, 1, 1, 1);
				
				cube.x = len * Math.random() - len / 2;
				cube.y = len * Math.random() - len / 2;
				cube.z = len * Math.random() - len / 2;
				
				cube.rotationX = 360 * Math.random();
				cube.rotationY = 360 * Math.random();
				cube.rotationZ = 360 * Math.random();
				
				list[i] = scene.addChild(cube);
			}
			
			var eye:DisplayObject3D = scene.addChild(new Cube(new MaterialsList( { all:material } ), 50, 50, 50, 1, 1, 1));
			
			springCamera = new SpringCamera3D();
			springCamera.focus = 300;
			springCamera.zoom = 1;
			springCamera.target = eye;
			springCamera.positionOffset = new Number3D(0, 100, 100);
			springCamera.mass = 30;
			springCamera.damping = 30;
			springCamera.stiffness = 1;
			
			var timer:Timer = new Timer(3000);
			timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void
			{
				var target:DisplayObject3D = list[Math.random() * list.length | 0];
				Tweener.addTween(eye,
				{
					x : target.x,
					y : target.y + 100,
					z : target.z,
					rotationX : target.rotationX,
					rotationY : target.rotationY,
					rotationZ : target.rotationZ,
					time : 2.9,
					transition : "easeInOutExpo",
					onUpdate : function():void
					{
						light.copyTransform(eye);
					}
				})
			})
			timer.start();
			
			startRendering()
			
			// BackGround 
			var bgMatrix:Matrix = new Matrix();
			bgMatrix.rotate(90 * Math.PI / 180);
			graphics.beginGradientFill("linear", [0xFFFFFF, 0x001122], [100, 100], [0, 255], bgMatrix);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
		}
		
		/**
		 * Render Method for Spring Camera
		 */
		override protected function onRenderTick(event:Event=null):void
		{
			renderer.renderScene(scene, springCamera, viewport);
		}
	}
}