/**
 * Copyright wwbeyondww1 ( http://wonderfl.net/user/wwbeyondww1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/egGw
 */

// forked from uwi's forked from: star!!!
// forked from neconi's star!!!
//　＃このつぶやき(https://twitter.com/neconi/status/14502827848)から夜中に酒を片手に作り始めたやつを仕上げたのでアップした
//　＃星モチーフでかわいい何かを作りたかったのに、気がついたらなんかサイケになってた・・

package {
    import flash.display.Sprite;
    import flash.geom.Rectangle;
    //import net.hires.debug.Stats;
    
    [SWF(backgroundColor = "#000000", width = "465", height = "465", frameRate = "30")]
    
    public class Main extends Sprite {
        private var starTune:StarTune;
        public function Main() {
            init();
            //addChild(new Stats());
        }
        private function init():void {
            var rect:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
            starTune = new StarTune(rect);
            addChild(starTune);
            starTune.play();
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.filters.BlurFilter;

class StarTune extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var temp:BitmapData;
    private static var scale:Number = 1.1;
    private var matrix:Matrix;
    private static var point:Point = new Point();
    private var blur:BlurFilter;
    private var star:StarMove;
    private var shade:BitmapData;
    public function StarTune(r:Rectangle) {
        rect = r;
        init();
    }
    private function init():void {
        canvas = new BitmapData(rect.width, rect.height, true, 0xFF000000);
        addChild(new Bitmap(canvas));
        temp = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        blur = new BlurFilter(0.5, 0.5, 3);
        matrix = new Matrix();
        matrix.scale(scale, scale);
        var w:int = (rect.width - rect.width*scale) * 0.5;
        var h:int = (rect.height - rect.height * scale) * 0.5;
        matrix.translate(w, h);
        star = new StarMove();
        addChild(star);
        star.x = rect.width*0.5;
        star.y = rect.height*0.5;
        shade = new BitmapData(rect.width, rect.height, true, 0x10000000);
    }
    public function play():void {
        addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
    }
    private function draw(evt:Event):void {
        star.create();
        star.rotation += 2;
        temp.lock();
        temp.draw(this);
        temp.applyFilter(temp, rect, point, blur);
        temp.draw(shade);
        temp.unlock();
        canvas.lock();
        canvas.draw(temp, matrix, null, null, rect, true);
        canvas.unlock();
        if((_t++) % 5 == 0)star.move();
    }
    
    private var _t : uint = 0;
}

import flash.display.Sprite;
import frocessing.color.ColorHSV;

class StarMove extends Sprite {
    private var length:uint;
    private var num:uint;
    private var stars:Array;
    private static var deceleration:Number = 0.2;
    private var id:uint;
    private var color:ColorHSV;

    public function StarMove() {
        init();
        //星の頂点の数を決める。奇数にする。５とか７とか。ここ変えるとイメージが変わるかも。
        //13にした時星の形が変な気がする・・なんでだろう・・？
        num = 5;
    }
    private function init():void {
        stars = new Array();
        color = new ColorHSV(0, 0.3, 1);
        id = 0;
        length = Math.random() * 60 + 40;
    }
    public function create():void {
        id ++;
        var angle:uint = id%360;
        color.h = angle;
        var star:Star = new Star(length, color.value, num);
        star.scale = Math.random() * 2.2;
        addChild(star);
        stars.push(star);
    }
    public function move():void {
        for (var i:uint = 0; i < stars.length; i++) {
            var star:Star = stars[i];
            star.scale *= deceleration;
            if (star.scale < 0.2) {
                stars.splice(i, 1);
                removeChild(star);
                star = null;
            }
        }
    }
}

import flash.display.Shape;
import flash.events.Event;

class Star extends Shape {
    private var length:uint;
    private var color:uint;
    private var num:uint;
    private var rad:Number;
    private var addRad:Number;
    private var targetRad:Number;
    private var _scale:Number = 1;
    public function Star(l:uint = 20, c:uint = 0xFFFFFF, n:uint = 5) {
        length = l;
        color = c;
        num = n;
        rad = 360 / num;
        addRad = (num - 1) / 2 * rad;
        targetRad = 0;
        draw();
    }
    private function draw():void {
        graphics.clear();
        graphics.lineStyle(Math.ceil(Math.random()*5), color);
        graphics.moveTo(length, 0);
        for (var i:uint = 0 ; i < num - 1 ; i++) {
            targetRad += addRad;
            graphics.lineTo(Math.cos(targetRad * Math.PI / 180) * length , Math.sin(targetRad * Math.PI / 180) * length);
        }
        graphics.lineTo(length, 0);
    }    
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
}
