/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/egD7
 */

// forked from miyaoka's JuliaAnimation
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import caurina.transitions.Tweener;

	

	[SWF(width="465", height="465", backgroundColor= 0xffffff, frameRate="30")]
	public class Julia
	extends Sprite
	{
		private var colors:Array;
		private var bd:BitmapData;
		private var transitions:Array = ["easeInOutBack", "easeOutCubic", "easeInCubic" ];
		
		private var rMin:Number;
		private var rMax:Number;
		private var iMin:Number;
		private var iMax:Number;
		public var rVal:Number;
		public var iVal:Number;
		private var count:Number;
		private var level:Number;
		
		public function Julia():void 
		{
			bd = new BitmapData(200, 200);
			var bmp:Bitmap = new Bitmap(bd);
			bmp.smoothing = true;
			addChild(bmp);
			bmp.width = bmp.height = 465;		
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
                        stage.addEventListener(MouseEvent.CLICK, mouseDownHandler);
			//initJulia();
                        genColors();
		}
		private function mouseDownHandler(e:MouseEvent):void 
		{
                        genColors();
                        mouseMoveHandler(null);
		}
                private function genColors():void
                {
			colors = new Array();
			var colorsLen:int = Math.random() * 10 + 2;
			while(0<colorsLen--)
			{
				colors.push(Math.random() * 0xFFFFFF);
			}
        	        count = 50;
        	        level = 10;
                }
		private function initJulia(z0r:Number = NaN, z0i:Number = NaN):void 
		{
                        if (isNaN(z0r) || isNaN(z0i))
                        {
        			rMin = Math.random() * -2 - 0.2;
	    	        	iMin = Math.random() * -2 - 0.2;
	    		        rMax = Math.random() * 2 + 0.2;
        	    		iMax = Math.random() * 2 + 0.2;
        	    		rVal = Math.random() * (rMax - rMin)  + rMin;
            			iVal = Math.random() * (iMax - iMin)  + iMin;
                        } else {
                                rMin = -2;
                                iMin = -2;
                                rMax = 2;
                                iMax = 2;
                                rVal = (z0r * (rMax - rMin)) + rMin;
                                iVal = (z0i * (iMax - iMin)) + iMin;
                        }
			drawJulia(rVal, iVal);
		}

                private function mouseMoveHandler(e:MouseEvent):void
                {

                        initJulia(stage.mouseX / stage.stageWidth, stage.mouseY / stage.stageHeight);

                }
	
		public function drawJulia(a_rval:Number, a_ival:Number):void 
		{
			var r:Number;
			var i:Number;
			var rF:Number;
			var iF:Number;
			var rd:Number = (rMax - rMin) / bd.width;
			var id:Number = (iMax - iMin) / bd.height;
			
			bd.fillRect(new Rectangle(0, 0, bd.width, bd.height), 0xFF000000 );// + Math.random() * 0xFFFFFF);
			for (var x_:int = 0; x_ < bd.width; x_++)
			{
				for (var y_:int = 0; y_ < bd.height; y_++)
				{
					r = rMin + rd * x_;
					i = iMax - id * y_;
					for (var j:int = 0; j < count; j++)
					{
						rF = r * r - i * i + a_rval;
						iF = 2 * r * i  + a_ival;
						if (rF * rF + iF * iF > level) 
						{
							bd.setPixel(x_, y_, colors[j % colors.length] );
							break;
						}
						r = rF;
						i = iF;
					}
				}
			}
		}
        }
}