/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ef1I
 */

// forked from s8t1h12akj's forked from: forked from: forked from: flash on 2016-12-15
// forked from s8t1h12akj's forked from: forked from: flash on 2016-12-15
// forked from s8t1h12akj's forked from: flash on 2016-12-15
// forked from mm8397's flash on 2016-12-15
package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="900", height="450", frameRate="80")]

    public class Main extends Sprite {
        private var detection:DetectPixels;
        private static var accuracy:uint = 2;
        private var threshold:uint = 0xFF808080;
        private var twinkle:TwinkleEffect;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 700, 600);
            graphics.endFill();
            var label1:Label = new Label(700, 200, 80, Label.CENTER);
            addChild(label1);
            label1.x = 12;
            label1.y = 92;
            label1.textColor = 0xFFFFFF;
            label1.alpha = 0.4;
            label1.text = "グランジェMOE山の手";
            var label2:Label = new Label(700, 200, 80, Label.CENTER);
            addChild(label2);
            label2.x = 32;
            label2.y = 192;
            label2.textColor = 0xFFFFFF;
            label2.alpha = 0.4;
            label2.text = "皆さんよろしく！";
            var label3:Label = new Label(700, 200, 80, Label.CENTER);
            addChild(label3);
            label3.x = 32;
            label3.y = 312;
            label3.textColor = 0x999FFF;
            label3.alpha = 4;
            label3.text = "平成２9年";

            var label4:Label = new Label(700, 200, 50, Label.CENTER);
            addChild(label4);
            label4.x = 32;
            label4.y = 390;
            label4.textColor = 0x0AFFFF;
            label4.alpha = 0.4;
            label4.text ="607あき爺";

            //
            detection = new DetectPixels(accuracy);
            var area1:Rectangle = new Rectangle(0, 30, 700, 100);
            var offset1:Object = {x: 0, y: 0};
            detection.search(label1, area1, threshold, offset1);
            var map1:Array = detection.pixels();
            var area2:Rectangle = new Rectangle(0, 50, 700, 200);
            var offset2:Object = {x: 0, y: 100};
            detection.search(label2, area2, threshold, offset2);
            var map2:Array = detection.pixels();
            var area3:Rectangle = new Rectangle(0, 10, 400, 100);
            var offset3:Object = {x: 0, y: 120};
            detection.search(label3, area3, threshold, offset3);
            var map3:Array = detection.pixels();
            //
            var map:Array = map2.concat(map1).concat(map3);
            //
            var rect:Rectangle = new Rectangle(0, 0, 700, 500);
            twinkle = new TwinkleEffect(rect, map);
            addChild(twinkle);
            twinkle.x = 32;
            twinkle.y = 92;
            twinkle.setup(100, 20);
        }
        
    }

}


//////////////////////////////////////////////////
// TwinkleEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class TwinkleEffect extends Sprite {
    private var rect:Rectangle;
    private var map:Array;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private static var radius:uint = 10;
    private var interval:uint = 100;
    private var life:uint = 10;
    private var particles:Array;
    private static var white:uint = 0xFFFFFF;
    private static var green:uint = 0x00CC00;
    private static var red:uint = 0xFF0033;
    private static var gold:uint = 0xFFCC33;
    private static var sliver:uint = 0xCCCCCC;
    private static var colors:Array = [white, white, green, red, gold, gold, sliver, sliver];
    private var units:Array = [30, 30, 45, 45, 45, 60];
    private static var radian:Number = Math.PI/180;
    private var timer:Timer;
    private static var policyPath:String = "http://kouetu.sakura.ne.jp/crossdomain.xml";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "http://kouetu.sakura.ne.jp/mp3_mujic/Christmas_Song.mp3";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;

    public function TwinkleEffect(r:Rectangle, m:Array) {
        rect = r;
        map = m;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        particles = new Array();
        //
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    public function setup(i:uint = 100, l:uint = 10):void {
        interval = i;
        life = l;
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        start();
    }
    private function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, tick, false, 0, true);
        timer.start();
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function stop():void {
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function tick(evt:TimerEvent):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        for (var c:uint = 0; c < 2; c++) {
            for (var t:uint = 0; t < channels; t++) {
                var p:Number = byteArray.readFloat();
                if (p > 0) create(p);
            }
        }
    }
    private function create(p:Number):void {
        //var id:uint = uint(Math.random()*map.length);
        var id:uint = uint(map.length*p)%map.length;
        var px:Number = map[id].x;
        var py:Number = map[id].y;
        plot(px, py);
    }
    private function plot(px:Number, py:Number):void {
        var matrix:Matrix = new Matrix();
        matrix.translate(px - radius, py - radius);
        var color:uint = colors[uint(Math.random()*colors.length)];
        var particle:TwinkleParticle = new TwinkleParticle();
        particle.x = px;
        particle.y = py;
        particle.life = (Math.random()*0.5 + 0.5)*life;
        particle.matrix = matrix;
        particle.color = color;
        particle.unit = units[uint(Math.random()*units.length)];
        particles.push(particle);
        bitmapData.lock();
        draw(px, py, 0xFFFFFF, particle.life/life, particle.unit);
        bitmapData.unlock();
    }
    private function update(evt:Event):void {
        bitmapData.lock();
        bitmapData.fillRect(rect, 0x00000000);
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:TwinkleParticle = particles[n];
            draw(particle.x, particle.y, particle.color, particle.life/life, particle.unit);
            particle.life --;
            if (particle.life < 0) {
                particles.splice(n, 1);
                particle = null;
            }
        }
        bitmapData.unlock();
    }
    private function draw(px:uint, py:uint, color:uint, percent:Number, unit:uint):void {
        var length:uint = uint(radius*percent);
        var argb:uint = 0xFF << 24 | color;
        for (var n:uint = 0; n < length; n++) {
            for (var a:uint = 0; a < 360; a+=unit) {
                var dx:Number = px + n*Math.cos(a*radian);
                var dy:Number = py + n*Math.sin(a*radian);
                bitmapData.setPixel32(dx, dy, argb);
            }
        }
    }

}


//////////////////////////////////////////////////
// TwinkleParticleクラス
//////////////////////////////////////////////////

import flash.geom.Matrix;

class TwinkleParticle {
    public var x:uint;
    public var y:uint;
    public var life:int;
    public var matrix:Matrix;
    public var color:uint;
    public var unit:uint;

    public function TwinkleParticle() {
    }

}


//////////////////////////////////////////////////
//    DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;
    private var offset:Object = {x: 0, y: 0};

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF, o:Object = null):void {
        bd = t;
        rect = r;
        threshold = th;
        if (o) offset = o;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var y:uint = 0; y < h; y++) {
            for (var x:uint = 0; x < w; x++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x + offset.x;
                    var py:int = y*accuracy + rect.y + offset.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.LEFT;
    public static const RIGHT:String = TextFormatAlign.LEFT;

    public function Label(w:uint, h:uint, s:uint = 1, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
