/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eerj
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.geom.Vector3D;

    /**
     * ...
     * @author moriya
     */
    public class Main extends Sprite
    {
        private const STW:uint = stage.stageWidth,STH:uint = stage.stageHeight;
        //[Embed(source = "../lib/nozokineko_s.jpg")]private var Emb:Class;
        //private var xNum:int=5;
        //private var yNum:int=5;
        //private var rotationFLG:Boolean=false;
        private var img:Bitmap;
        private var spList:Array=[];
        private var _imgLoader:Loader;
        private var _imgLoaderInfo:LoaderInfo;
        private var container:Sprite;

        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point

            var url:String = "http://farm1.static.flickr.com/166/426763088_25ec0c2e25.jpg";
            var urlReq:URLRequest = new URLRequest(url);
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            _imgLoader = new Loader();
            _imgLoaderInfo = _imgLoader.contentLoaderInfo;
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageloaded);
            _imgLoader.load(urlReq, context);

            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, STW, STH);
            graphics.endFill();

        }

        private function onImageloaded(event:Event):void
        {
            transform.perspectiveProjection.projectionCenter = new Point(STW * .5, STH * .5); //vp

            container = new Sprite();
            var img:Bitmap
            var imgBmd:BitmapData= new BitmapData(_imgLoader.width*0.5, _imgLoader.height*0.5);

            var _matrix:Matrix = new Matrix();
            _matrix.scale(0.5, 0.5);
            imgBmd.draw(_imgLoader,_matrix);
            img = new Bitmap(imgBmd);

            //addChild(img);
            var cnt:int = 0;
            for (var degree:int = 0; degree < 360; degree += 360 / 5)
            {
                var imgSprite:ImgSprite = new ImgSprite(cnt++, img);
                imgSprite.degree = degree;
                imgSprite.move();
                container.addChild(imgSprite);
                spList.push(imgSprite);
                imgSprite.addEventListener(MouseEvent.ROLL_OVER, fnOver);
                imgSprite.addEventListener(MouseEvent.ROLL_OUT, fnOut);
            }

            container.z = 0;
            addChild(container);
            addEventListener(Event.ENTER_FRAME, fnUpdate);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        private function onKeyDown(event:KeyboardEvent):void
        {
            trace(event)
            if (event.keyCode == 38) container.z -= 10;//↑zoomIn
            if (event.keyCode == 40) container.z += 10;//↓zoomOut
            
            if (event.keyCode == 37) container.transform.matrix3D.prependRotation(1, Vector3D.Z_AXIS);//←
            if (event.keyCode == 39) container.transform.matrix3D.prependRotation( -1, Vector3D.Z_AXIS);//→
            
            if (event.keyCode == 87) container.transform.matrix3D.prependRotation(1, Vector3D.X_AXIS);//w
            if (event.keyCode == 83) container.transform.matrix3D.prependRotation(-1, Vector3D.X_AXIS);//s
            
            if (event.keyCode == 65) container.transform.matrix3D.prependRotation( 1, Vector3D.Y_AXIS);//a
            if (event.keyCode == 68) container.transform.matrix3D.prependRotation( -1, Vector3D.Y_AXIS);//d
            
            if (event.keyCode == 67)container.z= container.rotationX = container.rotationY = container.rotationZ = 0;//clear
            
        }

        private function fnOver(mouseEvent:MouseEvent):void
        {
            mouseEvent.currentTarget.rotateFlg = true;
        }

        private function fnOut(mouseEvent:MouseEvent):void
        {
            mouseEvent.currentTarget.rotateFlg = false;
        }

        private function fnUpdate(event:Event):void
        {
            for (var i:int = 0; i < spList.length;i++ )spList[i].move();
            spList.sortOn("z", Array.NUMERIC | Array.DESCENDING);//手前と奥を判別して再配置
            for (i = 0; i < spList.length; i++) container.addChild(spList[i]);
            for (i = 0; i < spList.length; i++)if (spList[i].rotateFlg) spList[i].rotate();

            //spList[i].transform.matrix3D.prependRotation(1, Vector3D.Y_AXIS)
        }

    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.geom.Vector3D;

class ImgSprite extends Sprite
{
    public var cf:Sprite;
    public var rect:Sprite;
    public var degree:Number;
    public var rotateFlg:Boolean=false;

    public function ImgSprite(num:int,img:Bitmap):void
    {
        rect = new Sprite();
        var _img:Bitmap = new Bitmap(img.bitmapData.clone());
        rect.addChild(_img);
        addChild(rect);
        cf = new Sprite();
        var cfbm:Bitmap =new Bitmap(img.bitmapData.clone());
        cf.addChild(cfbm);
        addChild(cf);
        _img.x = cfbm.x = -img.width * 0.5;

        rect.z = cf.z = 0;
        cf.alpha = 0;

        this.y = 100;
        this.z=0;
    }

    public function move():void
    {

        this.x = 200 + Math.cos(degree * Math.PI / 180) * 200;
        this.z = 200 + Math.sin(degree * Math.PI / 180) * 400;
        degree++;
    }

    public function rotate():void
    {
        rect.transform.matrix3D.prependRotation(10, Vector3D.Y_AXIS)
    }

}

/*
*
*
*
*
*
*
* */

