/**
 * Copyright signedvoid ( http://wonderfl.net/user/signedvoid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eeVY
 */

// forked from bradsedito's forked from: flash on 2010-11-24
// forked from sliz's flash on 2010-11-24
package {
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;

    /**
     * 对http://wonderfl.net/c/bPbw做了点改动
     * @author sliz http://game-develop.net/blog/
     */
    public class FlashTest extends Sprite {
        public function FlashTest(){
            w = 256;
            vectormap = new BitmapData(w, w);

            bmpdata = new BitmapData(w, w, false, 0);
            var bitmap:Bitmap = new Bitmap(bmpdata);
            bitmap.smoothing = true;
            bitmap.scaleX = bitmap.scaleY = stage.stageWidth / w;
            bitmap.filters = [new BlurFilter(5, 5,  1)];
            addChild(bitmap);

            stage.addEventListener(Event.ENTER_FRAME, reset);

        }

        private var vectormap:BitmapData;
        private var bmpdata:BitmapData;
        private var oy:int = 0;
        private var w:int;

        private function reset(e:Event):void {
            vectormap.perlinNoise(w * .5, w * .5, 3, 1, false, true, 7, false, [new Point(0, oy++)]);

            bmpdata.fillRect(bmpdata.rect, 0);
            var divFFw:Number = 1.0 / 0xFF * w;
            var wHalf:Number = w * 0.5;

            for (var y:int = 0; y < vectormap.height; y++){
                for (var x:int = 0; x < vectormap.width; x++){
                    var px:uint = vectormap.getPixel(x, y);
                    var r:int = px >> 16 & 0xFF;
                    var g:int = px >> 8 & 0xFF;
                    var b:int = px & 0xFF;

                    //var tx:int = x + (g / 0xFF - .5) * w;
                    //var ty:int = y + (b / 0xFF - .5) * w;
                    var tx:int = x + g * divFFw - wHalf;
                    var ty:int = y + b * divFFw - wHalf;

                    if (ty < 0 || ty >= bmpdata.height || tx < 0 || tx >= bmpdata.width)
                        continue;
                    var col:uint = bmpdata.getPixel(tx, ty);
                    col += 0x010101 * (int)(r * .2);
                    if (col > 0xFFFFFF)
                        col = 0xFFFFFF;
                    bmpdata.setPixel(tx, ty, col);
                }
            }

        }
    }
}