/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ee6o
 */

// forked from hankuro's flash on 2009-12-29
package 
{ 
    import flash.display.Shader; 
    import flash.display.Sprite; 
    import flash.events.Event; 
	import flash.events.MouseEvent;
    import flash.net.URLLoader; 
    import flash.net.URLLoaderDataFormat; 
    import flash.net.URLRequest;
    import flash.system.LoaderContext; 
	[SWF(width = "500", height = "500", backgroundColor = "0" )] 
    /**
	 *  三角形の頂点の色で補完できないか検索してたら、「Pixel Bender」を発見。
	 *  早々に
	 *  http://help.adobe.com/ja_JP/ActionScript/3.0_ProgrammingAS3/WSFDA04BAE-F6BC-43d9-BD9C-08D39CA22086.html
	 *  にあるサンプルをコピーして試験を試みるが、実行時にエラーになる。
	 * 　半日かけてやっと原因を見つけた。
	 * 
	 * 　クラスThreePointGradientに以下のミスがある。 
	 * 　1) 50 '.'が','になっている。(topMiddile,y > topMiddile.y)　->　実行時にエラー
	 *  2)　57 '('がない　->　コンパイルエラー
	 *  3) 65 ')'がない　->　コンパイルエラー
	 * 
	 * 　カーネルには問題はなかった。 
	 * 　でも実行結果が、このサイトに示される結果とはならなかった。
	 * 　だから、
	 * 　http://www.petrileskinen.fi/Actionscript/ThreePointGradient/ThreePointGradient.html
	 *  を参考に作り直してみた。（カラー取得も同じにしたかったが、このカラーパレットがどこにあるのか分からなかったで自作した）
	 * 　
	 * 　「ひとりごと」
	 * 　この「Pixel Bender」はOPENGL2.0に対応するﾋﾞﾃﾞｵカードが使えるととのことだったので、今日2,970円でビデオカードを買ってきた。
	 * 　これから、ホコリをかぶったwindows2000のデスクトップに装着して試験をしてみるつもりだ。
	 * 　ちなみ、このプログラムで使用しているカーネルは、ﾋﾞﾃﾞｵカード不使用にしているので、動作が遅い。（あしからず）
	 * 
	 */ 
    public class ColorFilterExample extends Sprite 
    { 
        private const DELTA_OFFSET:Number = Math.PI * 0.5; 
        private var loader:URLLoader; 
        private var shader:Shader; 
        private var texture:Sprite; 
        private var delta:Number = 0;
		private var top:Sprite = new Sprite();
		private var lft:Sprite = new Sprite();
		private var rit:Sprite = new Sprite();
		private var top_color:uint;
		private var lft_color:uint;
		private var rit_color:uint;
		private var top_r:SimpleSlider = new SimpleSlider(0, 255, 255);
		private var top_g:SimpleSlider = new SimpleSlider(0, 255, 0);
		private var top_b:SimpleSlider = new SimpleSlider(0, 255, 0);
		private var lft_r:SimpleSlider = new SimpleSlider(0, 255, 0);
		private var lft_g:SimpleSlider = new SimpleSlider(0, 255, 255);
		private var lft_b:SimpleSlider = new SimpleSlider(0, 255, 0);
		private var rit_r:SimpleSlider = new SimpleSlider(0, 255, 0);
		private var rit_g:SimpleSlider = new SimpleSlider(0, 255, 0);
		private var rit_b:SimpleSlider = new SimpleSlider(0, 255, 255);
		
         
        public function ColorFilterExample() 
        { 
            init(); 
        } 
         
        private function init():void 
        {
			loader = new URLLoader();
			var context : LoaderContext = new LoaderContext(true);
			loader.dataFormat = URLLoaderDataFormat.BINARY;		   
			loader.addEventListener(Event.COMPLETE, onLoadComplete); 
			loader.load(new URLRequest("http://hankuro.sakura.ne.jp/ThreePointGradient.pbj"));
		}
		public function onLoadComplete(event:Event):void
		{
            shader = new Shader(loader.data); 
            texture = new Sprite(); 
            addChild(texture);
            shader.data.point1.value = [250,200];
            shader.data.point2.value = [150,400];
            shader.data.point3.value = [350,400];
			shader.data.color1.value = [1, 0, 0, 1];
			shader.data.color2.value = [0, 1, 0, 1];
			shader.data.color3.value = [0, 0, 1, 1];
            renderShader();
			top_r.y = top_g.y = top_b.y = 80;
			top_r.x = 220;
			top_g.x = 240;
			top_b.x = 260;
			lft_r.y = lft_g.y = lft_b.y = 320;
			lft_r.x = 90;
			lft_g.x = 110;
			lft_b.x = 130;
			rit_r.y = rit_g.y = rit_b.y = 320;
			rit_r.x = 360;
			rit_g.x = 380;
			rit_b.x = 400;
			addChild(top_r);
			addChild(top_g);
			addChild(top_b);
			addChild(lft_r);
			addChild(lft_g);
			addChild(lft_b);
			addChild(rit_r);
			addChild(rit_g);
			addChild(rit_b);
			top.x = 200;
			top.y = 80;
			top.buttonMode = true;
			addChild(top);
			top.addEventListener(MouseEvent.CLICK, onClick);
			lft.x = 70;
			lft.y = 320;
			lft.buttonMode = true;
			addChild(lft);
			lft.addEventListener(MouseEvent.CLICK, onClick);
			rit.x = 340;
			rit.y = 320; 
			rit.buttonMode = true;
			addChild(rit);
			top.graphics.beginFill(0xFF0000);
			top.graphics.drawRect(0, 0, 15, 15);
			top.graphics.endFill();
			lft.graphics.beginFill(0x00FF00);
			lft.graphics.drawRect(0, 0, 15, 15);
			lft.graphics.endFill();
			rit.graphics.beginFill(0x0000FF);
			rit.graphics.drawRect(0, 0, 15, 15);
			rit.graphics.endFill();
			rit.addEventListener(MouseEvent.CLICK, onClick);
			top_r.addEventListener(Event.CHANGE, onChange);
			top_g.addEventListener(Event.CHANGE, onChange);
			top_b.addEventListener(Event.CHANGE, onChange);
			lft_r.addEventListener(Event.CHANGE, onChange);
			lft_g.addEventListener(Event.CHANGE, onChange);
			lft_b.addEventListener(Event.CHANGE, onChange);
			rit_r.addEventListener(Event.CHANGE, onChange);
			rit_g.addEventListener(Event.CHANGE, onChange);
			rit_b.addEventListener(Event.CHANGE, onChange);
        }
		private function onChange(event:Event):void {
			top_color = top_r.value << 16 | top_g.value << 8 | top_b.value;
			top.graphics.beginFill(top_color);
			top.graphics.drawRect(0, 0, 15, 15);
			top.graphics.endFill();
			lft_color = lft_r.value << 16 | lft_g.value << 8 | lft_b.value;
			lft.graphics.beginFill(lft_color);
			lft.graphics.drawRect(0, 0, 15, 15);
			lft.graphics.endFill();
			rit_color = rit_r.value << 16 | rit_g.value << 8 | rit_b.value;
			rit.graphics.beginFill(rit_color);
			rit.graphics.drawRect(0, 0, 15, 15);
			rit.graphics.endFill();
		}
        private function onClick(event:MouseEvent):void {
			shader.data.color1.value = [top_r.value/0xFF, top_g.value/0xFF, top_b.value/0xFF, 1];
			shader.data.color2.value = [lft_r.value/0xFF, lft_g.value/0xFF, lft_b.value/0xFF, 1];
			shader.data.color3.value = [rit_r.value/0xFF, rit_g.value/0xFF, rit_b.value/0xFF, 1];
			renderShader();
		}
        private function renderShader():void 
        { 
            texture:graphics.clear(); 
			texture.graphics.beginShaderFill(shader);
            texture.graphics.moveTo(250, 200);
			texture.graphics.lineTo(150, 400);
			texture.graphics.lineTo(350, 400);
            texture.graphics.endFill(); 
        } 
    } 
}
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.events.Event;
	
	class SimpleSlider extends Sprite
	{
		private var _width:Number = 16;
		private var _height:Number = 100;
		private var _value:Number;
		private var _max:Number = 100;
		private var _min:Number = 0;
		private var _handle:Sprite;
		private var _back:Sprite;
		private var _backWidth:Number = 4;
		private var _handleHeight:Number = 6;
		private var _backColor:uint = 0xcccccc;
		private var _backBorderColor:uint = 0x999999;
		private var _handleColor:uint = 0xeeeeee;
		private var _handleBorderColor:uint = 0xcccccc;
		private var _handleRadius:Number = 2;
		private var _backRadius:Number = 2;
		
		public function SimpleSlider(min:Number=0, max:Number=100, value:Number=100)
		{
			_min = min;
			_max = max;
			_value = Math.min(Math.max(value, min), max)
			init();
		}
		
		private function init():void
		{
			_back = new Sprite();
			addChild(_back);
			
			_handle = new Sprite();
			addChild(_handle);
			_handle.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			
			draw();
			updatePosition();
		}
		
		private function draw():void
		{
			drawBack();
			drawHandle();
		}
		
		private function drawBack():void
		{
			_back.graphics.clear();
			_back.graphics.beginFill(_backColor);
			_back.graphics.lineStyle(0, _backBorderColor);
			_back.graphics.drawRoundRect(0, 0, _backWidth, _height, _backRadius, _backRadius);
			_back.graphics.endFill();
			_back.x = _width / 2 - _backWidth / 2;
		}
		
		private function drawHandle():void
		{
			_handle.graphics.clear();
			_handle.graphics.beginFill(_handleColor);
			_handle.graphics.lineStyle(0, _handleBorderColor);
			_handle.graphics.drawRoundRect(0, 0, _width, _handleHeight, _handleRadius, _handleRadius);
			_handle.graphics.endFill();
		}
	
		private function updatePosition():void
		{
			var handleRange:Number = _height - _handleHeight;
			var valueRange:Number = _max - _min;
			_handle.y = handleRange - (_value - _min) / valueRange * handleRange;
		}
		
		private function updateValue():void
		{
			var handleRange:Number = _height - _handleHeight;
			var valueRange:Number = _max - _min;
			_value = (handleRange - _handle.y) / handleRange * valueRange + _min;
			dispatchEvent(new Event(Event.CHANGE));
		}
		
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			_handle.stopDrag();
		}
		
		private function onMouseDown(event:MouseEvent):void
		{
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			_handle.startDrag(false, new Rectangle(0, 0, 0, _height - _handleHeight));
		}
		
		private function onMouseMove(event:MouseEvent):void
		{
			updateValue();
		}


		
		public function invalidate():void
		{
			draw();
		}
		
		public function move(x:Number, y:Number):void
		{
			this.x = x;
			this.y = y;
		}
		
		public function setSize(w:Number, h:Number):void
		{
			_width = w;
			_height = h;
			draw();
		}
		
		
		
		
		
		
		public function set backBorderColor(n:uint):void
		{
			_backBorderColor = n;
			draw();
		}
		public function get backBorderColor():uint
		{
			return _backBorderColor;
		}
		
		public function set backColor(n:uint):void
		{
			_backColor = n;
			draw();
		}
		public function get backColor():uint
		{
			return _backColor;
		}
		
		public function set backRadius(n:Number):void
		{
			_backRadius = n;
		}
		public function get backRadius():Number
		{
			return _backRadius;
		}
		
		public function set backWidth(n:Number):void
		{
			_backWidth = n;
			draw();
		}
		public function get backWidth():Number
		{
			return _backWidth;
		}
		
		public function set handleBorderColor(n:uint):void
		{
			_handleBorderColor = n;
			draw();
		}
		public function get handleBorderColor():uint
		{
			return _handleBorderColor;
		}
		
		public function set handleColor(n:uint):void
		{
			_handleColor = n;
			draw();
		}
		public function get handleColor():uint
		{
			return _handleColor;
		}
		
		public function set handleRadius(n:Number):void
		{
			_handleRadius = n;
			draw();
		}
		public function get handleRadius():Number
		{
			return _handleRadius;
		}
		
		public function set handleHeight(n:Number):void
		{
			_handleHeight = n;
			draw();
			updatePosition();
		}
		public function get handleHeight():Number
		{
			return _handleHeight;
		}
		
		override public function set height(n:Number):void
		{
			_height = n;
			draw();
		}
		override public function get height():Number
		{
			return _height;
		}
		
		public function set max(n:Number):void
		{
			_max = n;
			updatePosition();
		}
		public function get max():Number
		{
			return _max;
		}
		
		public function set min(n:Number):void
		{
			_min = n;
			updatePosition();
		}
		public function get min():Number
		{
			return _min;
		}
		
		public function set value(n:Number):void
		{
			_value = n;
			_value = Math.min(_max, Math.max(_value, _min));
			updatePosition();
		}
		public function get value():Number
		{
			return _value;
		}
		
		override public function set width(n:Number):void
		{
			_width = n;
			draw();
		}
		override public function get width():Number
		{
			return _width;
		}
	}