/**
 * Copyright SIHO_o ( http://wonderfl.net/user/SIHO_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/edvz
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.net.NetGroup;
    import flash.net.GroupSpecifier;
    import com.bit101.components.*;
    /**
     * RTMFPのお勉強会のサンプル。mxmlベースのやつをAS3で書き直しました。 #RTMFP_LAB
     * @author SIHO
     */
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    public class Main extends Sprite 
    {
            private const SERVER:String = "rtmfp:";
            
            private var nc:NetConnection;
            private var netGroup:NetGroup;
            
            [Bindable]
            private var user:String;
            
            [Bindable]
            private var connected:Boolean = false;
            
            var SendBtn:PushButton;
            var txtUser:InputText;
            var txtMessage:InputText;
            var txtHistory:TextArea;
            
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            Style.embedFonts = false;
            Style.fontName = "_typewriter";
            Style.fontSize = 12;
            SendBtn = new PushButton(this, 359, 431, "Send Message", sendMessage);
            txtHistory = new TextArea(this, 10, 15);
            txtHistory.width = 465-20;
            txtHistory.height = 465-50;
            txtUser = new InputText(this, 10, 431);
            txtUser.width = 70;
            txtUser.height = 20;
            txtUser.text ="username"
            txtMessage = new InputText(this, 82, 431);
            txtMessage.width = 276;
            txtMessage.height = 20;
            
            connect();
        }
        
        private function connect():void{
                nc = new NetConnection();
                nc.addEventListener(NetStatusEvent.NET_STATUS,netStatus);
                //nc.connect(SERVER+DEVKEY);    
                nc.connect(SERVER);    
            }
            
            private function netStatus(event:NetStatusEvent):void{
                write(event.info.code);
                
                switch(event.info.code){
                    case "NetConnection.Connect.Success":
                        setupGroup()
                        break;
                    
                    case "NetGroup.Connect.Success":
                        connected = true;
                        
                        break;
                    
                    case "NetGroup.Posting.Notify":
                        receiveMessage(event.info.message);
                        break;
                }
            }
            
            private function setupGroup():void{
                var groupspec:GroupSpecifier = new GroupSpecifier("myGroup/g1");
                groupspec.ipMulticastMemberUpdatesEnabled = true;
                groupspec.multicastEnabled = true;
                groupspec.addIPMulticastAddress("225.225.0.1:30303");
                groupspec.serverChannelEnabled = true;
                groupspec.postingEnabled = true;
                groupspec.routingEnabled = true;
                
                
                trace("Groupspec: "+groupspec.groupspecWithAuthorizations());
                
                netGroup = new NetGroup(nc,groupspec.groupspecWithAuthorizations());
                netGroup.addEventListener(NetStatusEvent.NET_STATUS,netStatus);
            
                user = "user"+Math.round(Math.random()*10000);
            }
            
            private var sequence:uint = 0;
            
            private function sendMessage(e:MouseEvent):void{
                
                var message:Object = new Object();
                message.sender = netGroup.convertPeerIDToGroupAddress(nc.nearID);
                //message.sequence = sequence++;
                message.user = txtUser.text;
                message.text = txtMessage.text;
                
                netGroup.post(message);
                receiveMessage(message);
                
                txtMessage.text = "";
            }
            
            private function receiveMessage(message:Object):void{
                write(message.user+": "+message.text);
            }
            
            private function write(txt:String):void{
                txtHistory.text += txt+"\n";
            }
    }
    
}