/**
 * Copyright yuewah ( http://wonderfl.net/user/yuewah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/edgY
 */

// forked from aobyrne's forked from: Box2d wheeled car
package {
    import flash.display.Sprite;
    import Box2D.Collision.*;// bounding box of our world
    import Box2D.Common.Math.*;// for vector(define gravity)
    import Box2D.Dynamics.*;// define bodies and define world
    import Box2D.Dynamics.Joints.*;
    import Box2D.Collision.Shapes.*;// define our shapes
    import flash.display.*;// sprite class
    import flash.events.*;
    import flash.ui.Keyboard;
    import flash.text.TextField;
 
    public class Box2DCar extends MovieClip {
        public var body:b2Body;
        public var leftWheel:b2Body;
        public var rightWheel:b2Body;
        public var leftRearWheel:b2Body;
        public var rightRearWheel:b2Body;
        public const MAX_STEER_ANGLE:Number = 3.14 / 6;
        public const STEER_SPEED:Number = 1.5;
        public const SIDEWAYS_FRICTION_FORCE:Number = 10;
        public const HORSEPOWERS:Number = 40;
        public const CAR_STARTING_POS:b2Vec2 = new b2Vec2(10,10);
        public var engineSpeed:Number = -50;
        public var steeringAngle:Number = 3.14 / 6;
        public var myWorld:b2World;
        public var leftJoint:b2RevoluteJoint;
        public var rightJoint:b2RevoluteJoint;
        
        public function Box2DCar() {
            // write as3 code here..
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            const leftRearWheelPosition:b2Vec2 = new b2Vec2(-1.5,1.90);
            const rightRearWheelPosition:b2Vec2 = new b2Vec2(1.5,1.9);
            const leftFrontWheelPosition:b2Vec2 = new b2Vec2(-1.5,-1.9);
            const rightFrontWheelPosition:b2Vec2 = new b2Vec2(1.5,-1.9);
            
            
            
            
            var worldBox:b2AABB = new b2AABB();
            worldBox.lowerBound.Set(-100,-100);
            worldBox.upperBound.Set(100,100);
             
            myWorld = new b2World(worldBox, new b2Vec2(0, 0) , true);
            myWorld.m_gravity
            trace( "myWorld.m_gravity : " + myWorld.m_gravity.x,', ',myWorld.m_gravity.y );
             
            //Create some static stuff
            var staticDef:b2BodyDef = new b2BodyDef();
            staticDef.position.Set(5,20);
            var staticBox:b2PolygonDef = new b2PolygonDef();
            staticBox.SetAsBox(5,5);
            myWorld.CreateBody(staticDef).CreateShape(staticBox);
            staticDef.position.x = 25;
            myWorld.CreateBody(staticDef).CreateShape(staticBox);
            staticDef.position.Set(15, 24);
            myWorld.CreateBody(staticDef).CreateShape(staticBox);
             
             
            // define our body
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.linearDamping = 1;
            bodyDef.angularDamping = 1;
            bodyDef.position = CAR_STARTING_POS.Copy();
            bodyDef.allowSleep = false;
             
            body = myWorld.CreateBody(bodyDef);
            body.SetMassFromShapes();
             
            var leftWheelDef:b2BodyDef = new b2BodyDef();
            leftWheelDef.position = CAR_STARTING_POS.Copy();
            leftWheelDef.position.Add(leftFrontWheelPosition);
            //var leftWheel:b2Body = myWorld.CreateBody(leftWheelDef);
            leftWheel = myWorld.CreateBody(leftWheelDef);
             
            var rightWheelDef:b2BodyDef = new b2BodyDef();
            rightWheelDef.position = CAR_STARTING_POS.Copy();
            rightWheelDef.position.Add(rightFrontWheelPosition);
            //var rightWheel:b2Body = myWorld.CreateBody(rightWheelDef);
            rightWheel = myWorld.CreateBody(rightWheelDef);
             
            var leftRearWheelDef:b2BodyDef = new b2BodyDef();
            leftRearWheelDef.position = CAR_STARTING_POS.Copy();
            leftRearWheelDef.position.Add(leftRearWheelPosition);
            //var leftRearWheel:b2Body = myWorld.CreateBody(leftRearWheelDef);
            leftRearWheel = myWorld.CreateBody(leftRearWheelDef);
             
            var rightRearWheelDef:b2BodyDef = new b2BodyDef();
            rightRearWheelDef.position = CAR_STARTING_POS.Copy();
            rightRearWheelDef.position.Add(rightRearWheelPosition);
            //var rightRearWheel:b2Body = myWorld.CreateBody(rightRearWheelDef);
            rightRearWheel = myWorld.CreateBody(rightRearWheelDef);
             
            // define our shapes
            var boxDef:b2PolygonDef = new b2PolygonDef();
            boxDef.SetAsBox(1.5,2.5);
            boxDef.density = 1;
            body.CreateShape(boxDef);
             
            //Left Wheel shape
            var leftWheelShapeDef:b2PolygonDef = new b2PolygonDef();
            leftWheelShapeDef.SetAsBox(0.2,0.5);
            leftWheelShapeDef.density = 1;
            leftWheel.CreateShape(leftWheelShapeDef);
             
            //Right Wheel shape
            var rightWheelShapeDef:b2PolygonDef = new b2PolygonDef();
            rightWheelShapeDef.SetAsBox(0.2,0.5);
            rightWheelShapeDef.density = 1;
            rightWheel.CreateShape(rightWheelShapeDef);
             
            //Left Wheel shape
            var leftRearWheelShapeDef:b2PolygonDef = new b2PolygonDef();
            leftRearWheelShapeDef.SetAsBox(0.2,0.5);
            leftRearWheelShapeDef.density = 1;
            leftRearWheel.CreateShape(leftRearWheelShapeDef);
             
            //Right Wheel shape
            var rightRearWheelShapeDef:b2PolygonDef = new b2PolygonDef();
            rightRearWheelShapeDef.SetAsBox(0.2,0.5);
            rightRearWheelShapeDef.density = 1;
            rightRearWheel.CreateShape(rightRearWheelShapeDef);
             
            body.SetMassFromShapes();
            leftWheel.SetMassFromShapes();
            rightWheel.SetMassFromShapes();
            leftRearWheel.SetMassFromShapes();
            rightRearWheel.SetMassFromShapes();
             
            var leftJointDef:b2RevoluteJointDef = new b2RevoluteJointDef();
            leftJointDef.Initialize(body, leftWheel, leftWheel.GetWorldCenter());
            leftJointDef.enableMotor = true;
            leftJointDef.maxMotorTorque = 100;
             
            var rightJointDef:b2RevoluteJointDef = new b2RevoluteJointDef();
            rightJointDef.Initialize(body, rightWheel, rightWheel.GetWorldCenter());
            rightJointDef.enableMotor = true;
            rightJointDef.maxMotorTorque = 100;
             
            leftJoint = b2RevoluteJoint(myWorld.CreateJoint(leftJointDef));
            rightJoint = b2RevoluteJoint(myWorld.CreateJoint(rightJointDef));
             
            var leftRearJointDef:b2PrismaticJointDef = new b2PrismaticJointDef();
            leftRearJointDef.Initialize(body, leftRearWheel, leftRearWheel.GetWorldCenter(), new b2Vec2(1,0));
            leftRearJointDef.enableLimit = true;
            leftRearJointDef.lowerTranslation = leftRearJointDef.upperTranslation = 0;
             
            var rightRearJointDef:b2PrismaticJointDef = new b2PrismaticJointDef();
            rightRearJointDef.Initialize(body, rightRearWheel, rightRearWheel.GetWorldCenter(), new b2Vec2(1,0));
            rightRearJointDef.enableLimit = true;
            rightRearJointDef.lowerTranslation = rightRearJointDef.upperTranslation = 0;
             
            myWorld.CreateJoint(leftRearJointDef);
            myWorld.CreateJoint(rightRearJointDef);
             
             
            // debug draw
            var dbgDraw:b2DebugDraw = new b2DebugDraw();
            dbgDraw.m_sprite = new Sprite();
            addChild(dbgDraw.m_sprite);
            dbgDraw.m_drawScale = 20.0;
            dbgDraw.m_fillAlpha = 1;
            dbgDraw.m_lineThickness = 1.0;
            dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit |b2DebugDraw.e_centerOfMassBit;
            myWorld.SetDebugDraw(dbgDraw);
            
            
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyPressed_handler);
            stage.addEventListener(KeyboardEvent.KEY_UP, keyReleased_handler);
            
            parent.stage.addEventListener(Event.ENTER_FRAME, Update, false, 0 , true);
        }
        public function killOrthogonalVelocity(targetBody:b2Body):void {
            var localPoint:b2Vec2 = new b2Vec2(0,0);
            var velocity:b2Vec2 = targetBody.GetLinearVelocityFromLocalPoint(localPoint);
             
            var sidewaysAxis:b2Vec2 = targetBody.GetXForm().R.col2.Copy();
            
            print(sidewaysAxis.x);

            sidewaysAxis.Multiply(b2Math.b2Dot(velocity,sidewaysAxis))
         
            targetBody.SetLinearVelocity(sidewaysAxis);//targetBody.GetWorldPoint(localPoint));
        }
        
        public function keyPressed_handler(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.UP) {
                body.WakeUp();
                engineSpeed = -HORSEPOWERS;
            }
            if(e.keyCode == Keyboard.DOWN){
                engineSpeed = HORSEPOWERS;
            }
            if(e.keyCode == Keyboard.RIGHT){
                steeringAngle = MAX_STEER_ANGLE
            }
            if(e.keyCode == Keyboard.LEFT){
                steeringAngle = -MAX_STEER_ANGLE
            }
        }
        
        public function keyReleased_handler(e:KeyboardEvent):void {
            if(e.keyCode == Keyboard.UP || e.keyCode == Keyboard.DOWN){
                engineSpeed = 0;
            } 
            if(e.keyCode == Keyboard.LEFT || e.keyCode == Keyboard.RIGHT){
                steeringAngle = 0;
            }
        }
        
         
        public function Update(e:Event):void {
            myWorld.Step(1/30, 10);
            killOrthogonalVelocity(leftWheel);
            killOrthogonalVelocity(rightWheel);
            killOrthogonalVelocity(leftRearWheel);
            killOrthogonalVelocity(rightRearWheel);
         
            //Driving
            var ldirection:b2Vec2 = leftWheel.GetXForm().R.col2.Copy();
            ldirection.Multiply(engineSpeed);
            var rdirection:b2Vec2 = rightWheel.GetXForm().R.col2.Copy();
            rdirection.Multiply(engineSpeed);
            leftWheel.ApplyForce(ldirection, leftWheel.GetPosition());
            rightWheel.ApplyForce(rdirection, rightWheel.GetPosition());
         
             
            //Steering
            var mspeed:Number;
            mspeed = steeringAngle - leftJoint.GetJointAngle();
            leftJoint.SetMotorSpeed(mspeed * STEER_SPEED);
            mspeed = steeringAngle - rightJoint.GetJointAngle();
            rightJoint.SetMotorSpeed(mspeed * STEER_SPEED);
            
        }
        
        public function print (value:Object):void {
            //navigateToURL(new URLRequest('javascript:(function () {console.log(' + value.toString() + ');})()'));
            var t:TextField = this.getChildByName("debug") as TextField;
            if (t == null) {
                t  = new TextField();
                t.name = "debug";
                t.text = "";
                t.width = 400;
                t.height = 300;
                this.addChild(t);
            }

            t.text = value.toString() ;
        }

    }
}