/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/edZE
 */

package
{

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Rectangle;
    import flash.utils.Timer;   

    /**
     * ...
     * @author YopSolo
     */

    public class Main extends Sprite
    {
        private var takken_arr:Array;
        private var bmd:BitmapData;
        private var holder:Sprite;
        private var t:Timer;       

        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
      
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var a:Sprite = new Sprite();
            a.graphics.beginFill(0x000000);
            a.graphics.drawRect(0, 0, 465, 465);
            addChild(a);
            bmd = new BitmapData(465, 465, false, 0);
            var bm:Bitmap = new Bitmap(bmd);
            addChild(bm);
            holder = new Sprite();
            addChild(holder);
            var maskS:Sprite = new Sprite();
            maskS.graphics.beginFill(0x00ff00);
            maskS.graphics.drawRect(0, 0, 465, 465);
            holder.mask = maskS;
            takken_arr = new Array();
            addTak(232, 465, -3.14 / 2);
            addEventListener(Event.ENTER_FRAME, render);
            t = new Timer(3000, 1);
            t.addEventListener(TimerEvent.TIMER_COMPLETE, reDraw);            
        }

        public function reset():void
        {
            removeEventListener(Event.ENTER_FRAME, render);
            t.reset();
            t.start();
        }        

        public function reDraw(e:TimerEvent):void        {

            bmd.fillRect(new Rectangle(0, 0, 465, 465), 0);
            addTak(232, 465, -3.14 / 2);
            addEventListener(Event.ENTER_FRAME, render);
        }

        public function addTak(xPos:int, yPos:int, angle:Number = 0, dikte:Number = 25):void
        {
            var tak:Tak = new Tak();
            tak.dikte = dikte;
            tak.angle = angle;
            tak.x = xPos;
            tak.y = yPos;
            tak.grower = this;
            takken_arr.push(tak);
            holder.addChild(tak);
        }

       public function remove(t:Tak):void
        {
            takken_arr.splice(takken_arr.indexOf(t), 1);
            holder.removeChild(t);
            t = null
        }

        private function render(e:Event):void
        {
            for (var i:int = 0; i < takken_arr.length; i++)
            {
                takken_arr[i].render();
            }
            bmd.draw(this)
            if (takken_arr.length == 0)
            {                
            reset();
            }
        }
    }
}

    import flash.display.Sprite;
    
    class Tak extends Sprite
    {
        public var angle:Number = 0
        public var xPos:Number = 0
        public var yPos:Number = 0
        public var dikte:Number = 20
        public var grower:Main
        private var remove:Boolean = false
        private var blad_arr:Array = new Array(0XCC0000, 0XC00000, 0XCF0000, 0XD50000, 0XDA0000, 0XDA0000)
      
        function Tak()
        {
   
       }

        public function render():void
        {

            dikte -= 0.3
            var length:Number
            if (dikte < 1)
            {
                grower.remove(this)
            }
            
            if (dikte < 7)
            {
                graphics.clear()
                var index:int = Math.round(Math.random() * 5)
                graphics.beginFill(blad_arr[index], 1)
                graphics.drawCircle(-30 + xPos + Math.random() * 60, -30 + yPos + Math.random() * 60, (Math.random() * 10) + 2)
                graphics.lineStyle(dikte, 0xFFFFFF)
                graphics.moveTo(xPos, yPos);
                remove = true
                angle += Math.PI / 180 * ((Math.random() * 30) - 15);
                length = (Math.random() * 8) + 4
                xPos += length * Math.cos(angle);
                yPos += length * Math.sin(angle);
                if (Math.round(Math.random() * (length)) == 1)
                {
                    grower.addTak(x + xPos, y + yPos, angle + ((Math.random() - 0.5) * 2), dikte - Math.random() * 10);                    
                }
                graphics.lineTo(xPos, yPos);
            }
            else
            {
                graphics.clear()
                graphics.lineStyle(dikte, 0xFFFFFF)
                graphics.moveTo(xPos, yPos);
                angle += Math.PI / 180 * ((Math.random() * 14) - 7);
                length = (Math.random() * 8) + 4
                xPos += length * Math.cos(angle);
                yPos += length * Math.sin(angle);
                graphics.lineTo(xPos, yPos);
            }

            if (Math.round(Math.random() * (dikte / 2)) == 1)
            {
                grower.addTak(x + xPos, y + yPos, angle + ((Math.random() - 0.5) * 2), dikte - Math.random() * 10)                
            }
       }

    }

