/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ed0H
 */

package {
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.net.SharedObject;
    import flash.text.TextField;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
          
          
              deb = new TextField();
              deb.width = 320; deb.height=240;
              deb.mouseEnabled = false;
              addChild(deb);
             
             deb.text = "0";

            back = new BitmapData(64,64, false, 0);
            back.noise(23, 64, 128, 7, true);

            quickLoad();

            if (gameValue[2] == 100)
            {
              cx = gameValue[0];
              cy = gameValue[1];   
            }            
   
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
                
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);        
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }    
        public function onKup(e:KeyboardEvent):void  { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }
     
        public var cx:Number = 160;
        public var cy:Number = 160;
        public var scrw:Number = 465;
        public var scrh:Number = 465;        
        public var worldw:Number = 465*8;
        public var worldh:Number = 465*8;
        public var camx:Number = 0;
        public var camy:Number = 0;

        public var deb:TextField;

        public var gt:int = 0;
        public var ot:int = 0;

        public var back:BitmapData;

        public var mat:Matrix = new Matrix();
        
        public function onEnter(e:Event):void
        {
            
            var ms:Number; ms = 8;
            if (isKeyDown(Keyboard.UP)) { cy -= ms }
            if (isKeyDown(Keyboard.DOWN)) { cy += ms }
            if (isKeyDown(Keyboard.LEFT)) { cx -= ms }
            if (isKeyDown(Keyboard.RIGHT)) { cx += ms }
            
            
            camx = Math.floor(cx/scrw)*scrw;
            camy = Math.floor(cy/scrh)*scrh;


            var ax:Number;     var ay:Number;
            var ar:Number;
            ax = camx + scrw * 0.5;
            ay = camy + scrh * 0.5;
            ar  =32;
            
            if (getMag(ax-cx,ay-cy) < ar)
            {
              if (ot < gt-4)
              {
                  gameValue[0] = cx;
                  gameValue[1] = cy;
                  gameValue[2] = 100;
                  deb.text = ""+ot+"\n"+gameValue[0]+"\n"+gameValue[1];
                  quickSave();
              }  
              ot = gt;   
            }

           graphics.clear();
           graphics.lineStyle(2, 0); 
           
           graphics.drawRect(0-camx,0-camy, worldw,worldh);

           mat.a = worldw/64; mat.d = worldh/64;
           mat.tx = -camx; mat.ty = -camy;
           graphics.beginBitmapFill(back,mat,false,true);
            graphics.drawRect(0,0,465,465);
           graphics.endFill();


           graphics.beginFill(0xFFffFF);
            graphics.drawCircle(cx-camx,cy-camy, 8);
           graphics.endFill();
           
           graphics.drawCircle(ax-camx, ay-camy, ar);
           
           ms =4;
           graphics.drawRect(0,0, (worldw/scrw)*ms, (worldh/scrh)*ms);
           graphics.drawEllipse(Math.floor(cx/scrw)*ms, Math.floor(cy/scrh)*ms, ms,ms);       


           gt += 1;  
        }//onenter

        public function getMag(ax:Number, ay:Number):Number
        { return Math.sqrt(ax*ax + ay*ay); }
          
  
    
    
     //save game to shared
        public function quickSave():void    { saveGameValue(gameValue, curSlot); }
        public function quickLoad(slot:int=0):void    {  gameValue = loadGameValue(slot); }
                 
        public var gameValue:Vector.<int> = new Vector.<int>(64, false);
        public function resetGameValue():void 
        { gameValue = new Vector.<int>(64, false); 
          var i:int; var num:int; num = gameValue.length;
          for (i = 0; i < num; i++) { gameValue[i] = 0; }
        }//resetgame
    
        public var curSlot:int = 0;
        public var saveName:String = "mysave";
        public function saveGameValue(vec:Vector.<int>, slot:int=0):void
        {
         var so:SharedObject;
         try { so = SharedObject.getLocal(saveName, "/" );  }      catch (e:Error)    {   return ;   }     
         if (slot == 0) { so.data.slot0 = vec; }
         if (slot == 1) { so.data.slot1 = vec; }
         if (slot == 2) { so.data.slot2 = vec; }
         if (slot == 3) { so.data.slot3 = vec; }              
         try   {  so.flush();  }      catch (e:Error) {   return;  }
        }//savegamevalue
        
        public function loadGameValue(slot:int=0):Vector.<int>
        {
         var vec:Vector.<int>;     var ret:Vector.<int>;
         var so:SharedObject;
         try    { so = SharedObject.getLocal(saveName, "/" );   }
         catch (e:Error)  {   return null;     }
        
         if (slot == 1) { vec = so.data.slot1; }
         else if (slot == 2) { vec = so.data.slot2; }
         else if (slot == 3) { vec = so.data.slot3; }
         else { vec = so.data.slot0; }
         if (vec == null) { return new Vector.<int>(64, false); } 
         
         var i:int; var num:int;
         num = vec.length; ret = new Vector.<int>(num, false);
         for (i = 0; i < num; i++) { ret[i] = vec[i]; }
         return ret;
        }//loadgamevalue
    
        
    }//classend
}

/*
internal class xThing
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var cw:Number = 16;
    public var ch:Number = 16; 
    public var overTime:int = 0;
    
}
*/

