/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ebrK
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import com.bit101.components.*;
    import flash.events.Event;
    
    // @see http://www.itmedia.co.jp/enterprise/articles/1004/03/news002.html
    public class Makeplex extends Sprite {
        private var _tf : TextField;
        private var _ans : Text;
//        private const DEFAULT : String = "1112345678999";
        private const DEFAULT : String = "1122334455667";
  
        public function Makeplex() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
        		var text : InputText = new InputText(this, 10, 10, DEFAULT, onTextInput);
        		text.width = 440;
        		text.height = 20;
        		text.textField.restrict="1-9";
        		text.maxChars = 13;
        		
        		_ans = new Text(this, 10, 40);
        		_ans.width = 440;
        		_ans.height = 300;
        		
        		_ans.text = solve(DEFAULT).join('\n');
        		
        		/*
        		tr(solve("1112224588899"));
        		tr(solve("1122335556799"));
        		tr(solve("1112223335559"));
        		tr(solve("1223344888999"));
        		tr(solve("1112345678999"));
        		*/
        }
        
        private function onTextInput(e : Event) : void
        {
        		var text : String = TextField(e.target).text;
        		if(text.length == 13){
        			_ans.text = solve(text).join('\n');
        		}
        }

        private function solve(input : String) : Array
        {
        		if(input.length != 13)return [];
        		var c : Array = new Array(9);
        		for(var i : uint = 0;i < 9;i++)c[i] = 0;
        		for(i = 0;i < input.length;i++){
        			c[input.charCodeAt(i) - "1".charCodeAt(0)]++;
        		}
        		for(i = 0;i < 9;i++){
        			if(c[i] > 4){
        				return [];
        			}
        		}
        		
        		var ret : Array = [];
        		for(i = 0;i < 9;i++){
        			if(c[i] < 4){
        				c[i]++;
        				ret = ret.concat(rectop(c, i));
        				c[i]--;
        			}
        		}
        		
        		ret.sort();
        		for(i = ret.length - 1;i >= 1;i--){
        			if(ret[i] == ret[i-1]){
        				ret.splice(i, 1);
        			}
        		}
        		return ret;
        }
        
        private function rectop(a : Array, added : int) : Array
        {
        		var i : int;
        		var ret : Array = [];
        		// 雀頭を抜く
        		for(i = 0;i < 9;i++){
        			if(a[i] >= 2){
        				a[i] -= 2;
        				ret = ret.concat(rec(a, [(i+1).toString() + (i+1).toString()], 0, (added+1).toString()));
        				a[i] += 2;
        			}
        		}
        		
        		// チートイツの場合
        		var ti : String = "";
        		var head : uint = 0;
        		for(i = 0;i < 9;i++){
        			if(a[i] == 2){
        				if(i != added){
	        				ti += "(" + (i+1).toString() + (i+1).toString() + ")";
        				}
        			}else if(a[i] != 0){
        				break;
        			}
        		}
        		if(i == 9){
        			ret.push(ti + "[" + (added+1).toString() + "]");
        		}
        		
        		return ret;
        }
        
        private function rec(a : Array, hist : Array, pos : uint, added : String) : Array
        {
	        	var i : uint, j : uint;
        		var ret : Array = [];
        		if(hist.length == 5){
        			for(i = 0;i < hist.length;i++){
        				if(i >= 1 && hist[i] == hist[i-1])continue;
        				if(hist[i].indexOf(added) != -1){
        					var str : String = "";
        					for(j = 0;j < hist.length;j++){
        						if(j != i){
	        						str += "(" + hist[j] + ")";
        						}
        					}
        					str += "[" + hist[i].replace(added, "") + "]";
        					ret.push(str);
        				}
        			}
        			return ret;
        		}
        		
        		if(pos == 9)return [];
        	
        		var shunzi : String = (pos+1).toString() + (pos+2).toString() + (pos+3).toString();
        		var nhist : Array;
        		if(a[pos] >= 3){
        			nhist = hist.concat();
        			nhist.push((pos+1).toString() + (pos+1).toString() + (pos+1).toString());
        			if(a[pos] == 4)nhist.push(shunzi);
        			ret = ret.concat(rec(a, nhist, pos + 1, added));
        		}
        		if(pos <= 6 && a[pos] > 0 && a[pos] <= a[pos+1] && a[pos] <= a[pos+2]){
        			nhist = hist.concat();
        			a[pos+1]-=a[pos]; a[pos+2]-=a[pos];
        			for(i = 0;i < a[pos];i++){
        				nhist.push(shunzi);
        			}
        			ret = ret.concat(rec(a, nhist, pos + 1, added));
        			a[pos+1]+=a[pos]; a[pos+2]+=a[pos];
        		}
        		if(a[pos] == 0){
        			ret = rec(a, hist, pos + 1, added);
        		}
        		return ret;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}
