/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eaPK
 */

// [実験] ColorMatrixFilterとColorTransformはどっちが速い？
package {

import flash.display.*;
import flash.filters.*;
import flash.geom.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    private var _src:BitmapData;
    private var _dst:BitmapData;
    private var _rect:Rectangle;
    private var _zero:Point;
    
    //ColorMatrixFilter
    private var _cmf:ColorMatrixFilter;
    
    //ColorTransform
    private var _ctf:ColorTransform;
    
    public function Main():void
    {
        _src = new BitmapData(500, 500, false, 0x0);
        _src.noise(1);
        _dst = new BitmapData(500, 500, false, 0x0);
        _rect = new Rectangle(0, 0, 500, 500);
        _zero = new Point(0, 0);
        
        //scale 10
        _cmf = new ColorMatrixFilter([
            10, 0 , 0 ,  0, 10,
            0 , 10, 0 ,  0, 10,
            0 , 0 , 10,  0, 10,
            0 , 0 , 0 , 10, 10
        ]);
        _ctf = new ColorTransform(10, 10, 10, 10, 10, 10, 10, 10);
        
        _setup();
        
        _measure("ColorMatrixFilter", function ():void
        {
            _dst.applyFilter(_src, _rect, _zero, _cmf);
            
        }, 100);
        
        _measure("ColorTransform", function ():void
        {
            _dst.draw(_src, null, _ctf);
            
        }, 100);
    }
    
    private function _measure(
        title:String, func:Function, numTimes:uint, ...params):void
    {
        _time = getTimer();
        
        for (var i:int = 0; i < numTimes; i++) {
            func.apply(null, params);
        }
        
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth;
        _field.height = stage.stageHeight;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
    }
}

}