/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eZhy
 */

package {
    import flash.display.Sprite;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Rectangle;
    //
    import net.hires.debug.Stats;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    public class Main extends Sprite 
    {
    	
    		// number of particles and the Vector for them
    		private var num:uint = 100000
    		private var parts:Vector.<Part> = new Vector.<Part>(num)
    		// Bitmap and it's Data
    		private var B:Bitmap
    		private var D:BitmapData
    		// temp Part
    		private var p:Part
    		// var used for fill the Data
        private var R:Rectangle
    	
        public function Main() 
        {
        		// stage init, thx for every1 from wonderfl
        		stage.align = StageAlign.TOP_LEFT
        		stage.scaleMode = StageScaleMode.NO_SCALE
        		stage.quality = "low"
        		this.mouseEnabled = false;
			this.mouseChildren = false;
        		// init the Bitmap and it's Data
            D = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0)
            B = new Bitmap(D, "auto", true)
            R = D.rect
            stage.addChild(B)
            // init particles
            initPart()
            // enterFrame listener
            stage.addEventListener(Event.ENTER_FRAME, ef)
            stage.addChild(new Stats())
        }
        
        
        private function initPart():void
        {
        		// temp uint (count)
        		var i:uint = 0
        		// create the first particle
        		p = new Part()
        		parts[0] = p
        		// temp var stage width, stage height
        		var w:Number = stage.stageWidth, h:Number = stage.stageHeight
        		// create others particles
        		
        		while(++i < num)
        		{
        			p = new Part(Math.random()*w,Math.random()*h,Math.random()*4 - 2,Math.random()*4 - 2)
        			parts[i] = p
        			// assign some reference, for the looping process
        			parts[i-1].next = p
        		}
        }
        
        private function ef(e:Event = null):void
        {
        		// lock, for performace
        		D.lock()
        		// clear the Data
        		D.fillRect(R, 0)
        		// process for the first particle
        		p = parts[0]
        		D.setPixel((p.x += p.vx), (p.y += p.vy), 0xFFFFFF)
        		// process for others particles
        		while( (p = p.next) != null)
        		{
        			D.setPixel((p.x += p.vx), (p.y += p.vy), 0xFFFFFF)
        			if(p.x < 0) p.x += 465 else if(p.x > 465) p.x -= 465;
        			if(p.y < 0) p.y += 465 else if(p.y > 465) p.y -= 465;
        		}
        		// finally unlock
        		D.unlock()
        }
    }
}

class Part
{
	public var x:Number, y:Number, vx:Number, vy:Number
	public var next:Part
	
	public function Part(x:Number = 0, y:Number = 0, vx:Number = 0, vy:Number = 0)
	{
		this.x = x
		this.y = y
		this.vx = vx
		this.vy = vy
		
	}
	
	
}