/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eYx0
 */

// forked from Quasimondo's Different Color Averaging algorithms
package {
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class ColorAveraging extends Sprite 
    {
        private var tf:TextField = new TextField();
        private var shp:Shape = new Shape();
        private var g:Graphics = shp.graphics;
        private var colorA:Vector.<int>;
        private var colorB:Vector.<int>;
        private var blend:Number;
        
        public function ColorAveraging()
        {
             
             tf.autoSize = "left";
             tf.x = 130;
             addChild(shp);
             addChild(tf);
             
             colorA = new Vector.<int>();
             colorB = new Vector.<int>();
             
             randomizeColors();
             
             blend = 0.5;
             
             var t:Timer = new Timer( 200 );
             t.addEventListener( TimerEvent.TIMER, update );
             t.start();
        }
        
        private function randomizeColors():void
        {
            for ( var i:int = 0; i < 20; i++ )
             {
                 colorA[i] = Math.random() * 0x1000000;
                 colorB[i] = Math.random() * 0x1000000;
             }
        }

        private function update( event:TimerEvent ):void
        {
          
             g.clear();   
             tf.text = "";
             
             for ( var i:int = 0; i < 20; i++ )
             {
                 
                 g.beginFill( colorA[i] )
                 g.drawRect( 16,i*16,16,16 ); 
                 g.endFill();
                 
                 g.beginFill( interpolateColorsClassic(colorA[i],colorB[i], blend) )
                 g.drawRect( 40,i*16,16,16 );  
                 g.endFill();
                 
                 g.beginFill( interpolateColorsCompact(colorA[i],colorB[i], blend ))
                 g.drawRect( 56,i*16,16,16 ); 
                 g.endFill();
                 
                 g.beginFill( colorB[i] );
                 g.drawRect( 80,i*16,16,16 ); 
                 g.endFill();
                   
                 tf.appendText( interpolateColorsClassic(colorA[i],colorB[i],blend).toString(16) + " | "+interpolateColorsCompact(colorA[i],colorB[i], blend).toString(16) + "\n");
             
             }

             blend += 0.02; 
             if ( blend >= 1 )
             {
                 blend = 0;
                 randomizeColors();
             }

         }


        /*
            The classic color interpolation - split the color into 3 channels,
            blend them separately and joing them together again
            
        */
        private function interpolateColorsClassic( a:int, b: uint, lerp:Number ):int
        {
              var REDMASK:int   = 0xff0000;
              var GREENMASK:int = 0xff00;
              var BLUEMASK:int  = 0xff;
              
              var aRed:int   = a & REDMASK;
              var aGreen:int = a & GREENMASK;
              var aBlue:int  = a & BLUEMASK;
              var bRed:int   = b & REDMASK;
              var bGreen:int = b & GREENMASK;
              var bBlue :int = b & BLUEMASK;
               
              var f2:int = 256 * lerp;
              var f1:int = 256 - f2;
              
              var aveRed :int  = (aRed   * f1 + bRed   * f2 ) >> 8;
              var aveGreen:int = (aGreen * f1 + bGreen * f2 ) >> 8;
              var aveBlue:int  = (aBlue  * f1 + bBlue  * f2 ) >> 8;
       
              return (aveRed & REDMASK ) | (aveGreen & GREENMASK) | ( aveBlue & BLUEMASK );
          }
          
          
          /*
              This alternative method uses less local variables and less operators to achieve the same result:
          */
          private function interpolateColorsCompact( a:int, b:int, lerp:Number ):int
          { 
              var MASK1:int = 0xff00ff; 
              var MASK2:int = 0x00ff00; 
               
              var f2:int = 256 * lerp;
              var f1:int = 256 - f2;
              
              return ((((( a & MASK1 ) * f1 ) + ( ( b & MASK1 ) * f2 )) >> 8 ) & MASK1 ) | ((((( a & MASK2 ) * f1 ) + ( ( b & MASK2 ) * f2 )) >> 8 ) & MASK2 );
                        
          } 
          
         
     }
}