/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eYex
 */

/*
ツマミが2つあるスライダーを作ってみました。
smallerValueおよびlargerValueで現在の値を取得。
左右の位置関係は逆転しないようにしてあります。
いろいろ甘いところがありそう。
*/
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        		//引数：最小値、最大値、小さい方のつまみの初期値、大きい方のつまみの初期値、バーの長さ
            var slider:DoubleSlider = new DoubleSlider(0, 255, 40, 255, 200);
			slider.x = 50;
			slider.y = 50;
			addChild(slider);
			slider.addEventListener(Event.CHANGE, onChange);
			
			var tf:TextField = new TextField();
			tf.y = 100;
			addChild(tf);
			
			onChange();
			
			function onChange(e:Event = null):void{
				var s:String;
				s = String(slider.smallerValue);
				s += "\n";
				s += String(slider.largerValue)
				tf.text = s;
			}
        }
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
	
class DoubleSlider extends Sprite
{
	private var _min:Number;
	private var _max:Number;
		
	private var _bar:Sprite;
	private var _barLength:Number;
	private var change:Event = new Event(Event.CHANGE);
		
	private var _smallerValue:Number;
	public function get smallerValue():Number { return _smallerValue; }
	public function set smallerValue(value:Number):void 
	{
		_smallerValue = value;
		dispatchEvent(change);
	}
		
	private var _largerValue:Number;
	public function get largerValue():Number { return _largerValue; }
	public function set largerValue(value:Number):void 
	{
		_largerValue = value;
		dispatchEvent(change);
	}
		
		
	public function DoubleSlider($min:Number, $max:Number, $smallerValue:Number, $largerValue:Number, $barLength:Number = 200) 
	{
		_min = $min;
		_max = $max;
		_smallerValue = $smallerValue;
		_largerValue = $largerValue;
		_barLength = $barLength;
			
		_bar = new Sprite();
		drawBar(_bar);
		addChild(_bar);
			
		var _smallerNob:Nob = new Nob(_barLength);
		_bar.addChild(_smallerNob);
		_smallerNob.x = smallerValue / _max * _barLength;
			
		var _sText:TextField = createTextField(-20, 5);
		_sText.text = "min:" + String(Math.floor(_smallerValue));
		_smallerNob.addChild(_sText);
			
		_smallerNob.addEventListener(Event.CHANGE, function(e:Event):void 
		{
			smallerValue = _smallerNob.x / _barLength * _max;
			if (_smallerValue > _largerValue) 
			{
				smallerValue = _largerValue;
				_smallerNob.x = _largerNob.x;
			}
			_sText.text = "min:" + String(Math.floor(_smallerValue));
		});
			
			
		var _largerNob:Nob = new Nob(_barLength);
		_bar.addChild(_largerNob);
		_largerNob.x = _largerValue / _max * _barLength;
		
		var _lText:TextField = createTextField(-20, -32);
		_lText.text = "max:" + String(Math.floor(_largerValue));
		_largerNob.addChild(_lText);
		
		_largerNob.addEventListener(Event.CHANGE, function(e:Event):void 
		{
			largerValue = _largerNob.x / _barLength * _max;
			if (_largerValue < _smallerValue) 
			{
				largerValue = _smallerValue;
				_largerNob.x = _smallerNob.x;
			}
			_lText.text = "max:" + String(Math.floor(_largerValue));
		});
		
	}
		
	protected function drawBar(sp:Sprite):void 
	{
		var barHeight:Number = 5;
		var g:Graphics = sp.graphics;
		g.beginFill(0x000000);
		g.drawRect(0, -barHeight / 2, _barLength, barHeight);
	}
	
	private function createTextField($x:Number, $y:Number):TextField 
	{
		var tf:TextField = new TextField();
		tf.x = $x; tf.y = $y;
		tf.width = 55; tf.height = 18;
		tf.scaleX = tf.scaleY = 1.3;
		tf.mouseEnabled = false;
		return tf;
	}
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.text.TextField;

class Nob extends Sprite
{
	public var dragArea:Rectangle;
	
	private var tf:TextField;
	private var change:Event = new Event(Event.CHANGE);
	
	
	public function Nob(dragLength:Number) 
	{
		dragArea = new Rectangle(0, 0, dragLength,0);
		
		var g:Graphics = graphics;
		g.beginFill(0x999999, 0.7);
		g.lineStyle(3, 0x000000);
		g.drawCircle(0, 0, 10);
		
		buttonMode = true;
		addEventListener(Event.ADDED_TO_STAGE, onAdd);
	}
	
	private function onAdd(e:Event):void 
	{
		removeEventListener(Event.ADDED_TO_STAGE, onAdd);
		addEventListener
		(
			MouseEvent.MOUSE_DOWN,
			function(e:MouseEvent):void 
			{
				startDrag(false, dragArea);
				stage.addEventListener
				(
					MouseEvent.MOUSE_UP, 
					function(e:MouseEvent):void 
					{
						stage.removeEventListener(MouseEvent.MOUSE_UP, arguments.callee);
						stopDrag();
						dispatchEvent(change);
					}
				);
			}
		);
	}
	
	
}

