/**
 * Copyright codextends ( http://wonderfl.net/user/codextends )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eYTI
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
    /**
     * 3Tone Motion Circles
     * @author codextends
     * Experimenting with as3 child-parent relationship and positionning on a circle
     *                  __                  __                      __            
     */     
    [SWF(width = 500, height = 500, frameRate = 60,backgroundColor=0x000000)]
         
    public class Main extends Sprite 
    {
        // Parameters
        private const NB_CIRCLE:int = 7;
        private const PRECISION:int = 1024;
        private const MAX_MOTION:int = 16;
        private const MAX_SIZE:int = 150;
        private const INIT_POS_X:int = 225;
        private const INIT_POS_Y:int = 225;
        private const COLORS:Array = [    [0xDC0055, 0xA52959, 0x8F0037, 0xEE3B80, 0xEE6B9E],
                                        [0x00B64F, 0x22884F, 0x007633, 0x37DA7E, 0x62DA97],
                                        [0xDCF900 , 0xAABB2F , 0x8FA200, 0xE6FC3F, 0xECFC71]];   // 3Tone ColorScheme
            
        
        private var motions:Array = ["n/a", 7, -13, 9, -7, 5, -3, 1, -7];
        private var circles:Array;     // Successive generations of circles                                
        private var indexes:Array; // keep track of position indexes
        private var sizes:Array;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            circles = new Array();
            sizes = new Array();
                        
            for (var i:int = 0; i < NB_CIRCLE; i++)
            {
                var sprite:Sprite = new Sprite();
                var size:Number = MAX_SIZE - i * (MAX_SIZE / (NB_CIRCLE + 1));
                sizes.push(size);
                sprite.graphics.beginFill(COLORS[randomNumber(0, 2)][randomNumber(0, 4)], 1-(1/(NB_CIRCLE+1)));
                sprite.graphics.drawCircle(0, 0, size/2);
                sprite.graphics.endFill();
                
                circles.push(sprite);
                if (i > 0)
                {
                // code pour les childs
                    circles[i - 1].addChild(sprite);
                }
                
            }
            
            // add first child to display list
            circles[0].x = INIT_POS_X;
            circles[0].y = INIT_POS_Y;
            this.addChild(circles[0]);
                        
            // setting indexes
            indexes = new Array();
            indexes.push(0); // first index set to 0 for lisibility
                        
            for (i = 1; i < NB_CIRCLE; i++)
            {
                indexes.push(randomNumber(0, PRECISION));
            }
            generateMotion();
            updatePositions();
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            this.addEventListener(MouseEvent.CLICK, onMouseClick);
            addChild(new Stats());
        }

        private function onEnterFrame(e:Event):void
        {
            updatePositions();
        }
        
        private function onMouseClick(e:Event):void
        { 
            generateMotion();
        }
        
        private function updatePositions ():void
        {
            for (var i:int = 1; i < NB_CIRCLE; i++)
            {
                indexes[i]+= motions[i];
                if (indexes[i] >= PRECISION) indexes[i] = indexes[i] - PRECISION;
                if (indexes[i] <= 0) indexes[i] = indexes[i] + PRECISION;
                
                var coord:Array = pointCircle(indexes[i], PRECISION, sizes[i-1]/2);
                circles[i].x = coord[0];
                circles[i].y = coord[1];
            }
        }
            
        private function pointCircle(index:int, n:int = 15, radius:Number = 1):Array 
        {
            var pi:Number = Math.PI; // pour alleger le code
            var x:Number = Math.cos( 2 * index * pi / n );
            var y:Number = Math.sin( 2 * index * pi / n );

            return [x * radius, y * radius];
        }

        private function generateMotion():void
        {
            for (var i:int = 1; i < NB_CIRCLE; i++)
            {
                if (randomNumber(0, 1))
                {
                    motions[i] = randomNumber (0, MAX_MOTION);
                }
                else
                {
                    motions[i] = 0 - (randomNumber (0, MAX_MOTION));
                }
            }
            
        }    
        // Helper Functions
        private function randomNumber(low:Number=0, high:Number=1):Number
        {
            return Math.floor(Math.random() * (1+high-low)) + low;
        }
        //Et voilà ! ça marche !
    }
}