/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eXTe
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.geom.Point;
	import flash.display.Graphics;
	/**
	 * ...
	 * @author Motoki Matsumoto
	 */
	public class TileTest extends Sprite
	{
		
		public function TileTest() 
		{
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			init();
		}
		
		private function init():void
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			var world:Sprite = new Sprite();
			addChild(world);
			world.x = stage.stageWidth * 0.5;
			world.y = 100;
			
			for ( var i:int = 0; i < 10; i++) {
				for ( var j:int = 0; j < 10; j++) {
					var tile:DrawnIsoTile = new DrawnIsoTile(20, 0xcccccc);
					tile.position = new Point3D(i * 20, 0, j * 20);
					world.addChild(tile);
				}
			}
		}
		
	}
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.display.Graphics;

class IsoUtils {
	public static const Y_CORRECT:Number = Math.cos( -Math.PI / 6) * Math.SQRT2;
	public static function isoToScreen(pos:Point3D):Point {
		var screenX:Number = pos.x - pos.z;
		var screenY:Number = pos.y * Y_CORRECT + (pos.x + pos.z) * 0.5;
		
		return new Point(screenX, screenY);		
	}
	public static function screenToIso(point:Point):Point3D {
		var xpos:Number = point.y + point.x * 0.5;
		var ypos:Number = 0;
		var zpos:Number = point.y - point.x * 0.5;
		return new Point3D(xpos, ypos, zpos);
	}
}
class Point3D {
	public var x:Number;
	public var y:Number;
	public var z:Number;
	public function Point3D(x:Number = 0, y:Number = 0, z:Number = 0) {
		this.x = x;
		this.y = y;
		this.z = z;
	}
}

class IsoObject extends Sprite {
	protected var _position:Point3D;
	protected var _size:Number;
	protected var _walkable:Boolean = false;
	
	public static const Y_CORRECT:Number = Math.cos( -Math.PI / 6) * Math.SQRT2;
	
	public function IsoObject(size:Number) {
		_size = size;
		_position = new Point3D();
		updateScreenPosition();
	}
	
	protected function updateScreenPosition():void
	{
		var screenPos:Point = IsoUtils.isoToScreen(_position);
		super.x = screenPos.x;
		super.y = screenPos.y;
	}
	
	override public function get x():Number { return _position.x; }
	override public function set x(value:Number):void 
	{
		_position.x = value;
		updateScreenPosition();
	}
	
	override public function get y():Number { return _position.y; }	
	override public function set y(value:Number):void 
	{
		_position.y = value;
		updateScreenPosition();
	}
	override public function set z(value:Number):void {
		_position.z = value;
		updateScreenPosition();
	}
	override public function get z():Number {
		return _position.z;
	}
	public function get position():Point3D {
		return _position;
	}
	public function set position(value:Point3D):void {
		_position = value;
		updateScreenPosition();
	}
	public function get depth():Number {
		return (_position.x + _position.z) * 0.866 - _position.y * 0.707;
	}
	
	public function get walkable():Boolean { return _walkable; }
	
	public function set walkable(value:Boolean):void 
	{
		_walkable = value;
	}
	
	public function get size():Number { return _size; }
	
	public function get rect():Rectangle {
		return new Rectangle(x - size / 2, z - size / 2, size, size);
	}
	
}

class DrawnIsoTile extends IsoObject {
	protected var _height:Number;
	protected var _color:uint;
	
	public function DrawnIsoTile(size:Number, color:uint, height:Number = 0) {
		super(size);
		_color = color;
		_height = height;
		draw();
	}
	
	private function draw():void
	{
		var g:Graphics = graphics;
		
		g.clear();
		g.lineStyle(0, 0, 0.5);
		g.beginFill(_color);
		g.moveTo( -size, 0);
		g.lineTo(0, -size * 0.5);
		g.lineTo(size, 0);
		g.lineTo(0, size * 0.5);
		g.lineTo( -size, 0);
		g.endFill();
	}
	
	override public function get height():Number { return _height; }
	override public function set height(value:Number):void 
	{
		_height = value;
		draw();
	}
	
	public function get color():uint { return _color; }
	public function set color(value:uint):void 
	{
		_color = value;
	}
}