/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eWfj
 */

// forked from yanbaka's HANABI
// コード全然違うけど参考にさせてもらいました。
// なんだこれ？

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
	
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	 public class Main extends Sprite 
	{
		private const WIDTH:Number = 465;
		private const HEIGHT:Number = 465;
		private const MAX:Number = Math.sqrt(WIDTH * WIDTH + HEIGHT * HEIGHT);
		private const NUM:uint = 400;
		
		private var particles:Array;
		private var bmd:BitmapData;
		private var cTra:ColorTransform;
		private var rect:Rectangle;
		private var timer:Timer;
		private var groupNum:uint = 0;
		
		public function Main():void {
			init();
		}
		
		private function init():void {
			bmd = new BitmapData(WIDTH, HEIGHT, false, 0x0);
			addChild(new Bitmap(bmd)) as Bitmap;
			
			rect = new Rectangle(0, 0, WIDTH, HEIGHT);
			cTra = new ColorTransform(.8, .8, .9, 1.0);
			
			//パーティクルを作る
			particles = [];
			for (var i:uint = 0; i < NUM; i++) {
				var p:Particle = new Particle(WIDTH * Math.random(), HEIGHT * Math.random(), 0, 0, i % 3);
				particles.push(p);
			}
			
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, resetFunc);
			timer.start();
		}
		
		private function resetFunc(event:TimerEvent):void {
			groupNum = (groupNum + 1) % 3;
		}
		
		private function onEnterFrame(event:Event):void {
			bmd.lock();
			bmd.applyFilter(bmd, rect, new Point(), new BlurFilter(1, 1));
			bmd.colorTransform(rect, cTra);
			
			for (var i:uint = 0; i < NUM; i++ ) {
				var p:Particle = particles[i];
				
				//一番近い子探すよ
				var nearp:Particle;
				var min:Number = MAX;
				var pnum:uint;
				for (var j:uint = 0; j < NUM; j++ ) {
					if (i == j) continue;
					nearp = particles[j];
					if (p.getLength(nearp) < min) pnum = j; //近いっぽい
				}
				nearp = particles[pnum];//見つけた
				
				//ベクトル決定
				if (p.group == groupNum) {
					p.vx = (nearp.x - p.x) / 10;
					p.vy = (nearp.y - p.y) / 10;
				}else{
					p.vx = 300 / (nearp.x - p.x);
					p.vy = 300 / (nearp.y - p.y);
				}
				
				//位置決定
				p.x = p.x + p.vx;
				p.y = p.y + p.vy;
				
				if (p.x < 0 ) p.x = WIDTH- p.x % -WIDTH;
				else if (p.x >= WIDTH) p.x %= WIDTH;
				
				if (p.y < 0 ) p.y = HEIGHT- p.y % -HEIGHT;
				else if (p.y >= HEIGHT) p.y %= HEIGHT;
				
				bmd.setPixel32(p.x, p.y, 0xFFFFFFFF);
			}
			bmd.unlock();
		}
	}
}

class Particle 
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var group:uint;
	
	public function Particle( _x:Number = 0, _y:Number = 0, _vx:Number = 0, _vy:Number = 0, _group:uint = 0) {
		this.x = _x;
		this.y = _y;
		this.vx = _vx;
		this.vy = _vy;
		this.group = _group;
	}
	
	public function getLength(otherParticle:Particle):Number {
		var length:Number;
		length = (this.x - otherParticle.x) * (this.x - otherParticle.x);
		length += (this.y - otherParticle.y) * (this.y - otherParticle.y);
		return Math.sqrt(length);
	}
	
}
