/**
 * Copyright siaukia ( http://wonderfl.net/user/siaukia )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eWcN
 */

package {
    import flash.display.Sprite;        
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
        
    public class ScrambleText extends Sprite {
        
        private var txt:TextField                                      = new TextField();        
        
        public function ScrambleText() {
            initTextField();
            scrambleText(txt)
        }   
        
        private function initTextField():void {
            var tf:TextFormat                                          = new TextFormat();

            txt.text                                                   = "Hello World!";            
            tf.font                                                    = "Arial";
            tf.size                                                    = 20;
            tf.color                                                   = 0xFF0000;
            txt.setTextFormat(tf);
            txt.selectable                                             = false;
            txt.width                                                  = txt.textWidth;
            txt.scaleX                                                 = 4;
            txt.scaleY                                                 = 4;
            txt.x                                                      = (stage.stageWidth/2)-(txt.width/2);
            txt.y                                                      = (stage.stageHeight/2)-(txt.height/2);
                       
            addChild(txt)
        }     
        
        // ---------------------------------------------------------------------

        private function scrambleText(textField:TextField, speed:Number = 30):void {
            var string:String                                           = textField.text;
    	    var t:Timer 						= new Timer(speed)
            t.addEventListener(TimerEvent.TIMER, startScrambleTimer, false, 0, true);			
	    t.start();	
	
	    function startScrambleTimer(event:TimerEvent):void {
		var arrayText:Array 					= new Array();
		
		for (var i:int = 0; i <event.currentTarget.currentCount; i++) {
    		    arrayText[i] 					= String.fromCharCode(Math.floor((Math.random()*94)+33))
		}
		var s:String 						= arrayText.toString()		                    
                s							= s.split(",").join("")
		textField.text						= s
	
		if (event.currentTarget.currentCount > string.length) {
			event.currentTarget.reset();
			event.currentTarget.removeEventListener(TimerEvent.TIMER, startScrambleTimer);			
			event.currentTarget.addEventListener(TimerEvent.TIMER, stopScrambleTimer, false, 0, true);
			event.currentTarget.start();
		}
	    }
	    function stopScrambleTimer(event:TimerEvent):void{ 
		var currentText:String					= textField.text;		
		var arrayText:Array 					= new Array();
	
		for (var i:int = 0; i <string.length; i++) {
	            arrayText[i]				        = string.charAt(i)
		    if (i						> event.currentTarget.currentCount) {
			arrayText[i] 				        = String.fromCharCode(Math.floor((Math.random()*94)+33))
		    }
		}

		var s:String 						= arrayText.toString()
		s							= s.split(",").join("")
		textField.text						= s
		
		if (event.currentTarget.currentCount > string.length) {
			event.currentTarget.reset();
			event.currentTarget.removeEventListener(TimerEvent.TIMER, startScrambleTimer);			
			event.currentTarget.removeEventListener(TimerEvent.TIMER, stopScrambleTimer);	
		}		
	    }
        }

        // ---------------------------------------------------------------------
        
    }  
}