/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eWRS
 */

// forked from k__'s  Red / Blue Stereo 3D(Winter trees)
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    
    public class Main extends Sprite {
        private var bg:Shape;
        private var canvas:Vector.<Shape>;
        private var colors:Array = [0xff0000, 0x3399ff];
        private var cx:Number,cy:Number;
        private var verts:Vector.<Number>;
        private var pVerts:Vector.<Number>;
        private var uvts:Vector.<Number>;
        private var pmtx:Matrix3D;
        private var pers:PerspectiveProjection;
        private var xr:Number = 0, yr:Number = 0;
        
        private var trees:Array;
        
        
        public function Main() {
            cx = stage.stageWidth / 2;
            cy = stage.stageWidth / 2;
            verts = new Vector.<Number>();
            pVerts = new Vector.<Number>();
            pmtx = new Matrix3D();
            pers = new PerspectiveProjection();
            uvts = new Vector.<Number>();
            
            addChild(bg = new Shape);
            bg.graphics.beginFill(0x000000);
            bg.graphics.endFill();
            canvas = new Vector.<Shape>;
            canvas.push(new Shape());
            canvas.push(new Shape());
            
            trees = new Array();
            for (var i:uint = 0; i < 30; i ++) {
                trees.push(createTree(Math.random() * 600 - 300 ,Math.random() * 1200 - 300));
            
            }
            
            addChild(canvas[0]);
            addChild(canvas[1]);
            addEventListener(Event.ENTER_FRAME, h_enterframe);
        }
        
        private function createTree(px:Number, pz:Number):Object {
            var points:Array = [], lines:Array = [];
            var th:Number = 30;
            var tw:Number = 30;
            points.push([px,0,pz],[px,-th,pz]);
            lines.push([0, 1]);
            for (var i:uint = 0; i < 5; i ++) {
                var n:uint = points.length;
                for (var j:uint = 1; j < n; j ++) {
                    var ang:Number = Math.random() * Math.PI * 2;
                    var d:Number = Math.random() * tw;
                    points.push([points[j][0] + Math.cos(ang) * d, points[j][1] - Math.random() * th, points[j][2] + Math.sin(ang) * d]);
                    lines.push([j, points.length - 1]);
                }
            }
            return {points:points,lines:lines};
        }
        
        
        
        private function h_enterframe(evt:Event):void {
            yr = (cx - mouseX) / 40;
            xr = 70 - (cy - mouseY) / 30 - 20;
            render();
        }
        
        private function render():void {
            var deletes:Array = [];
            verts = new Vector.<Number>();
            for (var i:uint = 0; i < trees.length; i ++) {
                var flag:Boolean = false;
                for (var j:uint = 0; j < trees[i].points.length; j ++) {
                    verts.push(trees[i].points[j][0]);
                    verts.push(trees[i].points[j][1]);
                    verts.push(trees[i].points[j][2]);
                    trees[i].points[j][0] += (cx - mouseX) / 200;
                    trees[i].points[j][2] -= 4;
                    if (trees[i].points[j][2] <= -300 && !flag) {
                        flag = true;
                        deletes.push(i);
                    }
                }
            }
            pers.fieldOfView = 60;
            pmtx.identity();
            pmtx.appendRotation(xr, Vector3D.X_AXIS);
            pmtx.appendRotation(yr - 1, Vector3D.Y_AXIS);
            pmtx.appendTranslation(0, 0, pers.focalLength);
            pmtx.append(pers.toMatrix3D());
            bugfix(pmtx);
            Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
            drawGraphics(canvas[0].graphics, colors[0], pVerts);
            
            pmtx.identity();
            pmtx.appendRotation(xr, Vector3D.X_AXIS);
            pmtx.appendRotation(yr + 1, Vector3D.Y_AXIS);
            pmtx.appendTranslation(0, 0, pers.focalLength);
            pmtx.append(pers.toMatrix3D());
            bugfix(pmtx);
            Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
            drawGraphics(canvas[1].graphics, colors[1], pVerts);
            
            for (i = 0; i < deletes.length; i ++) {
                trees[deletes[i]] = createTree(Math.random() * 600 - 300, 900);
            }
            
        }
        
        private function drawGraphics(g:Graphics, c:uint, vt:Vector.<Number>):void {
            g.clear();
            g.lineStyle(0, c, 0.3);
            var ind:uint = 0;
            for (var i:uint = 0; i < trees.length; i ++) {
                var flag:Boolean = false;
                for (var j:uint = 0; j < trees[i].lines.length; j ++) {
                    g.moveTo(vt[(trees[i].lines[j][0] + ind) * 2] + cx, vt[(trees[i].lines[j][0] + ind) * 2 + 1] + cy);
                    g.lineTo(vt[(trees[i].lines[j][1] + ind) * 2] + cx, vt[(trees[i].lines[j][1] + ind) * 2 + 1] + cy);
                    if (vt[(trees[i].lines[j][1] + ind) * 2 + 1] + cy < stage.stageHeight) {}
                }
                ind += trees[i].lines.length + 1;
            }
        }
        
        
        private function bugfix(matrix:Matrix3D):void {
            var m1:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0 ]));
            var m2:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0 ]));
            m1.append(m2);
            if (m1.rawData[15] == 20) {
                var rawData:Vector.<Number> = matrix.rawData;
                rawData[15] /= 20;
                matrix.rawData = rawData;
            }
        }
        
    }
}