/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eVd0
 */

// forked from tkinjo's minimalcomps を使ってコンポーネントを作ってみた
package 
{
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import org.si.sion.*;
    import org.si.sion.utils.*;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite 
    {
        private var timer:Timer = new Timer( 1000 );
        private var noteOnTimer:Timer = new Timer( 100, 1 );
        
        private var driver:SiONDriver = new SiONDriver();
        private var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        private var voice:SiONVoice;
        private var bpmInputTextAndHSlider:InputTextAndHSlider;
        
        public function Main():void 
        {
            bpmInputTextAndHSlider = new InputTextAndHSlider( this, 10, 10, "BPM" );
            bpmInputTextAndHSlider.y = ( stage.stageHeight - bpmInputTextAndHSlider.height ) / 2;
            bpmInputTextAndHSlider.label.width = 50;
            bpmInputTextAndHSlider.inputText.width = 30;
            bpmInputTextAndHSlider.round = 0;
            bpmInputTextAndHSlider.hSlider.maximum = 200;
            bpmInputTextAndHSlider.hSlider.minimum = 1;
            bpmInputTextAndHSlider.value = 120;
            bpmInputTextAndHSlider.hSlider.width = 360;
            bpmInputTextAndHSlider.addEventListener(Event.CHANGE, bpmChangeHandler);
            
            voice = presetVoice[ "sine" ];
            driver.play();
            
            updateDelay();
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            
            noteOnTimer.addEventListener(TimerEvent.TIMER_COMPLETE, noteOnCompleteHandler);
        }
        
        private function timerHandler( event:TimerEvent ):void {
            
            driver.noteOn( 60 );
            
            noteOnTimer.start();
        }
        
        private function noteOnCompleteHandler( event:TimerEvent ):void {
            
            driver.noteOff( 60 );
        }
        
        private function bpmChangeHandler( event:Event ):void {
            
            updateDelay();
        }
        
        private function updateDelay():void {
            
            timer.delay = 60000 / bpmInputTextAndHSlider.value;
        }
    }
}
import com.bit101.components.*;
import flash.text.*;
import flash.display.*;
import flash.events.*;

class LabelEx extends Label {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    
    
    private var textField:TextField;
    
    public function LabelEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = ""):void
    {
        super(parent, xpos, ypos, text);
    }
    
    /**
     * Initializes the component.
     */
    override protected function init():void
    {
        super.init();
        setSize(100, 16);
    }
    
    /**
     * Creates and adds the child display objects of this component.
     */
    override protected function addChildren():void
    {
        super.addChildren();
        
        for ( var i:uint = 0; i < numChildren; i++ ) {
            
            var child:DisplayObject = getChildAt( i );
            
            if ( child is TextField ) {
                
                textField = child as TextField;
                break;
            }
        }
    }
}

class InputTextEx extends InputText {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    public function InputTextEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = "", defaultHandler:Function = null)
    {
        super( parent, xpos, ypos, text, defaultHandler );
    }
    
    /**
     * Creates and adds child display objects.
     */
    override protected function addChildren():void
    {
        super.addChildren();
        textField.autoSize = TextFieldAutoSize.LEFT;
    }
    
    protected override function onChange(event:Event):void
    {
        super.onChange( event );
        dispatchEvent( event );
    }
}

class HSliderEx extends HSlider {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    public function HSliderEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, defaultHandler:Function = null):void
    {
        super(parent, xpos, ypos, defaultHandler);
    }
}

class InputTextAndHSlider extends Sprite {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")]
    
    
    
    /**
     * label
     */
    public function get label():Label {
        
        return _label;
    }
    private var _label:Label;
    
    
    
    /**
     * inputText
     */
    public function get inputText():InputTextEx {
        
        return _inputText;
    }
    private var _inputText:InputTextEx;
    
    
    
    /**
     * hSlider
     */
    public function get hSlider():HSliderEx {
        
        return _hSlider;
    }
    private var _hSlider:HSliderEx;
    
    
    
    /**
     * round
     */
    public var round:int = 2;
    
    
    
    /**
     * value
     */
    public function get value():Number {
        
        return _value;
    }
    public function set value( tempValue:Number ):void {
        
        _value = Math.round( tempValue * Math.pow( 10, round ) ) / Math.pow( 10, round );
        hSlider.value = tempValue;
        
        if ( !isNaN( value ) )
            inputText.text = value.toString();
        
        dispatchEvent( new Event( Event.CHANGE ) );
    }
    private var _value:Number;
    
    
    
    /**
     * 
     * @param    parent
     * @param    xpos
     * @param    ypos
     * @param    text
     */
    public function InputTextAndHSlider(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, text:String = ""):void
    {
        parent.addChild( this );
        x = xpos;
        y = ypos;
        
        // label
        _label = new LabelEx( this, 0, 0, text );
        
        // inputText
        _inputText = new InputTextEx( this );
        inputText.restrict = "-0-9.";
        updateInputTextPosition( label );
        
        // hSlider
        _hSlider = new HSliderEx( this );
        hSlider.backClick = true;
        updateHSliderPosition( inputText );
        
        
        
        // hSlider eventlistener
        label.addEventListener(Event.RESIZE, function( event:Event ):void {
                updateInputTextPosition( label );
            } );
        
        // inputText eventlistener
        inputText.addEventListener(Event.CHANGE, function( event:Event ):void {
                value = parseFloat( inputText.text );
            } );
        inputText.addEventListener(Component.DRAW, function( event:Event ):void {
                updateHSliderPosition( inputText );
            } );
        inputText.addEventListener(FocusEvent.FOCUS_OUT, function( event:FocusEvent ):void {
                if ( isNaN( value ) )
                    inputText.text = "0";
            } );
        
        // hSlider eventlistener
        hSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                
                if( value != hSlider.value )
                    value = hSlider.value;
            } );
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateInputTextPosition( component:DisplayObject ):void {
        
        inputText.y = component.y + ( component.height - inputText.height ) / 2;
        inputText.x = ( component.x + component.width ) + ( inputText.y - component.y ) + 10;
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateHSliderPosition( component:Component ):void {
        
        hSlider.y = component.y + ( component.height - hSlider.height ) / 2;
        hSlider.x = ( component.x + component.width ) + ( hSlider.y - component.y ) + 10;
    }
}