/**
 * Copyright __Guillaume ( http://wonderfl.net/user/__Guillaume )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eVTH
 */

/*
Distribute points on a sphere
Based on E.B. Saff and A.B.J. Kuijlaars Algorithm
Author : Guillaume Nachury
site : http://riasandbox.com/
*/
package
{
    import flash.display.Sprite;
    import flash.geom.Vector3D;
    
    [SWF(widthPercent="100", heightPercent="100", backgroundColor="#000000")]
    public class FlashTest extends Sprite
    {
        private var radius:Number = 150; //Sphere radius
        private var pointNumber:Number =250; //Number of point to be distributed
        
        public function FlashTest()
        {
                var _v:Vector.<Vector3D> = new Vector.<Vector3D>();
                var _vPtr:int = 0;
                var _previousPhi:Number = 0;
                
                for (var i:int = 1; i <= pointNumber; i++) 
                {
                    
                    var h:Number =  -1 + 2*(i-1)/(pointNumber-1);
                    var theta:Number = Math.acos(h);
                    var phi:Number = 0;
                    if(i ==1 || i == pointNumber){
                        phi = 0;                    
                    }                    
                    else{
                        phi = (_previousPhi + 3.6/(Math.sqrt(100*(1-h*h))))%(2*Math.PI);
                    }
                    
                    //create a 3D vector inorder to store a 3D point
                    var v3d:Vector3D = new Vector3D(Math.cos(phi)*Math.sin(theta)*radius, Math.sin(phi)*Math.sin(theta)*radius, Math.cos(theta)*radius);
                   
                   //can be skiped
                    _v.push(v3d);    
                    
                    //Create a particle
                    var s:Sprite = new Sprite();
                    s.graphics.beginFill(0xffffff);
                    s.graphics.drawCircle(0,0,5);                    
                    s.graphics.endFill();
                    
                    //Place the particle in 3D space
                    s.x = v3d.x+stage.stageWidth*.5;
                    s.y = v3d.y+stage.stageHeight*.5;
                    s.z = v3d.z;
                    
                    //Adapt the alpha/scale based on the z position
                    if(s.z >radius/2 && s.z <=radius) s.alpha = 1;
                    else if(s.z >0 && s.z <=radius/2) s.alpha = 0.75;
                    else if(s.z >-radius/2 && s.z <=0) s.alpha = 0.5;
                    else if(s.z >=-radius && s.z -radius/2) s.alpha = 0.25;
                    
                    s.scaleY =s.scaleX = s.alpha;
                    
                    //Add the particle to the stage
                    addChild(s);
                    
                    //store the previous phi value
                    _previousPhi = phi;
                   }
            
        }
        
    }
}