/**
 * Copyright Zahurdias.Calimero ( http://wonderfl.net/user/Zahurdias.Calimero )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eV0S
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.setTimeout;

    public class Pie extends Sprite {

        private var cL:uint = 0; // Current level
        private var p:Plr;
        private var g:P;
        private var b:Array; // Board [Mv][Mv]
        private var h:Array; // Hunters [Hntr]
        private var go:Boolean = false;
     
        public function Pie() {
            t("PIE!");
            setTimeout(t, 1000, "Esc = reset");
            setTimeout(dL, 2500);
            addEventListener("addedToStage", ash);
         
            graphics.beginFill(0x91A698); 
            graphics.drawRect(0, 0, 400, 350);
            graphics.endFill();
        }

        /**
         * Using a generic object instead of Event saves 15 bytes.
         */

        private function ash(event:Object):void {
            stage.addEventListener("keyDown", kdh);
        }

        /**
         * Init levels
         * 1 - block
         * 2 - player
         * 3 - treasure
         * 4 - hunter
         */

        private function dL():void {
            go = true;
            // Each level takes up 24-25 bytes.
            var levels:Array = [];
            var level:Array;

            // Difficulty 1 
            level = 
            [[2, 0, 0, 1, 3, 1, 0, 0],
             [0, 0, 0, 1, 0, 1, 0, 0],
             [0, 0, 0, 0, 1, 0, 0, 0],
             [0, 0, 0, 1, 0, 0, 0, 0],
             [0, 0, 0, 1, 0, 0, 0, 0],
             [0, 0, 0, 1, 1, 0, 0, 0],
             [0, 0, 0, 1, 1, 0, 0, 4]];

            levels.push(level);
            
            // Difficulty 2 
            level = 
            [[0, 0, 0, 0, 1, 3, 0, 0],
             [0, 0, 0, 0, 1, 0, 0, 0],
             [0, 0, 0, 1, 0, 0, 4, 0],
             [2, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 3
            level = 
            [[0, 1, 0, 1, 0, 1, 0, 1],
             [1, 0, 1, 0, 1, 0, 1, 0],
             [0, 1, 0, 1, 0, 1, 0, 1],
             [1, 0, 1, 0, 1, 0, 1, 0],
             [0, 1, 0, 1, 0, 1, 0, 1],
             [1, 0, 1, 0, 1, 0, 1, 3],
             [2, 1, 0, 1, 0, 1, 0, 1]];

            levels.push(level);
            
            // Difficulty 3 smiley
            level = 
            [[2, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 1, 0, 0, 1, 0, 0],
             [0, 1, 4, 0, 0, 4, 1, 0],
             [0, 0, 1, 0, 0, 1, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [0, 1, 0, 0, 3, 0, 1, 0],
             [0, 0, 1, 1, 1, 1, 0, 0]];

            levels.push(level);
            
            // Difficulty 4 frowny
            level = 
            [[0, 0, 0, 1, 0, 1, 0, 0],
             [0, 0, 1, 4, 0, 4, 1, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 0, 1, 1, 1, 0, 0],
             [0, 0, 1, 0, 0, 0, 1, 0],
             [0, 0, 1, 1, 1, 1, 1, 0],
             [3, 4, 0, 0, 0, 0, 0, 2]];

            levels.push(level);
            
            // Difficulty 4 - Columns
            level = 
            [[2, 1, 0, 1, 4, 1, 0, 0],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 1, 0, 1, 0, 1, 0, 3],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 1, 0, 1, 4, 1, 0, 0]];

            levels.push(level);
            
            // Difficulty 4
            level = 
            [[4, 4, 1, 0, 0, 0, 0, 3],
             [4, 4, 1, 0, 0, 0, 1, 0],
             [0, 0, 1, 1, 1, 1, 1, 1],
             [0, 0, 1, 0, 0, 0, 0, 0],
             [0, 0, 0, 0, 1, 0, 0, 0],
             [0, 0, 0, 0, 0, 1, 0, 0],
             [0, 0, 0, 0, 0, 0, 1, 2]];

            levels.push(level);
            
            // Difficulty 4
            level = 
            [[0, 0, 0, 0, 0, 0, 1, 1],
             [0, 0, 0, 0, 0, 1, 0, 0],
             [0, 0, 0, 0, 0, 1, 1, 0],
             [2, 0, 0, 0, 1, 0, 1, 3],
             [0, 0, 0, 0, 0, 1, 1, 0],
             [0, 0, 0, 0, 0, 0, 1, 0],
             [0, 0, 0, 0, 0, 0, 0, 1]];

            levels.push(level);
            
            // Difficulty 5

            level = 
            [[0, 0, 0, 0, 0, 0, 0, 2],
             [0, 1, 1, 1, 1, 1, 1, 1],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [1, 1, 1, 1, 1, 1, 1, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [1, 0, 1, 1, 1, 1, 1, 1],
             [0, 0, 4, 4, 4, 4, 4, 3]];

            levels.push(level);
            
            // Difficulty 5 'King's cross'

            level = 
            [[3, 0, 1, 4, 1, 0, 0, 0],
             [0, 0, 1, 0, 1, 0, 0, 0],
             [1, 1, 0, 0, 0, 1, 1, 1],
             [4, 0, 0, 0, 0, 0, 0, 2],
             [0, 1, 1, 0, 0, 1, 1, 1],
             [0, 0, 1, 0, 1, 0, 0, 0],
             [0, 0, 1, 4, 1, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 5
            level = 
            [[0, 0, 1, 0, 3, 1, 0, 0],
             [0, 1, 0, 1, 0, 0, 0, 0],
             [0, 1, 1, 0, 1, 0, 4, 0],
             [2, 0, 0, 0, 0, 1, 0, 0],
             [0, 1, 0, 0, 0, 4, 0, 0],
             [0, 0, 0, 1, 0, 0, 0, 0],
             [0, 0, 0, 0, 1, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 6
            level = 
            [[1, 0, 1, 1, 1, 1, 0, 1],
             [4, 1, 3, 0, 0, 0, 1, 4],
             [1, 0, 1, 1, 0, 1, 0, 1],
             [1, 0, 1, 1, 1, 1, 0, 1],
             [0, 1, 0, 0, 0, 0, 1, 0],
             [1, 0, 1, 1, 1, 1, 0, 1],
             [4, 0, 0, 0, 0, 0, 0, 2]];

            levels.push(level);
            
            // Difficulty 6
            level = 
            [[0, 0, 0, 0, 1, 4, 0, 3],
             [0, 0, 1, 0, 0, 4, 0, 0],
             [0, 0, 1, 1, 1, 0, 0, 0],
             [2, 0, 0, 0, 0, 0, 0, 4],
             [0, 0, 1, 1, 1, 0, 0, 0],
             [0, 0, 0, 0, 0, 4, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 6
            level = 
            [[0, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [0, 1, 0, 0, 1, 0, 2, 0],
             [0, 0, 1, 0, 1, 1, 0, 1],
             [0, 0, 1, 4, 1, 0, 0, 0],
             [0, 0, 1, 4, 1, 0, 1, 0],
             [0, 0, 1, 4, 1, 4, 3, 4]];

            levels.push(level);
            
            // Difficulty 7 - Heart
            level = 
            [[4, 0, 1, 1, 0, 1, 1, 0],
             [0, 1, 0, 0, 1, 0, 0, 1],
             [3, 1, 0, 0, 4, 0, 0, 1],
             [0, 1, 0, 0, 0, 0, 0, 1],
             [0, 0, 1, 0, 0, 0, 1, 0],
             [0, 0, 0, 1, 0, 1, 0, 0],
             [4, 0, 0, 0, 1, 0, 0, 2]];

            levels.push(level);
            
            // Difficulty 7 - NB
            level = 
            [[1, 0, 0, 1, 0, 1, 1, 0],
             [1, 1, 0, 1, 3, 1, 0, 1],
             [1, 0, 1, 1, 4, 1, 1, 0],
             [1, 0, 0, 1, 0, 1, 2, 1],
             [1, 0, 0, 1, 0, 1, 1, 0],
             [0, 0, 0, 0, 0, 0, 0, 0],
             [0, 0, 0, 0, 0, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 7
            level = 
            [[3, 4, 0, 0, 0, 0, 0, 0],
             [4, 1, 1, 1, 1, 1, 1, 0],
             [0, 1, 0, 0, 0, 0, 0, 4],
             [0, 1, 0, 0, 0, 0, 0, 0],
             [0, 1, 0, 0, 0, 0, 0, 1],
             [0, 1, 1, 1, 1, 1, 1, 0],
             [0, 0, 0, 0, 0, 0, 0, 2]];

            levels.push(level);
            
            // Difficulty 8
            level = 
            [[0, 0, 1, 3, 0, 1, 0, 0],
             [0, 0, 0, 1, 1, 0, 0, 0],
             [0, 0, 1, 0, 1, 0, 0, 0],
             [0, 1, 4, 1, 0, 1, 4, 0],
             [0, 0, 1, 0, 1, 0, 1, 0],
             [0, 0, 0, 0, 0, 1, 0, 0],
             [2, 0, 0, 0, 0, 0, 1, 0]];

            levels.push(level);
            
            // Difficulty 7
            level = 
            [[2, 0, 0, 0, 0, 0, 0, 1],
             [0, 0, 0, 0, 0, 0, 1, 0],
             [0, 0, 0, 0, 0, 1, 0, 0],
             [0, 1, 1, 1, 0, 1, 0, 0],
             [0, 0, 0, 1, 0, 1, 4, 4],
             [0, 0, 0, 1, 0, 1, 4, 4],
             [0, 0, 0, 0, 0, 1, 4, 3]];

            levels.push(level);
            
            // Difficulty 8 - :D
            level = 
            [[2, 0, 0, 0, 0, 0, 0, 0],
             [0, 1, 1, 1, 1, 1, 0, 0],
             [0, 1, 0, 0, 4, 1, 0, 1],
             [0, 1, 0, 0, 0, 1, 1, 1],
             [1, 1, 0, 0, 0, 0, 0, 1],
             [0, 0, 4, 0, 0, 0, 1, 3],
             [0, 1, 0, 0, 0, 1, 0, 1]];

            levels.push(level);
            
            // Difficulty 7
            level = 
            [[2, 0, 0, 1, 4, 1, 0, 0],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 0, 0, 0, 1, 0, 0, 0],
             [0, 0, 1, 1, 0, 1, 1, 1],
             [1, 1, 0, 1, 0, 0, 0, 0],
             [0, 1, 0, 1, 1, 1, 1, 4],
             [3, 0, 0, 1, 0, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 8 - O_o
            level = 
            [[0, 1, 0, 1, 1, 1, 2, 0],
             [0, 0, 1, 0, 0, 0, 1, 0],
             [0, 1, 0, 1, 1, 1, 0, 1],
             [0, 1, 0, 1, 0, 0, 1, 1],
             [0, 1, 0, 0, 0, 0, 0, 1],
             [0, 1, 1, 1, 1, 1, 1, 3],
             [0, 0, 0, 0, 0, 0, 4, 4]];

            levels.push(level);
            
            // Difficulty 8
            level = 
            [[0, 0, 0, 0, 0, 0, 4, 3],
             [0, 1, 1, 1, 1, 1, 1, 1],
             [0, 0, 0, 0, 0, 0, 1, 2],
             [1, 1, 1, 0, 1, 0, 1, 0],
             [0, 4, 0, 1, 0, 0, 1, 0],
             [1, 1, 1, 0, 1, 1, 1, 0],
             [0, 0, 0, 0, 0, 0, 0, 0]];

            levels.push(level);
            
            // Difficulty 9 '4K'
            level = 
            [[1, 2, 0, 0, 1, 0, 0, 0],
             [1, 0, 1, 0, 1, 0, 0, 1],
             [1, 0, 1, 0, 1, 0, 1, 0],
             [1, 1, 1, 0, 1, 1, 0, 0],
             [0, 0, 1, 0, 1, 0, 1, 0],
             [0, 0, 1, 0, 1, 0, 4, 1],
             [0, 0, 1, 0, 1, 0, 3, 1]];

            levels.push(level);
            
            // Difficulty 9
            level = 
            [[0, 1, 0, 1, 0, 1, 3, 0],
             [0, 1, 0, 1, 0, 1, 1, 0],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 1, 0, 1, 0, 1, 0, 0],
             [0, 1, 0, 0, 1, 0, 1, 1],
             [0, 1, 1, 1, 0, 1, 0, 0],
             [2, 0, 0, 1, 0, 0, 1, 4]];

            levels.push(level);
            
            // Difficulty 10
            level = 
            [[0, 0, 0, 1, 0, 0, 3, 0],
             [0, 0, 0, 1, 0, 1, 1, 1],
             [0, 0, 0, 1, 0, 0, 0, 0],
             [0, 0, 0, 0, 0, 1, 1, 4],
             [0, 1, 1, 0, 0, 0, 1, 0],
             [1, 1, 0, 0, 1, 1, 1, 0],
             [2, 1, 0, 1, 0, 0, 0, 0]];

            levels.push(level);
       
            // Fin
            level = 
            [[4, 4, 4, 0, 0, 0, 0, 0],
             [4, 0, 0, 0, 0, 0, 0, 0],
             [4, 0, 0, 3, 0, 0, 0, 0],
             [4, 4, 0, 0, 0, 4, 4, 0],
             [4, 0, 0, 4, 0, 4, 0, 4],
             [4, 0, 0, 4, 0, 4, 0, 4],
             [4, 0, 0, 4, 0, 4, 0, 2]];

            levels.push(level);
            
            //--------------------------------------
            // Draw the current level
            //--------------------------------------
           
            while (numChildren) removeChildAt(0);
           
            var currentLevel:Array = (levels[cL] as Array);
            var rows:uint = currentLevel.length;
            b = new Array(rows);
            h = [];
            
            for (var i:uint = 0; i < rows; i++) {
                var row:Array = currentLevel[i] as Array;
                var cols:uint = row.length;
                b[i] = new Array(cols);

                for (var j:uint = 0; j < cols; j++) {
                    var v:uint = row[j];
                    var cellItem:Mv = null;
                    if (v == 1) {
                        cellItem = new Block();
                    } else if (v == 2) {
                        p = new Plr();
                        cellItem = p;
                    } else if (v == 3) {
                        g = new P();
                        cellItem = g;
                    } else if (v == 4) {
                        var h1:Hntr = new Hntr();
                        cellItem = h1;
                        h.push(cellItem);
                    }

                    if (cellItem) {
                        cellItem.row = i;
                        cellItem.col = j;
                        cellItem.x = j * 50;
                        cellItem.y = i * 50;
                        addChild(cellItem);
                        b[i][j] = cellItem;
                    } else {
                        b[i][j] =  null;
                    }
                }
            }

            // Reorder the depths a bit so hunters are higher than the player, and the player is higher than the pie.

            addChildAt(g, 0);
            addChildAt(p, 1);
            
            // Ending cutscene

            if (cL == levels.length - 1) {
                go = false;
                var c:uint = 0;

                for each (var hunter:Hntr in h) {
                    setTimeout(hunter.dS, 2500);
                    setTimeout(hunter.mv, 3000, 350, 300);
                    setTimeout(hunter.mv, c * 70 + 6000, hunter.x, hunter.y);
                    c++;
                }
                setTimeout(removeChild, 4000, p);
            }
            
            // Draw bg texture
            // Not worth it -- 90 bytes
            /* var txr:Sprite = new Sprite();

            var n:BitmapData = new BitmapData(400, 350, true, 0);
            n.noise(1, 0, 20, 8);
            txr.graphics.beginBitmapFill(n, null, false, true);
            txr.graphics.drawRect(0, 0, 400, 350);
            txr.graphics.endFill();
            addChildAt(txr, 0); */
        }

         /**
         * Keyboard down handler
         * Using a generic object instead of a KeyboardEvent saves 18 bytes
         */

        private function kdh(event:Object):void {

            if (!go) return;
            var xD:int = 0;
            var yD:int = 0;

            // Using numbers here instead of constants saves about 44 bytes

            switch (event.keyCode) {
                // LEFT
                case (37) :
                    xD = -1;
                    break;

                // UP
                case (38) :
                    yD = -1;
                    break;

                // RIGHT
                case (39) :
                    xD = 1;
                    break;

                // DOWN
                case (40) :
                    yD = 1;
                    break;

                // ESCAPE
                case (27) :
                    // Redraw the level
                    dL(); 
                    break;
            }
            if (xD || yD) mv(xD, yD);
        }

         /**
         * Move player
         * @var xD - horizontal direction
         * @var yD - vertical direction
         */

        private function mv(xDir:int, yDir:int):void {

            if (!wB(p.row + yDir, p.col + xDir)) return;
            var row:Array = b[p.row + yDir];
            var cellItem:Mv = row[p.col + xDir] as Mv;

            if (cellItem is P) {
                cL++;
                setTimeout(t, 500, "L" + (cL + 1));
                setTimeout(dL, 1500);

            } else if (cellItem is Block) {
                // Move the block if you player can.
                var block:Block = cellItem as Block;
                if (!block.ml) return;
                var blockToRow:int = p.row + 2 * yDir;
                var blockToCol:int = p.col + 2 * xDir;
                if (!wB(blockToRow, blockToCol) || b[blockToRow][blockToCol] != null) return;
                mI(p.row + yDir, p.col + xDir, blockToRow, blockToCol);
                block.ml--;
            }

            mI(p.row, p.col, p.row + yDir, p.col + xDir);
            
            if (cellItem is Hntr) {
                l();
                return;
            }
            
            if (!(cellItem is P)) {
                // Move hunters if player didn't just win.
                var playerDistance:Array = []; // Player distance array
                cDP(p.row, p.col, playerDistance);
                var pieDistance:Array = []; // Pie distance array
                cDP(g.row, g.col, pieDistance);

                for each (var hunter:Hntr in h) {
                    mH(hunter, playerDistance, pieDistance);
                }
            }
        }

         /**
         * Moves an item on the board.
         */

        private function mI(fromRow:int, fromCol:int, toRow:int, toCol:int):void {
            var previousItem:Mv = b[fromRow][fromCol] as Mv;
            b[fromRow][fromCol] = null;
            b[toRow][toCol] = previousItem;
            previousItem.row = toRow;
            previousItem.col = toCol;
            previousItem.mv(50 * toCol, 50 * toRow);
        }
        
         /**
         * Calculate distance path (Single source, shortest path algorithm)
         */

        private function cDP(row:int, col:int, arr:Array):void {
            if (!arr.length) {
                // Initialize solution array
                var rows:uint = b.length;

                for (var i:uint = 0; i < rows; i++) {
                    var cols:uint = (b[i] as Array).length;
                    arr[i] = new Array(cols);

                    for (var j:uint = 0; j < cols; j++) {
                        arr[i][j] = int.MAX_VALUE;
                    }
                }
                arr[row][col] = 0;
            }
            
            var directions:Array = [[-1, 0], [0, 1], [1, 0], [0, -1]];
            var recurse:Array = []; // Which directions to recurse
            var dir:Array;
            var newRow:int;
            var newCol:int;
            var weight:int;

            for each (dir in directions) {
                newRow = row + dir[0]; // New row
                newCol = col + dir[1]; // New column
                if (!wB(newRow, newCol)) continue;
                var value:Mv = b[newRow][newCol] as Mv;

                if (!value) weight = 1;
                else if (value is Block) continue
                else if (value is P) continue
                else if (value is Hntr) weight = 2;

                if (arr[row][col] + weight < arr[newRow][newCol]) {
                    arr[newRow][newCol] = arr[row][col] + weight;
                    recurse.push(dir);
                }
            }

            for each (dir in recurse) {
                newRow = row + dir[0]; // New row
                newCol = col + dir[1]; // New column
                cDP(newRow, newCol, arr);
            }
        }

         /**
         * Move hunter towards prey
         */

        private function mH(hunter:Hntr, playerDistance:Array, pieDistance:Array):void {
            //prettyArr(playerDistance);
            // Up, Right, Down, Left
            var directionArray:Array = [[0, 0], [-1, 0], [0, 1], [1, 0], [0, -1]];
            var minValue:int = int.MAX_VALUE;
            var n:uint = 0;

            for (var ii:uint = 0; ii < 5; ii++) {
                var row:int = hunter.row + directionArray[ii][0];
                var col:int = hunter.col + directionArray[ii][1];
                if (!wB(row, col)) continue;
                var cellItem:Mv = b[row][col] as Mv;
                if (cellItem is Hntr) continue;
                var value:int = playerDistance[row][col];
                                
                if (value != -1 && value <= minValue) {
                    if (value == minValue) {
                        // Consider the distance to the pie when faced with two equal options
                        var pR:int = hunter.row + directionArray[n][0];
                        var pC:int = hunter.col + directionArray[n][1];
                        if (pieDistance[row][col] > pieDistance[pR][pC]) continue; 
                    }
                    n = ii; minValue = value;
                }
            }

            var newRow:uint = hunter.row + directionArray[n][0];
            var newCol:uint = hunter.col + directionArray[n][1];

            if (minValue == int.MAX_VALUE) return;
            mI(hunter.row, hunter.col, newRow, newCol);
            if (minValue < 4) hunter.dS();
            if (hunter.row == p.row && hunter.col == p.col) l();
        }
        
         /**
         *  Check if square is in bounds.
         */

        private function wB(row:int, col:int):Boolean {
            if (row < 0) return false; // Top wall
            if (col < 0) return false; // Left wall
            if (row >= b.length) return false; // Bottom wall
            var levelRow:Array = b[row];
            if (col == levelRow.length) return false; // Right wall
            return true;
        }

         /**
         * Lose
         */

        private function l():void {
            go = false;
            setTimeout(t, 400, "You lost");
            setTimeout(dL, 1200);
        }

        private function t(s:String):void {
            while (numChildren) removeChildAt(0);
            var tf:TextField = new TextField();
            addChild(tf);            
            tf.text = s;
            tf.autoSize = "left";
            var fmt:TextFormat = new TextFormat();
            fmt.font = "Arial";
            fmt.size = 36;
            fmt.color = 0xFFFFFF;
            tf.setTextFormat(fmt);
            tf.x = 400 / 2 - tf.width / 2;
            tf.y = 350 / 2 - tf.height / 2;
        }

        // This is for debugging - prints out a multi-dim array nicely
            /* private function prettyArr(arr:Array):void {
             trace("");
            for (var i:uint = 0 ; i < arr.length; i++) {
                var str:String = "";
                for (var j:uint = 0 ; j < arr[i].length; j++) {
                    var v:* = arr[i][j];
                    if (v == -1 || v == null) {
                        str += "-- ";
                    } else if (v is Mv) {
                        if (v is Block) {
                            str += "01 ";
                        } else if (v is Plr) {
                            str += "02 ";
                        } else if (v is P) {
                            str += "03 ";
                        } else if (v is Hntr) {
                            str += "04 ";
                        }
                    } else {
                        if (v == null || v >= 100) {
                            str += "== ";
                        } else if (v < 10) {
                            str += "0" + v + " ";
                        } else {
                            str += v + " ";
                        }
                    }
                }
                trace(str);
            }  
        }*/
    }
} //end

import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.filters.BevelFilter;

class Mv extends Sprite {
    private var x2:Number;
    private var y2:Number;
    public var row:uint;
    public var col:uint;
    
    public function Mv() {
        super();
    }

    public function mv(x2:Number, y2:Number):void {
        this.x2 = x2;
        this.y2 = y2;
        addEventListener("enterFrame", efh, false, 0, true);
    }

    private function efh(event:Object):void {
        if (x2 == x && y2 == y) {
            return;
            removeEventListener("enterFrame", efh);
        }
        x += cl(x2 - x, -15, 15);
        y += cl(y2 - y, -15, 15);
    }

    /* Clamp */
    private function cl(n:Number, min:Number, max:Number):Number {
        if (n < min) return min;
        if (n > max) return max;
        return n;
    }
}

class P extends Mv {

    public function P() {
        super();
        // Gradient fill is expensive: 40 bytes
        graphics.lineStyle(1, 0xCC3333);
        graphics.beginGradientFill("radial", [0xFEF1D6, 0xE09E05], [1, 1], [0, 0x88]);
        graphics.drawCircle(50 / 2, 50 / 2, 50 * .4);
        graphics.endFill();
        
        graphics.lineStyle(1, 0xCC3333, .4);
        graphics.moveTo(50 * .4, 50 * .4);
        graphics.lineTo(50 * .3, 50 * .3);
        graphics.moveTo(50 * .35, 50 * .5);
        graphics.lineTo(50 * .25, 50 * .5);
        graphics.moveTo(50 * .4, 50 * .6);
        graphics.lineTo(50 * .3, 50 * .7);
        graphics.moveTo(50 * .6, 50 * .4);
        graphics.lineTo(50 * .7, 50 * .3);
        graphics.moveTo(50 * .65, 50 * .5);
        graphics.lineTo(50 * .75, 50 * .5);
        graphics.moveTo(50 * .6, 50 * .6);
        graphics.lineTo(50 * .7, 50 * .7);
        
        var dsf:DropShadowFilter = new DropShadowFilter();
        dsf.strength = .3; // 11 bytes if already used number, 16 bytes otherwise
        filters = [dsf];
    }
}

class Hntr extends Mv {

    private var sD:Boolean = false; // Spikes deployed
    
    public function Hntr() {
        graphics.beginFill(0xCC0000);
        graphics.drawCircle(50 / 2, 50 / 2, 50 / 3);
        graphics.endFill();
       
        var dsf:BevelFilter = new BevelFilter();
        dsf.strength = .3; // 11 bytes if already used number, 16 bytes otherwise
        filters = [dsf];
    }

    // Deploy spikes

    public function dS():void {
        if (sD) return;
        sD = true;

        graphics.clear();
        graphics.beginFill(0xCC0000);
        graphics.drawCircle(50 / 2, 50 / 2, 50 / 4);
        
        // Left spike

        graphics.moveTo(50 / 4, 50 * .4);
        graphics.lineTo(0, 50 / 2);
        graphics.lineTo(50 / 4, 50 * .6);

        // Top spike

        graphics.moveTo(50 * .4, 50 / 4);
        graphics.lineTo(50 / 2, 0);
        graphics.lineTo(50 * .6, 50 / 4);

        // Right spike

        graphics.moveTo(50 * .75, 50 * .4);
        graphics.lineTo(50, 50 / 2);
        graphics.lineTo(50 * .75, 50 * .6);

        // Bottom spike

        graphics.moveTo(50 * .4, 50 * .75);
        graphics.lineTo(50 / 2, 50 - 2);
        graphics.lineTo(50 * .6, 50 * .75);
        graphics.endFill();
    }
}

class Block extends Mv {
    // Moves left
    private var _ml:uint;
    protected var tM:uint = 1;

    public function Block() {
        ml = tM;
    }

    public function get ml():uint {
        return _ml;
    }

    public function set ml(v:uint):void {
        _ml = v;
        graphics.clear();
        var i:Number = int(50 * (.1 + .1 * v / tM));

        // Top

        graphics.beginFill(0x505050);
        graphics.lineTo(i, i);
        graphics.lineTo(50 - i, i);
        graphics.lineTo(50, 0);
        graphics.lineTo(0, 0);
        graphics.endFill();

        // Left

        graphics.beginFill(0x444444);
        graphics.lineTo(i, i);
        graphics.lineTo(i, 50 - i);
        graphics.lineTo(0, 50);
        graphics.lineTo(0, 0);
        graphics.endFill();

        // Right

        graphics.beginFill(0x222222);
        graphics.moveTo(50, 50);
        graphics.lineTo(50, 0);
        graphics.lineTo(50 - i, i);
        graphics.lineTo(50 - i, 50 - i);
        graphics.lineTo(50, 50);
        graphics.endFill();

        // Bottom

        graphics.beginFill(0);
        graphics.lineTo(0, 50);
        graphics.lineTo(i, 50 - i);
        graphics.lineTo(50 - i, 50 - i);
        graphics.lineTo(50, 50);
        graphics.endFill();

        graphics.beginFill(0x333333);
        graphics.drawRect(i, i, 50 - i * 2, 50 - i * 2);
        graphics.endFill(); // new
        //graphics.beginFill(0x333333);


        var dsf:DropShadowFilter = new DropShadowFilter();
        dsf.strength = .3; // 11 bytes if already used number, 16 bytes otherwise
        dsf.blurX = 50 * .3;
        dsf.blurY = 50 * .3;
        filters = [dsf];
    }
}

class Plr extends Mv {
    public function Plr() {
        super();

        graphics.beginFill(0x008800, 1);
        graphics.drawCircle(50 / 2, 50 / 2, 50 * .4);
        graphics.endFill();

        var dsf:BevelFilter = new BevelFilter();
        dsf.strength = .3; // 11 bytes if already used number, 16 bytes otherwise
        filters = [dsf];
    }
}
//end 