/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eUyA
 */

/*
      _                           _             
     | |                         (_)            
     | | __ _ _ __ ___   __ _ ___ _  __ _ _ __  
 _   | |/ _` | '_ ` _ \ / _` / __| |/ _` | '_ \ 
| |__| | (_| | | | | | | (_| \__ \ | (_| | | | |
 \____/ \__,_|_| |_| |_|\__,_|___/_|\__,_|_| |_|

Copyright 2010, Kaiyi Chan
*/
package
{
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    
    import flash.events.*;
    import flash.display.*;

    import flash.geom.Point;
    import flash.geom.Rectangle;


public class pixel extends Sprite
{
    /*----------  VARIABLES  ----------*/
    public var bmd:BitmapData;
    public var bm:Bitmap;
    public var debug:TextField;
    public var MOUSEDOWN:Boolean=false;
    
    public var getPixel:Array=new Array();
    public var COLOR:uint    =    Math.random()*0xCCCCCC;
    
    public var loaderA:Loader;
    public var loaderB:Loader;
    public var URL:String;
    
    public var centerX:Number=465/2;
    public var centerY:Number=465/2;

    public var rotateOn:Boolean=false;
    
    public function pixel()
    {
        debug      =    mainframe();
        
        URL        =    "http://www.sydneyobservatory.com.au/blog/wp-content/uploads/2007/06/milky-way-map_atlas-of-the-universe.jpg";
        
        //onManualRun();
        onAutoRun();
    }
    
    private function onManualRun():void
    {
        bmd    =    new BitmapData(465, 465-75, false, 0);
        bm     =    new Bitmap(bmd);
        addChild(bm);
        onRun();
    }

    private function onAutoRun():void
    {
        loaderA = new Loader();
        loaderA.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
        loaderA.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, function():void { debug.text="ERROR HAS OCCURED."; } );
        loaderA.load(new URLRequest(URL), new LoaderContext(true));
    }

    
    private function initHandler(event:Event):void
    {    
        loaderB = new Loader();
        loaderB.contentLoaderInfo.addEventListener(Event.INIT, init);
        loaderB.loadBytes(loaderA.contentLoaderInfo.bytes);
    }
    
    private function init(event:Event):void
    {
        var loader:Loader = event.currentTarget.loader;
        
        bmd = new BitmapData(465, 465-75, false, 0x0);
        
        var matrix:Matrix = new Matrix();
        matrix.scale((200/loader.width), ((200)/loader.height));
        matrix.tx=bmd.width/4;
        matrix.ty=bmd.height/4;
        bmd.draw(loader, matrix);
        
        centerX=bmd.width/2.2;
        centerY=bmd.height/2;
        
        if (bm) removeChild(bm);
        bm = new Bitmap(bmd);
        addChild(bm);
        
        loaderA.contentLoaderInfo.removeEventListener(Event.INIT, initHandler);
        loaderB.contentLoaderInfo.removeEventListener(Event.INIT, init);
        onRun();
    }
    
    
    public function onRun():void
    {
        stage.addEventListener(Event.ENTER_FRAME, update);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void {if(e.keyCode==32) { COLOR = Math.random()*0xCCCCCC}});
        stage.addEventListener(MouseEvent.MOUSE_DOWN,  function():void{MOUSEDOWN=true;});
        stage.addEventListener(MouseEvent.MOUSE_UP,    function():void{MOUSEDOWN=false;});
    }

    private function update(e:Event):void
    {
        debug.text    =    "count dots: " + countDots() +"\n"+"colorMode: "+COLOR+"\ncenterX:"+centerX+" centerY: "+centerY;
        if (MOUSEDOWN) { bmd.fillRect(new Rectangle(mouseX-10, mouseY-10, 20, 20),COLOR); }
        
        var amount:int    =    countDots();
        if (amount > 20000) {
            var rx:Number; var ry:Number; var ru:Number;
            
            while (amount>20000)
            {
                rx=Math.random()*stage.width;
                ry=Math.random()*stage.width;
                
                ru=bmd.getPixel(rx, ry);
                if (ru != 0 && ru <=0x300000) {
                    bmd.setPixel(rx, ry, 0);
                    amount--;
                }
            }
        }
        
        if (mouseX > 0 && mouseY > 0)
        {
            centerX=mouseX;
            centerY=mouseY;
        }

        
        if (rotateOn)
        {
            if (Math.random()>.1) rotate(bm, 1, centerX, centerY);
        }
        
        bmd.lock();
        for (var x:int=stage.width; x>=0; x--)
        {
            for (var y:int=stage.height; y>=0; y--)
            {
                if (this.bmd.getPixel(x, y) > 0x300000)
                {
                var posX:Number=x;
                var posY:Number=y;
                
                var rnd:Number = (Math.random()>.5)? Math.random() : -Math.random();
                var vecX:Number = (posX - centerX);
                var vecY:Number = (posY - centerY);
                var r:Number = Math.sqrt( vecX * vecX + vecY * vecY );
                var angle:Number = Math.atan2( vecY, vecX ) * 180 / Math.PI;
                var vecX2:Number = Math.cos( (angle + 2) * Math.PI / 180 ) * r;
                var vecY2:Number = Math.sin( (angle + 2) * Math.PI / 180 ) * r;
                var getX:Number; var getY:Number;
                
                vecX = (vecX2 - vecX);
                vecY = (vecY2 - vecY);
                r = Math.sqrt( vecX * vecX + vecY * vecY );
                
                vecX /= r;
                vecY /= r;
                
                
                posX += (vecX * 1.7 + rnd*2);
                posY += (vecY * 1.7 + rnd*2);
                
                getX=posX; getY=posY;
                
                if (getX > 1 && getY > 1 && getX < stage.width-1 && getY < stage.height-1)
                {
                    if (bmd.getPixel(getX, getY) == 0)
                    {
                        bmd.setPixel(getX, getY, bmd.getPixel(x, y));
                        bmd.setPixel(x, y, 0);
                    }
                }
                }
                
                /*
                //if (bmd.getPixel(x, y) != COLOR) bmd.setPixel(x, y, COLOR);

                var pwr:int = 2;
                var dir:int  = (Math.atan2(mouseY-y, mouseX-x)*180/Math.PI);// + 95;
                
                var angle:int= dir*Math.PI/180;
                var getX:int = x- Math.cos(angle)*pwr;
                var getY:int = y- Math.sin(angle)*pwr;
                
                //getX += (Math.random() > .5)? (Math.random()*pwr) : -(Math.random()*pwr);
                //getY += (Math.random() > .5)? (Math.random()*pwr) : -(Math.random()*pwr);
                getX+=Math.random()*pwr;
                getY+=Math.random()*pwr;
                
                if (getX > 1 && getY > 1 && getX < stage.width-1 && getY < stage.height-1)
                {
                    if (bmd.getPixel(getX, getY) == 0)
                    {
                        bmd.setPixel(getX, getY, bmd.getPixel(x, y));
                        bmd.setPixel(x, y, 0);
                    }
                }
                */
            }
        }
        bmd.unlock();
    }
    
    public function rotate(ob:*, angleDegrees:int, x:int, y:int):void
    {
        var m:Matrix=ob.transform.matrix;
        
        m.tx -= x;
        m.ty -= y;
        m.rotate (angleDegrees*(Math.PI/180));

        m.tx += x;
        m.ty += y;
        ob.transform.matrix=m;
    }
    
    private function countDots():int
    {
        var value:int;
        
        for (var x:int=0; x<=this.bmd.width; x++)
        {
            for (var y:int=this.bmd.height-1; y>=0;--y)
            {
                if (this.bmd.getPixel(x, y) != 0x0)
                {
                    value+=1;
                }
            }
        }
        
        return value;
    }
    
    private function mainframe():TextField
    {
        /*
        creates a textfield for debugging (mainframe).
        */
        var mainframe:TextField = new TextField();
        mainframe.x           =    0;
        mainframe.y           =    390;
        mainframe.width       =    stage.stageWidth;
        mainframe.height      =    75;
        mainframe.textColor   =    0xFFFFFF;
        
        mainframe.background  =    true;
        mainframe.backgroundColor = 0x111111;
        mainframe.borderColor=0xFFFFFF;
        mainframe.border=true;
        mainframe.mouseEnabled=false;
        addChild(mainframe);
        
        return mainframe;
    }
    
    private function _random(_int:int=1):int { return (Math.random()>=.5)? Math.random()*_int : Math.random()*-_int; }
}
}
