/**
 * Copyright cohakim ( http://wonderfl.net/user/cohakim )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eUqY
 */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.geom.Matrix;
  
  [SWF(backgroundColor=0x000000, frameRate=24, width=480, height=400)]
      
  public class Comet extends MovieClip {
    // -------------------------------------------------------------------------
    //  literals
    // -------------------------------------------------------------------------

    public static const RADIUS:uint       = 3;
    public static const DIAMETER:uint     = RADIUS * 2;
    public static const FILL_COLOR:uint   = 0xFFCCFF;
    public static const DIV_Y:uint        = 4;
    
    // -------------------------------------------------------------------------
    //  game state
    // -------------------------------------------------------------------------

    // -------------------------------------------------------------------------
    //  instance variables
    // -------------------------------------------------------------------------

    public static var _instance:Comet;

    var symbol:Sprite = new Sprite();  // 自機
    var particles:Array = new Array(); // 自機パーティクル
    
    // -------------------------------------------------------------------------
    //  constructor
    // -------------------------------------------------------------------------
    
    public function Comet() {
      super();
      _instance = this;
      
      // add event listeners ---------------------------------------------------
      addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
      addEventListener(Event.REMOVED_FROM_STAGE, onRemovedFromStage);
    }

    public static function getInstance() {
      return _instance;
    }
    
    // -------------------------------------------------------------------------
    //  event listeners
    // -------------------------------------------------------------------------
    
    private function onAddedToStage(e:Event) {
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
      initializeComet();
      initializeParticle();
    }
    
    private function onEnterFrame(e:Event) {
      moveComet();
      drawParticle();
    }
    
    private function onRemovedFromStage(e:Event) {
      removeEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    // -------------------------------------------------------------------------
    //  draw methods
    // -------------------------------------------------------------------------
    
    //
    // 自機を初期描画
    //
    private function initializeComet() {
      symbol.x = stage.mouseX;
      symbol.y = stage.stageHeight - (stage.stageHeight / DIV_Y);
      symbol.graphics.beginFill(FILL_COLOR);
      symbol.graphics.drawCircle(0, 0, RADIUS);
      symbol.graphics.endFill();
      addChild(symbol);
    }
    
    //
    // 自機の位置を更新する
    //
    private function moveComet() {
      symbol.x = stage.mouseX - DIAMETER;
    }

    //
    // パーティクルを初期描画
    //
    private function initializeParticle() {
      for (var i:int = 0; i <= (stage.stageHeight / 4) / RADIUS; i++) {
        var p:Sprite = new Sprite();
        p.x = symbol.x;
        p.y = symbol.y + (i * DIAMETER);
        p.graphics.beginFill(FILL_COLOR);
        p.graphics.drawCircle(0, 0, RADIUS);
        p.graphics.endFill();
        particles.push(p);
        addChild(p);
      }
    }
    
    //
    // パーティクルの位置を更新し、不要になったパーティクルを削除
    //
    private function drawParticle() {
      // パーティクルの位置を更新
      particles.forEach(function (p:*, index:int, array:Array) {
        p.y += DIAMETER;
        p.graphics.beginFill(FILL_COLOR);
        p.graphics.lineStyle(1, Math.random() * 0xFFFFFF);
        p.graphics.drawCircle(0, 0, RADIUS);
        p.graphics.endFill();
      });
      
      // 不要なパーティクルを削除
      var g:Sprite = particles.pop();
      removeChild(g);
      
      // 自機の位置に新しいパーティクルを描画
      var p:Sprite = new Sprite();
      p.x = symbol.x;
      p.y = symbol.y;
      p.graphics.beginFill(FILL_COLOR);
      p.graphics.lineStyle(1, Math.random() * 0xFFFFFF);
      p.graphics.drawCircle(0, 0, RADIUS);
      p.graphics.endFill();
      particles.unshift(p);
      addChild(p);
    }
  }
}
