/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eUaY
 */



// forked from voidbox's flash on 2010-9-2


package {
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.filters.GlowFilter;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="0x000000")]  //  frameRate="100", width="465", height="465"
    
    public class FlashTest extends Sprite {

        //  const variable  
        private const W : Number    =  465;
        private const H : Number    =  465;
        private const R : Number    =  1.0;

        //  member variable
        private var m_Sprite            : Sprite           = null;
        private var m_ColorTransform    : ColorTransform   = null;
        private var m_BitmapData        : BitmapData       = null;
        private var m_Glow              : BitmapData       = null;
        private var m_Lights            : Vector.<Light>   = null;

        //  constructor
        public function FlashTest() {

            Initialize();

            addEventListener( Event.ENTER_FRAME, OnEnterFrame );
        }

        //  Initialize func
        private function Initialize():void {

            //  Initialize member variable
            m_Sprite            =   new Sprite();
            m_Sprite.filters    = [ new BlurFilter( 8, 8, 2 ) ];
 //           m_Sprite.filters    = [ new GlowFilter( 0xcccccc, 1, 10, 10, 4, 3, false, false ) ];
            m_ColorTransform    = new ColorTransform( 0.99, 0.99, 0.99, 0.9 );
            m_BitmapData        = new BitmapData( W, H, false, 0x000000 );
            m_Lights            = new Vector.<Light>();
            var light:Light = new Light();
            light.m_Color = 0x131413;            
            m_Lights.push( light );

            //  Add Child
            var bm:Bitmap = new Bitmap( m_BitmapData, "auto", true );
            addChild( bm );
            
            m_Glow              = new BitmapData( W/R, H/R, false, 0x000000 );
            var gbm:Bitmap = new Bitmap( m_Glow, "never", true );
            gbm.blendMode = "add";
            gbm.scaleX = gbm.scaleY = R;
            addChild( gbm );
        }

        //  Update func
        private function OnEnterFrame(e:Event):void {

            var i:int = 0;

            //  Update
            for( i=0; i<m_Lights.length; ++i ) {

                m_Lights[i].Update( W, H );
            }

            //  Render
            m_Sprite.graphics.clear();

            for( i=0; i<m_Lights.length; ++i ) {

                m_Lights[i].Render( m_Sprite );
            }

            m_BitmapData.colorTransform( m_BitmapData.rect, m_ColorTransform );
            m_BitmapData.draw( m_Sprite );
            
            m_Glow.draw( m_BitmapData, new Matrix( 1.0/R, 0.0, 0.0, 1.0/R ) );
        }

    }
}
import flash.display.Sprite;

class Light {

    private var m_TargetAngle:Number = 0.0;
    public var m_Angle:Number  = 0.0;
    public var m_Color:uint    = 0x000000;  //0xFFFFFF;
    public var m_LightPoints:Vector.<LightPoint> = new Vector.<LightPoint>();
    public function Update( W:Number, H:Number ):void {

            if( Math.abs( m_TargetAngle - m_Angle ) < 0.1 ) {
                
                m_TargetAngle = Math.random() * Math.PI * 2.0;                
            }            

            //  Update Angle
            var addAngle:Number        = ( m_TargetAngle - m_Angle ) * 0.05;            
            var divideCount:Number     = Math.abs(addAngle) * 1000 + 1;
            var addAngleDelta:Number   = addAngle / divideCount;

            //  Add Light
            for( var j:int=0; j<divideCount; ++j ) {

                m_Angle += addAngleDelta;
                var newLight:LightPoint = new LightPoint();
                newLight.px = W * 0.5;
                newLight.py = H * 0.5;
                newLight.dx = Math.sin( m_Angle );
                newLight.dy = Math.cos( m_Angle );
                m_LightPoints.push( newLight );
            }
            if( m_Angle <           0.0 ) m_Angle += Math.PI * 2.0;
            if( m_Angle > Math.PI * 2.0 ) m_Angle -= Math.PI * 2.0;

            //  Update LightPoints
            for( var i:int=0; i<m_LightPoints.length; ) {

                var light:LightPoint = m_LightPoints[i];

                light.px += light.dx;
                light.py += light.dy;
                light.alpha -= 0.003;

                if( ( 0.0 < light.px && light.px < W &&
                      0.0 < light.py && light.py < H )
                    || ( i != 0 ) ) {

                    ++i;
                }
                else if( i == 0 ) {
                    
                    m_LightPoints.splice( i, 1 );
                }                
            }
    }
    public function Render( sp:Sprite ):void {

        if( m_LightPoints.length == 0 ) {
            
            return;
        }

        sp.graphics.moveTo( m_LightPoints[0].px, m_LightPoints[0].py );
        for( var i:int=1; i<m_LightPoints.length; ++i ) {            

            var light:LightPoint = m_LightPoints[i];

            sp.graphics.lineStyle( 1.0, m_Color, light.alpha );
            sp.graphics.lineTo( light.px, light.py );
        }
    }
}


class LightPoint {

    public var px    : Number     = 0.0;
    public var py    : Number     = 0.0;
    public var dx    : Number     = 0.0;
    public var dy    : Number     = 0.0;
    public var alpha : Number     = 1.0;
}
