/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eUJr
 */

package {
    import flash.filters.BevelFilter;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    [SWF(frameRate='60')]
    
    public class FlashTest extends Sprite {
        protected var joints:Vector.<Joint> = new Vector.<Joint>();
        protected var biyon:Vector.<Joint> = new Vector.<Joint>();
        protected var fric:Number = 0.01;
        protected var spring:Number = 0.995;
        protected var range:int = 10;
        protected static const LENGTH:int = 150;
        
        public function FlashTest() {
            if(this.stage) this.init();
            else this.addEventListener(Event.ADDED_TO_STAGE, this.init);                
        }
        
        protected function init(event:Event = null):void
        {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.create();
            this.filters = [new BevelFilter(4, 45, 0xDDDDDD, 1, 0x999999, 1, 20, 20, 5)];
            this.addEventListener(Event.ENTER_FRAME, this.enterFrameHandler);
        }
        
        protected function create():void
        {
            for(var i:int=0; i<LENGTH; i++)
            {
                var j:Joint = new Joint();
                var b:Joint = new Joint();
                j.y = i*2;
                this.joints.push(j);
                this.biyon.push(b);
            }
        }
        
        private function enterFrameHandler(event:Event):void
        {
            this.graphics.clear();
            this.calc();
            this.move();
            this.moveBiyon();
            this.drawBiyon();
        }
        
        private function calc():void
        {
            var l:int = this.joints.length;
            for(var i:int=0; i<l; i++)
            {
                if(i == 0)
                {
                    this.joints[0].x = this.stage.mouseX;
                    this.joints[0].y = this.stage.mouseY;
                    continue;
                }
                var b:int = this.range;
                var a:int = this.range;
                var now:Joint = this.joints[i];
                
                for(var j:int=i-b; j<i+a+1; j++)
                {
                    if(j >= 0 && l > j && j != i)
                    {
                        var t:Joint = this.joints[j];
                        
                        var angle:Number = Math.atan2(now.y-t.y, now.x-t.x);
                        now.sx -= Math.cos(angle) * 0.1;
                        now.sy -= Math.sin(angle) * 0.1;
                    }
                }
            }
        }
        
        private function move():void
        {
            var l:int = this.joints.length;
            for(var i:int=0; i<l; i++)
            {
                var now:Joint = this.joints[i];
                if(i!=0)now.sy += 1;
                now.x += now.sx * this.fric;
                now.y += now.sy * this.fric;
                
                if(i == 0 ) continue;
                var b:Joint = this.joints[i-1];
                var angle:Number = Math.atan2(b.y - now.y, b.x - now.x);
                now.x = b.x - Math.cos(angle) * 3;
                now.y = b.y - Math.sin(angle) * 3;
                
                now.sx *= this.spring;
                now.sy *= this.spring;
            }
        }
        
        private function moveBiyon():void
        {
            var l:int = this.joints.length;
            for(var i:int = 0; i < l; i++)
            {
                var j:Joint = this.joints[i];
                var b:Joint = this.biyon[i];
                b.sx *= 0.8;
                b.sy *= 0.8;
                b.sx += (j.x - b.x) * 0.2;
                b.sy += (j.y - b.y) * 0.2;
                b.x += b.sx;
                b.y += b.sy;
            }
        }
        
        private function draw():void
        {
            var g:Graphics = this.graphics;
            var l:int = this.joints.length;
            for(var i:int=0; i<l; i++)
            {
                g.beginFill(0);
                g.drawCircle(this.joints[i].x, this.joints[i].y, 1);
                g.endFill();
            }
        }
        
        private function drawBiyon():void
        {
            var g:Graphics = this.graphics;
            var l:int = this.biyon.length;
            
            for(var i:int=0; i<l; i++)
            {
                g.beginFill(0);
                g.drawCircle(this.biyon[i].x, this.biyon[i].y, Math.min(Math.abs(this.biyon[i].sx) + Math.abs(this.biyon[i].sy) + 0.5, 60));
                g.endFill();
            }
        }
    }
}

class Joint
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var sx:Number = 0;
    public var sy:Number = 0;
}
