/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eUFI
 */

// forked from NewKrok's Pixas object from character
// forked from 0954321982's forked from: pixas.math.Coord3D()
// forked from bradsedito's pixas.math.Coord3D()





package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.ui.*;
    import com.risonhuang.pixas.math.Coord3D;
    import com.risonhuang.pixas.math.ColorPattern;
    import com.risonhuang.pixas.colors.CubeColor;
    import com.risonhuang.pixas.dimensions.CubeDms;
    import com.risonhuang.pixas.objects.primitives.Cube;
    import com.risonhuang.pixas.objects.PixelObject;
    
    public class PixasTest3D extends Sprite
    {
        private var po_out:PixelObject = new PixelObject();
        
        
        private function characterToVector ( $char:String, $color:uint ) :Vector.<Vector.<uint>> {
            var v:Vector.<Vector.<uint>> = new Vector.<Vector.<uint>>
            switch ( $char ) {
                case "F":
                case "f":
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, 0,      0] );
                    break;
                case "L":
                case "l":
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, $color, $color] );
                    break;
                case "A":
                case "a":
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [$color, 0,      $color] );
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [$color, 0,      $color] );
                    v.push ( new <uint> [$color, 0,      $color] );
                    break;
                case "S":
                case "s":
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [$color, 0,      0] );
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [0,      0,      $color] );
                    v.push ( new <uint> [$color, $color, $color] );
                    break;
                case "H":
                case "h":
                    v.push ( new <uint> [$color, 0,      $color] );
                    v.push ( new <uint> [$color, 0,      $color] );
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [$color, 0,      $color] );
                    v.push ( new <uint> [$color, 0,      $color] );
                    break;
                case "+":
                    v.push ( new <uint> [0,      0,      0] );
                    v.push ( new <uint> [0,      $color, 0] );
                    v.push ( new <uint> [$color, $color, $color] );
                    v.push ( new <uint> [0,      $color, 0] );
                    v.push ( new <uint> [0,      0,      0] );
                    break;
                case " ":
                    v.push ( new <uint> [0] );
                    v.push ( new <uint> [0] );
                    v.push ( new <uint> [0] );
                    v.push ( new <uint> [0] );
                    v.push ( new <uint> [0] );
                    break;
            }
            return v;
        }
        
        private function concat ( ...vectors:Array ) :Vector.<Vector.<uint>> {
            for ( var k:uint = 1; k < vectors.length; k++ ) {
                for ( var i:uint = 0; i < vectors[k].length; i++ ) {
                    for ( var j:uint = 0; j < vectors[k][i].length; j++ ) {   
                        vectors[0][i].push ( vectors[k][i][j] )
                    }
                }
            }
            return vectors[0];
        }
    
        public function PixasTest3D()
        {
            stage.frameRate = 60;
            //ENTRY POINT: 

            po_out.x = 100;
            po_out.y = 120;
            addChild(po_out);
            
            for (  var i:int = -2; i < 4; i ++ ) {
                drawPixels ( i * 100, i * 100, 0, concat (
                    characterToVector ( "F", 0x0099CC ),
                    characterToVector ( " ", 0x0099CC ),
                    characterToVector ( "L", 0x0099CC ),
                    characterToVector ( " ", 0x0099CC ),
                    characterToVector ( "A", 0x0099CC ),
                    characterToVector ( " ", 0x0099CC ),
                    characterToVector ( "S", 0x0099CC ),
                    characterToVector ( " ", 0x0099CC ),
                    characterToVector ( "H", 0x0099CC ),
                    characterToVector ( " ", 0x0099CC ),
                    characterToVector ( "+", 0xFF3333 ),
                    characterToVector ( " ", 0x0099CC ),
                    characterToVector ( "+", 0xFF3333 )
                ) ); 
            }               
        }

        private var vec3D:Vector.<uint> = new <uint> [ 12, 12, 12 ];
        private var offset:Number = 0;
        public function drawPixels ( $x:Number, $y:Number, $z:Number, v:Vector.<Vector.<uint>> ) :void {
            for (var i:uint = 0; i < v.length; i++ )
            {                
                for (var j:uint = 0; j < v[i].length; j++ )
                {
                    if (  v[i][j] != 0 ) {
                        for (var k:uint = 0; k < 2; k++ )
                        {
                            var c3d:Coord3D = new Coord3D( 
                                ( $x + ( vec3D[0] + offset )*j ), 
                                ( $y + ( vec3D[1] + offset )*i ), 
                                ( $z + ( vec3D[2] + offset )*k ) );                        
                            var cubeDms:CubeDms = new CubeDms( vec3D[0],vec3D[1],vec3D[2] );
                            var cubeColor:CubeColor = CubeColor.getByHorizontalColor( v[i][j] );
                            var cube:Cube = new Cube( cubeDms,cubeColor,false );        
                            var po_tmp:PixelObject = new PixelObject( cube,c3d );
                            po_out.addChild( po_tmp );
                        }
                    }
                }                
            }
        }


    }
}
    

