/**
 * Copyright dizgid ( http://wonderfl.net/user/dizgid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eSV7
 */

/**
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#interpolate()
*/
package {
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.*;
    import flash.events.Event;

    public class InterpolateToExample extends MovieClip {
        private var ellipse1:Shape = new Shape();
        private var ellipse2:Shape = new Shape();

        public function InterpolateToExample():void {

            ellipse1 = myEllipses(250, 100, 500, 0xFF0000);
            addChild(ellipse1);
            
            ellipse2 = myEllipses(-30, 120, 1, 0x00FF00);
            addChild(ellipse2);

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }

        private function myEllipses(x:Number, y:Number, z:Number, c:Number):Shape {
            var s:Shape = new Shape();                            
            s.x = x;
            s.y = y;
            s.z = z;
            s.graphics.beginFill(c);
            s.graphics.lineStyle(2);
            s.graphics.drawEllipse(100, 50, 100, 80);
            s.graphics.endFill();
            return s;
        }

        private function enterFrameHandler(e:Event):void {
            ellipse1.rotationY += 1;

            ellipse2.transform.matrix3D.interpolateTo(ellipse1.transform.matrix3D, 0.1);
        }
    }
}