/**
 * Copyright kamip ( http://wonderfl.net/user/kamip )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eSBK
 */

package 
{
	/**
	 * 渦を巻いて回る星（Sprite）@wonderfl
	 * http://d.hatena.ne.jp/kamip/
	 * _sizeが大きさで_diffが星のとがり具合
	 */
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.text.TextField;
	
	/**
	 * ...
	 * @author kamip
	 */
	public class Star extends Sprite 
	{
		private var s:Sprite = new Sprite();
		private var _size:Number = 10;
		private var _diff:Number = 10;
		
		private var _degree:Number = 0;
		private var _radius:Number = 1;
		private var _num:int = 1;
        private var _center_x:Number = stage.stageWidth / 2; 
        private var _center_y:Number = stage.stageHeight / 2; 
		
		public function Star() {
			s = make_star_sprite(make_star_point(_size, _diff));
			stage.addChild(s);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		public function onEnterFrame(e:Event):void {
			//s.rotation += 1;
			var _radian:Number = Math.PI / 180 * _degree;
			s.x = _radius * Math.cos(_radian) + _center_x;
			s.y = _radius * Math.sin(_radian) + _center_y; 
			_degree += 5;
			
			if ( s.x > stage.stageWidth || s.y > stage.stageHeight) {
				_num = -1;
			}
			if ( s.x == stage.stageWidth / 2 && s.y == stage.stageHeight / 2 ) {
				_num = 1;
			}
			_radius = _radius + _num;
			s.rotation -= 7;
		}
		
		public function make_star_point(size:Number, diff:Number):Array {
			var pt:Point = new Point();
			var flg:Number = 0;
			var points_x:Array = new Array();
			var points_y:Array = new Array();
			var results:Array  = new Array();
			var text:String;
			while (flg < 2) {
				for (var i:int = 1; i < 6; i++) {
					var r:Number;
					if (flg == 0) {
						r = 72 * i;
						text = "s"
					}else {
						r = 72 * i + 36;
						text = "b";
					}
					var ang:Number = r * Math.PI / 180;
					pt = Point.polar(size, ang); 
					pt.offset(0, 0);
					points_x.push(pt.x);
					points_y.push(pt.y);
				}
				size = size + diff;
				flg = flg + 1;
			}
			results.push(points_x);
			results.push(points_y);
			return results;
		}
		
		public function make_star_sprite(results:Array):Sprite {
			var gr:Sprite   = new Sprite();
			var px:Array = results[0];
			var py:Array = results[1];
			gr.graphics.lineStyle(1, 0x80FF00);
			gr.graphics.beginFill(0x80FF00, 1);
			gr.graphics.moveTo(px[0], py[0]);
			for (var i:int = 0; i < 5; i++) {
				var ii:int = i + 5;
				gr.graphics.lineTo(px[i], py[i]);
				gr.graphics.lineTo(px[ii], py[ii]);
			}
			gr.graphics.endFill();
			addChild(gr);
			gr.rotation = 16;
			return gr;
		}
	}
	
}

