/**
 * Copyright selflash ( http://wonderfl.net/user/selflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eS39
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.core.render.AbstractRenderEngine;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    
    public class FlashTest extends Sprite {
    	    private var _viewport1:Viewport3D;
    	    private var _viewport2:Viewport3D;
    	    private var _viewport3:Viewport3D;
    	    private var _scene1:Scene3D;
    	    private var _scene2:Scene3D;
    	    private var _scene3:Scene3D;
    	    private var _render1:BasicRenderEngine;
    	    private var _render2:BasicRenderEngine;
    	    private var _render3:BasicRenderEngine;
    	    private var _camera1:Camera3D;
    	    private var _camera2:Camera3D;
    	    private var _camera3:Camera3D;
    	    private var _currentCamera:Camera3D;
    	    private var _world:DisplayObject3D;
    	    
    	    private var _sphere1:Sphere;
    	    private var _sphere2:Sphere;
    	    private var _sphere3:Sphere;
    	    
    	    
    	    
        public function FlashTest() {
            _initialize3D();
        }
        
        private function _initialize3D():void {
        	    _viewport1 = new Viewport3D( 0, 0, true, false, true, true );
        	    addChild( _viewport1 );
        	    
        	    _viewport2 = new Viewport3D( 0, 0, true, false, true, true );
        	    _viewport2.y = 100;
        	    addChild( _viewport2 );
        	    
        	    _viewport3 = new Viewport3D( 0, 0, true, false, true, true );
        	    addChild( _viewport3 );
        	    
        	    _scene1 = new Scene3D();
        	    _scene2 = new Scene3D();
        	    _scene3 = new Scene3D();
        	    
        	    _render1 = new BasicRenderEngine();
        	    _render2 = new BasicRenderEngine();
        	    _render3 = new BasicRenderEngine();
        	    
        	    _camera1 = new Camera3D();
        	    _camera1.z = -1000;
        	    _camera2 = new Camera3D();
        	    _camera2.x = -1000;
        	    _camera2.y = -500;
        	    _camera2.z = -1000;
        	    _camera3 = new Camera3D();
        	    _camera3.x = 1000; 
        	    _camera3.z = -2000;
        	    _currentCamera = _camera1;
        	          	    
        	    _sphere1 = new Sphere( new WireframeMaterial( 0xFF00FF, 1 ) );
        	    _sphere1.x = 500;
        	    _scene1.addChild( _sphere1 );
        	    
        	    _sphere2 = new Sphere( new WireframeMaterial( 0x00FFFF, 1 ) );
        	    _sphere2.x = 0;
        	    _scene2.addChild( _sphere2 );
        	    
        	    _sphere3 = new Sphere( new WireframeMaterial( 0x0000FF, 1 ) );
        	    _sphere3.x = -500;
        	    _scene3.addChild( _sphere3 );
        	    
        	    _camera2.target =_sphere2;
        	    addEventListener( Event.ENTER_FRAME, _onRenderTick );     
        }
        
        private function _onRenderTick( e:Event ):void {
        	    _render1.renderScene( _scene1, _currentCamera, _viewport1 );
        	    if( _camera1.z < -900 || _camera1.z > -800 )_render1.renderScene( _scene2, _currentCamera, _viewport2 );
        	    _render1.renderScene( _scene3, _camera2, _viewport3 );
        	    
        	    //_camera1.z ++;
        	    //_viewport1.x ++;
        	    _sphere1.x --;
        	    _sphere2.x --;
        	    _sphere3.x --;      
        }
    }
}