/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eRNS
 */

// forked from HaraMakoto's ローディング
package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	
	import frocessing.color.ColorHSV;
	
	[SWF(backgroundColor="0x000000", width="465", height="465", frameRate="60")]
	public class Wonderfloader extends Sprite {
		private var DisplayBase:Sprite = new Sprite();
		private var stripeBase:Sprite = new Sprite();
		private var stripeList:Array = new Array();
		private var stripeNum:int = 50;
		private var W:Number = 695;
		private var H:Number = 695;
		private var bmp:Bitmap;
		private var bmd:BitmapData = new BitmapData(W,H,false,0);
		private var inited:Boolean = false;
		private var completed:Boolean = false;
		
		//debug
		private var counter:int= 0;
		
		private var txtDisplay:textDisplay = new textDisplay();
		
		public function Wonderfloader():void {
			
			bmp = new Bitmap(bmd);
			DisplayShortcuts.init();
			
			addChild(DisplayBase);
			DisplayBase.addChild(bmp);
			DisplayBase.addChild(stripeBase);
			
			addChild(txtDisplay);
			txtDisplay.x = int(465/2);
			txtDisplay.y = int(465/2);
			txtDisplay.text = "";
			txtDisplay.visible = false;
			
			stripeBase.graphics.beginFill(0x000000);
			stripeBase.graphics.drawRect(0,0,W,H);
			stripeBase.graphics.endFill();
			
			makeSprites();
			
			var mat:Matrix = new Matrix();
			mat.translate(-W/2,-H/2-150);
			mat.rotate(-45*Math.PI/180);
			mat.translate(W/2,H/2);
			mat.concat(DisplayBase.transform.matrix);
			DisplayBase.transform.matrix = mat;
			
			//loadStart();
		}

//--------------------------------------------------------------------------------//
// public method
//--------------------------------------------------------------------------------//
		public function loadStart():void {
			txtDisplay.visible = true;
			var i:int=0;
			var _f:Function = null;
			for(i=0; i<stripeNum; i++) {
				if(i==stripeNum-1) _f = onCompleteHandler;
				Tweener.addTween(stripeList[i], {scaleX:1, time:0.4, delay:0.01*i, 
					transition:Equations.easeOutQuint, onComplete:_f});
			}
		}
		public function loadComplete():void {
			completed = true;
			if(!inited) return;
			var i:int=0;
			var _f:Function = null;
			txtDisplay.onComplete();
			Tweener.addTween(bmp, {_autoAlpha:0, time:1, delay:1, transition:Equations.easeOutQuint, onComplete:onloadCompleteHandler});
		}
		public function attachLoadValue(n:Number = 0):void {
			txtDisplay.text = "Loading " + String(int(n*100))+"%";
		}

//--------------------------------------------------------------------------------//
// private method
//--------------------------------------------------------------------------------//
		
		private function makeSprites():void {
			var i:int;
			var yNum:Number = 0;
			var hnum:Number = H;
			for(i=0; i<stripeNum; i++) {
				var barH:Number
				if(i==stripeNum-1) {
					barH = hnum;
				} else {
					barH = Math.min(hnum*Math.random(), 2+30*Math.random());
					hnum = hnum - barH;
				}
				var sp:Sprite = new Sprite();
				stripeBase.addChild(sp);
				makeStripeUnit(sp, barH*0.5);
				sp.y = yNum;
				yNum += barH;
				sp.scaleX = 0;
				stripeList.push(sp);
			}
		}
		
		private function makeStripeUnit(mc:Sprite, h:Number):void {
			var col:ColorHSV = new ColorHSV(random(0.95,1), random(0.2,1), random(0.3,1));
			mc.graphics.beginFill(col.value);
			mc.graphics.drawRect(0,0,W,h);
			mc.graphics.endFill();
		}
		
		private function random(min:Number, max:Number):Number {
			return min+(max-min)*Math.random();
		}

		private function onCompleteHandler():void {
			addEventListener(Event.ENTER_FRAME, handleEnterFrame);
			stripeBase.visible = false;
			bmd.draw(stripeBase);
			inited = true;
			if(completed) loadComplete();
		}
		private var rct:Rectangle = new Rectangle(0,H-10,W,4);
		
		
		private function handleEnterFrame(event:Event):void {
//			if(counter > 280) {
//				loadComplete();
//			}
			bmd.scroll(0,-1);
			if(Math.random()>0.8) {
				rct.height = 2+5*Math.random();
				var col:ColorHSV = new ColorHSV(random(0.95,1), random(0.2,1), random(0.3,1));
				bmd.fillRect(rct, col.value);
			}
			slide();
//			counter++;
		}
		private function slide():void {
			var i:int=0;
			for(i=0; i<stripeNum; i++) {
				stripeList[i].y -= 1.5;
			}
			if(stripeList[0].y+stripeList[0].height < 0) slideloop();
		}
		
		private function slideloop():void {
			var sp:Sprite = stripeList[0];
			stripeList.shift();
			sp.y = stripeList[stripeList.length-1].y+stripeList[stripeList.length-1].height*2;
			stripeList.push(sp);
		}
		
		private function onloadCompleteHandler():void{
			removeEventListener(Event.ENTER_FRAME, handleEnterFrame);
			DisplayBase.removeChild(bmp);
			DisplayBase.removeChild(stripeBase);
			removeChild(DisplayBase);
			removeChild(txtDisplay);
			
			bmd.dispose();
			for(var i:int=0; i<stripeList.length; i++) {
				stripeBase.removeChild(stripeList[i]);
				stripeList[i] = null;
			}
			bmp = null;
			DisplayBase = null;
			stripeBase = null;
		}
	}
	
}
	import flash.display.Sprite;
	import flash.text.TextField;
	import com.bit101.components.Style;
	import flash.text.TextFormat;
	import com.bit101.components.Label;
	import flash.geom.ColorTransform;
	import caurina.transitions.properties.ColorShortcuts;
	import caurina.transitions.Tweener;
	import caurina.transitions.Equations;
	

class textDisplay extends Sprite {
	private var tField:TextField;
	private var _text:String = "";
	private var _height:Number;
	private var _label:Label;
	public var alphaANgle:Number = 0;
	
	public function textDisplay() {
		this.transform.colorTransform = new ColorTransform(1,1,1,1,255,255,255);
		_label = new Label(this, 0,0,"");
	}
	
	public function set text(t:String):void
	{
		_text = t;
		_label.text = _text;
		_label.x = -_text.length*4/2;
	}
	public function get text():String
	{
		return _text;
	}
	
	public function onComplete():void {
		Tweener.addTween(this, {alphaANgle:180, time:0.5, transition:Equations.easeNone, onUpdate:onUpdateHandler});
		_label.text = "complete!!";
		_label.x = -_text.length*4/2
	}
	private function onUpdateHandler():void {
		this.alpha = Math.cos(alphaANgle);
	}
	
}