/**
 * Copyright nan05aur ( http://wonderfl.net/user/nan05aur )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eRJR
 */

// forked from nan05aur's forked from:簡単なゲームのサンプル_2011_09_21
// forked from nan05aur's forked from: forked from:的を動かす
// forked from nan05aur's forked from:的を動かす
// forked from nan05aur's forked from: 的に弾が当たった時の演習のサンプル_連射
// forked from shmdmoto's 的に弾が当たった時の演習のサンプル
package 
{
    import flash.system.IME;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    
    import frocessing.display.F5MovieClip2D;
    [SWF(width = 465, height = 465, frameRate = 60)]
    /**
     * マウスでクリックしたところから円が広がる
     * @author shmdmoto
     */
    public class miniGame2 extends F5MovieClip2D
    {
        public var posX:Number;
        public var posY:Number;
        public var sparkX:Array;
        public var sparkY:Array;
        public var sparkVX:Array;
        public var sparkVY:Array;
        public var intS:Array;
        public var isContLeft:Boolean; // ←が押し続けられているか
        public var isContRight:Boolean; // →が押し続けられているか
        public var isContUp:Boolean; // ↑が押し続けられているか
        public var isContDown:Boolean; // ↓が押し続けられているか
        public var bulletX:Array; // 弾のX座標
        public var bulletY:Array; // 弾のY座標
        public var bulletFrag:Array;
        public var targetX:Array; // 的の中心のx座標
        public var targetY:Array; // 的の中心のy座標
        public var targetHit:Array;  // 的に命中したかどうか
        public var targetLife:Array; // 的の体力
        public var intR:Array;   // 当たった時の演出の円の直径
        public var circX:Array; // 当たった時の演出の円の中心のx座標
        public var circY:Array; // 当たった時の演出の円の中心のy座標
        public var mN:int = 50;
        public var tMn:int = 10;
        public var pi:Number = 3.14;
        public var v:Number = 5;
        public var sv:Number = 0;
        public function miniGame2() {
            super(false);
        }
        public function setup() : void
        {
            isContLeft  = false;
            isContRight = false;
            posX = stage.stageWidth / 2;
            posY = stage.stageHeight - 50;
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            // 的の初期設定
            targetX = new Array(tMn);
            targetY = new Array(tMn);
            targetHit = new Array(tMn);
            targetLife = new Array(tMn);
            // 弾のY座標
            bulletX = new Array(mN);
            bulletY = new Array(mN);
            bulletFrag = new Array(mN)
            // 当たった時の演出
            intR = new Array(mN);
            circX = new Array(mN);
            circY = new Array(mN);
            // 破片
            intS = new Array(mN);
            sparkX = new Array(mN);
            sparkY = new Array(mN);
            sparkVX = new Array(mN);
            sparkVY = new Array(mN);
            for( var i:int = 0 ; i < tMn ; i++ )
            {
                targetX[i] = new LFO( 10, stage.stageWidth / 2,
                                       stage.stageWidth / 2,
                                       random(2.0));
                targetX[i].setType(LFO.TRI);
                targetY[i] = new Number();
                targetY[i] = random( 10, 300 );
                targetHit[i] = new Boolean();
                targetHit[i] = false;
                targetLife[i] = random(1,5);
            }
            for( i = 0 ; i < mN ; i++ )
            {
                bulletY[i] = new Interpolate(2, posY,0);
                bulletY[i].pause();
                bulletFrag[i] = new Boolean(); 
                bulletFrag[i] = false;
                intR[i] = new Interpolate(0.5, 20, 150);
                intR[i].pause();
                circX[i] = new Number();
                circX[i] = 0.0;
                circY[i] = new Number();
                circY[i] = 0.0;
                intS[i] = new Interpolate(1, 20, 150);
                intS[i].pause();
                sparkX[i] = new Number();
                sparkX[i] = 0.0;
                sparkY[i] = new Number();
                sparkY[i] = 0.0;
                sparkVX[i] = new Number();
                sparkVX[i] = random(1000) - 500;
                sparkVY[i] = new Number();
                sparkVY[i] = random(500);
            }
        }
        public function draw() : void
        {
           // 弾の表示
            /*for( var i:int = 0 ; i < mN ; i++ )
            {// Interpolateが動作中ならば弾を表示
             for( var j:int = 0 ; j < tMn ; j++ )
             {
                if( bulletY[i].isRunning() && !targetHit[j] ) 
                { 
                 if( dist(targetX[j].val(), targetY[j], 
                     bulletX[i], bulletY[i].val()) < 30 ) 
                     {
                         targetLife[j]--;
                         bulletY[i].pause(); // 当たったら弾は無効
                         intS[i].start();    // 当たった時の演出開始
                         //sparkX[i] = bulletX[i];
                         //sparkY[i] = bulletY[i]/*.val();
                         sparkX[i] = stage.stage.width / 2;
                         sparkY[i] = stage.stage.height / 2;
                         //initCircle();
                         if( targetLife[j] < 0 )
                         {
                             targetHit[j] = true;
                             intR[i].start();    // 当たった時の演出開始
                             circX[i] = targetX[j].val();
                             circY[i] = targetY[j];
                             //circX[i] = bulletX[i];
                             //circY[i] = bulletY[i].val();
                         }
                         break;
                         }
                else
                {
                noStroke();
                fill(255,0,0);
                ellipse(bulletX[i],
                        bulletY[i].val(),
                        10, 10);
                }
               }
              }
            }*/
            // 当たった時の演出表示
            drawRing();
            // 的の表示
            drawTarget();
            drawPlayer();
            drawBullet();
            drawSpark();
        }
        public function onKeyDown(event:KeyboardEvent) : void
        {
            // 弾を発射中は再度発射できない
            for( var i:int = 0 ; i < mN ; i++ )
            {
                if( !bulletFrag[i] &&
                    event.keyCode == Keyboard.SPACE ) {
                bulletX[i] = posX;
                bulletY[i] = posY-25;
                bulletFrag[i] = true;
                break;
                }
            }
            
            if( event.keyCode == Keyboard.LEFT ){isContLeft = true;}
            if( event.keyCode == Keyboard.RIGHT ){isContRight = true;}
            if( event.keyCode == Keyboard.UP ){isContUp = true;}
            if( event.keyCode == Keyboard.DOWN ){isContDown = true;}
        }
        public function onKeyUp(event:KeyboardEvent):void
        {
            if( event.keyCode == Keyboard.LEFT ){isContLeft = false;}
            if( event.keyCode == Keyboard.RIGHT ){isContRight = false;}
            if( event.keyCode == Keyboard.UP ){isContUp = false;}
            if( event.keyCode == Keyboard.DOWN ){isContDown = false;}
        }
        public function drawPlayer():void
        {
            rectMode(CENTER);
            //fill(0);
            noFill();
            stroke(0);
            //noStroke();
            if( isContLeft )posX-=7;
            if( isContRight )posX+=7;
            if( isContUp )posY-=7;
            if( isContDown )posY+=7;
            // 画面隅の接触
            if( posX < 25 ){posX=25;}
            if( posX + 25 > stage.stageHeight ){posX=stage.stageHeight-25;}
            if( posY < 25 ){posY=25;}
            if( posY + 25 > stage.stageHeight ){posY=stage.stageHeight-25;}
            rect(posX, posY, 50, 50);
        }
        public function drawBullet():void
        {
            for( var i:int = 0 ; i < mN ; i++ )
            {
                if( bulletFrag[i] )
                {
                    noStroke();
                    fill(255,0,0);
                    ellipse( bulletX[i],bulletY[i],10, 10 );
                    bulletY[i] -= v;
                    hitTarget( bulletX[i], bulletY[i], i );
                    initCircle( bulletX[i], bulletY[i] );
                    intS[i].start();
                }
                if( bulletX[i] < -10 || bulletX[i] > stage.stageWidth ||
                    bulletY[i] < -10 || bulletY[i] > stage.stageHeight )
                {
                    bulletFrag[i] = false;
                }
            }
        }
        public function hitTarget( bX:Number, bY:Number, j:int ):void
        {
            for( var i:int = 0 ; i < tMn ; i ++ )
            {
                if( dist(targetX[i].val(), targetY[i],
                    bX, bY ) < 30 && !targetHit[i] )
                {
                    //initCircle( bulletX[i], bulletY[i] );
                    //intS[i].start();
                    targetLife[i]--;
                    bulletFrag[j] = false;
                }
            }
        }
        public function drawTarget():void
        {
            for( var i:int = 0 ; i < tMn ; i++ )
            {
                if( !targetHit[i] /*&& targetY[i] < 300*/ ) 
                {
                    stroke(0);
                    fill(100+targetLife[i]*30);
                    ellipse(targetX[i].val(), targetY[i],
                            50, 50);
                    if( targetLife[i] < 0 )
                    {
                        targetHit[i] = true;
                        intR[i].start();    // 当たった時の演出開始
                        circX[i] = targetX[i].val();
                        circY[i] = targetY[i];
                        //circX[i] = bulletX[i];
                        //circY[i] = bulletY[i].val();
                    }
                }
            }
        }
        public function drawRing():void
        {
            for( var i:int = 0 ; i < mN ; i++ )
            {
                if( intR[i].isRunning() )
                {
                    noFill();
                    stroke( 255 * intR[i].val()/150);
                    ellipse(circX[i], circY[i],
                            intR[i].val(), intR[i].val() );
                }
            }
        }
        public function drawSpark():void
        {
           if( intS[i].isRunning() )
           {
                //stroke( 255 * intS[i].val()/150);
                //rectMode(CENTER);
                for( var i:int = 0 ; i < mN ; i++ )
                {//if( intS[i].isRunning() ){
                    fill(255,0,0/*,intS[i].val()/150*/);
                    //strokeWeight(3);
                    //stroke(255,255,0);
                    //noStroke();
                    //noFill()
                    ellipse( sparkX[i], sparkY[i], 3,3);
                    sparkX[i] += sparkVX[i];
                    sparkY[i] += sparkVY[i];}
                }
            //}
        }
        public function initCircle(bx:Number,by:Number):void
        {
            var odd:Boolean;
            var radStep:Number = pi * 2 / mN;
            var rad:Number = odd ? radStep / 2 : 0;
            for( var i:int = 0 ; i < mN ; i++, rad += radStep )
            {
                sparkX[i] = bx;
                sparkY[i] = by;
                sv = random(0.5,9);
                sparkVX[i] = cos( rad ) * sv;
                sparkVY[i] = sin( rad ) * sv;
            }
        }
    }
}

// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
        tOffset = 0;
        tElapsed = 0;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                    Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                    Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                    Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                    Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                    Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                    Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}    